/*
 * Decompiled with CFR 0.152.
 */
package org.arbor.extrasounds.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.VolumeSlider;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.arbor.extrasounds.ExtraSounds;
import org.arbor.extrasounds.gui.VolumeButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoundList
extends ContainerObjectSelectionList<SoundEntry> {
    public SoundList(Minecraft minecraftClient, int i, int j, int k, int l, int m) {
        super(minecraftClient, i, j, k, l, m);
        this.f_93394_ = false;
    }

    public void addSingleOptionEntry(OptionInstance<?> option) {
        this.m_7085_((AbstractSelectionList.Entry)SoundEntry.create(this.f_93386_.f_91066_, this.f_93388_, option));
    }

    public void addOptionEntry(OptionInstance<?> firstOption, @Nullable OptionInstance<?> secondOption) {
        this.m_7085_((AbstractSelectionList.Entry)SoundEntry.createDouble(this.f_93386_.f_91066_, this.f_93388_, firstOption, secondOption));
    }

    public void addAll(OptionInstance<?>[] options) {
        for (int i = 0; i < options.length; i += 2) {
            this.addOptionEntry(options[i], i < options.length - 1 ? options[i + 1] : null);
        }
    }

    public void addCategory(SoundSource soundSource) {
        this.m_7085_((AbstractSelectionList.Entry)SoundEntry.create(this.f_93386_, this.f_93388_, soundSource));
    }

    public void addDoubleCategory(SoundSource first, @Nullable SoundSource second) {
        this.m_7085_((AbstractSelectionList.Entry)SoundEntry.createDouble(this.f_93386_, this.f_93388_, first, second));
    }

    public void addAllCategory(SoundSource[] options) {
        for (int i = 0; i < options.length; i += 2) {
            this.addDoubleCategory(options[i], i < options.length - 1 ? options[i + 1] : null);
        }
    }

    public void addGroup(SoundSource group, Button.OnPress pressAction) {
        super.m_7085_((AbstractSelectionList.Entry)SoundEntry.createGroup(group, this.f_93388_, pressAction));
    }

    public int m_5759_() {
        return 400;
    }

    protected int m_5756_() {
        return super.m_5756_() + 32;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class SoundEntry
    extends ContainerObjectSelectionList.Entry<SoundEntry> {
        List<? extends AbstractWidget> widgets;

        public SoundEntry(List<? extends AbstractWidget> w) {
            this.widgets = w;
        }

        public static SoundEntry create(Options options, int width, OptionInstance<?> simpleOption) {
            return new SoundEntry(List.of(simpleOption.m_231507_(options, width / 2 - 155, 0, 310)));
        }

        public static SoundEntry createDouble(Options options, int width, OptionInstance<?> first, @Nullable OptionInstance<?> second) {
            ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
            widgets.add(first.m_231507_(options, width / 2 - 155, 0, 150));
            if (second != null) {
                widgets.add(second.m_231507_(options, width / 2 + 5, 0, 150));
            }
            return new SoundEntry(widgets);
        }

        public static SoundEntry create(Minecraft minecraft, int width, SoundSource soundSource) {
            return new SoundEntry(List.of(new VolumeSlider(minecraft, width / 2 - 155, 0, soundSource, 310)));
        }

        public static SoundEntry createDouble(Minecraft minecraft, int width, SoundSource first, @Nullable SoundSource second) {
            ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
            SoundEntry.addVolumeSlider(minecraft, width, widgets, 0, first);
            if (second != null) {
                SoundEntry.addVolumeSlider(minecraft, width, widgets, 160, second);
            }
            return new SoundEntry(widgets);
        }

        public static void addVolumeSlider(Minecraft minecraft, int width, List<AbstractWidget> widgets, int offset, SoundSource soundSource) {
            Pair<Boolean, Boolean> toggleable = ExtraSounds.TOGGLEABLE_CATS.get(soundSource);
            if (toggleable != null && ((Boolean)toggleable.getFirst()).booleanValue()) {
                widgets.add((AbstractWidget)new VolumeButton(minecraft, width / 2 - 155 + offset, 0, soundSource, 150));
                return;
            }
            widgets.add((AbstractWidget)new VolumeSlider(minecraft, width / 2 - 155 + offset, 0, soundSource, 150));
        }

        public static SoundEntry createGroup(SoundSource group, int width, Button.OnPress pressAction) {
            return new SoundEntry(List.of(new VolumeSlider(Minecraft.m_91087_(), width / 2 - 155, 0, group, 285), new ImageButton(width / 2 + 135, 0, 20, 20, 0, 0, 20, ExtraSounds.SETTINGS_ICON, 20, 40, pressAction)));
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return this.widgets;
        }

        @NotNull
        public List<? extends NarratableEntry> m_142437_() {
            return this.widgets;
        }

        public void m_6311_(@NotNull PoseStack context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.widgets.forEach(s -> {
                s.f_93621_ = y;
                s.m_6305_(context, mouseX, mouseY, tickDelta);
            });
        }
    }
}

