/*
 * Decompiled with CFR 0.152.
 */
package com.nekotune.battlemusic;

import com.mojang.serialization.DataResult;
import com.nekotune.battlemusic.BattleMusic;
import com.nekotune.battlemusic.ModConfigs;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class EntityMusic {
    public static final double MAX_SONG_RANGE = 256.0;
    private static float masterVolume = ((Double)ModConfigs.VOLUME.get()).floatValue();
    private static final HashMap<SoundEvent, EntityMusicInstance> INSTANCES = new HashMap();
    private static final HashMap<EntityType<?>, SoundData> ENTITY_SOUND_DATA = new HashMap();

    public static boolean isPlaying(SoundEvent soundEvent) {
        return INSTANCES.get(soundEvent) != null;
    }

    public static HashMap<SoundEvent, EntityMusicInstance> getInstances() {
        return EntityMusic.cloneHashMap(INSTANCES);
    }

    public static void updateEntitySoundData() {
        ENTITY_SOUND_DATA.clear();
        List entityDataStrings = (List)ModConfigs.ENTITIES_SONGS.get();
        String ERROR_MSG = "Error loading entity music data from battlemusic config: ";
        for (String entityDataString : entityDataStrings) {
            EntityType entityType = null;
            SoundEvent soundEvent = null;
            String entityString = entityDataString.substring(0, entityDataString.indexOf(59));
            DataResult weakEntityResource = ResourceLocation.m_135837_((String)entityString);
            if (weakEntityResource.get().left().isPresent()) {
                ResourceLocation resource = (ResourceLocation)weakEntityResource.get().left().get();
                entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resource);
            }
            if (entityType == null || entityType == EntityType.f_20510_) {
                BattleMusic.LOGGER.warn("Error loading entity music data from battlemusic config: Skipping invalid entity ID \"" + entityString + "\"");
                continue;
            }
            String soundString = entityDataString.substring(entityDataString.indexOf(59) + 1, entityDataString.lastIndexOf(59));
            DataResult weakSoundResource = ResourceLocation.m_135837_((String)soundString);
            if (weakSoundResource.get().left().isPresent()) {
                ResourceLocation resource = (ResourceLocation)weakSoundResource.get().left().get();
                soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(resource);
            }
            if (soundEvent == null) {
                BattleMusic.LOGGER.error("Error loading entity music data from battlemusic config: Invalid sound ID \"" + soundString + "\" in line \"" + entityDataString + "\", skipping");
                continue;
            }
            int priority = 0;
            String priorityString = entityDataString.substring(entityDataString.lastIndexOf(59) + 1, entityDataString.lastIndexOf(59) + 2);
            try {
                priority = Integer.parseInt(priorityString);
            }
            catch (Exception e) {
                BattleMusic.LOGGER.error("Error loading entity music data from battlemusic config: Invalid priority \"" + priorityString + "\" in line \"" + entityDataString + "\", defaulting to 0");
            }
            BattleMusic.LOGGER.debug("Added battle music " + soundEvent.m_11660_() + " to " + entityType + " with priority " + priority);
            ENTITY_SOUND_DATA.put(entityType, new SoundData(soundEvent, priority));
        }
        String defaultSongString = (String)ModConfigs.DEFAULT_SONG.get();
        if (!defaultSongString.isEmpty()) {
            SoundEvent defaultSong = null;
            DataResult weakDefaultSongResource = ResourceLocation.m_135837_((String)defaultSongString);
            if (weakDefaultSongResource.get().left().isPresent()) {
                ResourceLocation resource = (ResourceLocation)weakDefaultSongResource.get().left().get();
                defaultSong = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(resource);
            }
            if (defaultSong == null) {
                BattleMusic.LOGGER.error("Error loading entity music data from battlemusic config: Invalid default song sound ID \"" + defaultSongString + "\"");
            } else {
                for (EntityType e : ForgeRegistries.ENTITY_TYPES.getValues()) {
                    ENTITY_SOUND_DATA.putIfAbsent(e, new SoundData(defaultSong, Integer.MIN_VALUE));
                }
            }
        }
        for (EntityMusicInstance instance : INSTANCES.values()) {
            instance.destroy();
        }
    }

    public static <T, K> HashMap<T, K> cloneHashMap(HashMap<T, K> hashMap) {
        HashMap<T, K> clone = new HashMap<T, K>();
        for (T key : hashMap.keySet()) {
            clone.put(key, hashMap.get(key));
        }
        return clone;
    }

    public static HashMap<EntityType<?>, SoundData> getEntitySoundData() {
        return EntityMusic.cloneHashMap(ENTITY_SOUND_DATA);
    }

    public static void setMasterVolume(float newVolume) {
        if (((Boolean)ModConfigs.LINKED_TO_MUSIC.get()).booleanValue()) {
            newVolume *= Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MUSIC);
        }
        for (EntityMusicInstance instance : EntityMusic.getInstances().values()) {
            instance.setVolume(instance.m_7769_() * (newVolume / masterVolume));
            masterVolume = newVolume;
            if (!(instance.m_7769_() > masterVolume)) continue;
            instance.setVolume(masterVolume);
        }
    }

    public static boolean isValidEntity(Mob mob) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        assert (player != null);
        if (!(ENTITY_SOUND_DATA.get(mob.m_6095_()) == null || !mob.f_19853_.equals(player.f_19853_) || mob.m_21224_() || mob.m_5803_() || mob.m_7307_((Entity)player.self()) || mob.m_21525_() || mob instanceof NeutralMob && !((NeutralMob)mob).m_21674_((LivingEntity)player))) {
            double followRange;
            if (mob.m_5448_() instanceof Player) {
                return true;
            }
            AttributeInstance frAttribute = mob.m_21051_(Attributes.f_22277_);
            double d = followRange = frAttribute != null ? frAttribute.m_22135_() : 256.0;
            if (mob instanceof EnderDragon) {
                followRange = 300.0;
            }
            return mob.m_21040_((LivingEntity)player, TargetingConditions.m_148352_().m_26883_(followRange).m_148355_().m_26893_());
        }
        return false;
    }

    public static void spawnInstance(SoundData soundData, LocalPlayer player, Mob entity, @Nullable Float fadeInSeconds) {
        if (fadeInSeconds == null) {
            fadeInSeconds = Float.valueOf(((Double)ModConfigs.FADE_TIME.get()).floatValue());
        }
        EntityMusicInstance entityMusicInstance = new EntityMusicInstance(soundData, player, entity, fadeInSeconds.floatValue());
        INSTANCES.put(soundData.soundEvent, entityMusicInstance);
        Minecraft.m_91087_().m_91106_().m_120372_((TickableSoundInstance)entityMusicInstance);
    }

    static {
        EntityMusic.updateEntitySoundData();
    }

    public record SoundData(SoundEvent soundEvent, int priority) {
    }

    public static class EntityMusicInstance
    extends AbstractTickableSoundInstance {
        public final SoundData SOUND_DATA;
        public final LocalPlayer PLAYER;
        public final Mob ENTITY;
        private float fadeSeconds;
        private boolean fadingIn;

        public EntityMusicInstance(@NotNull SoundData soundData, LocalPlayer player, Mob entity, float fadeInSeconds) {
            super(soundData.soundEvent, SoundSource.NEUTRAL, RandomSource.m_216327_());
            this.f_119578_ = true;
            this.f_119582_ = true;
            this.SOUND_DATA = soundData;
            this.PLAYER = player;
            this.ENTITY = entity;
            this.f_119573_ = fadeInSeconds == 0.0f ? masterVolume : 0.0f;
            this.fadeSeconds = fadeInSeconds;
            this.fadingIn = fadeInSeconds > 0.0f;
        }

        public void m_7788_() {
            List list;
            boolean belowHpThreshold;
            if (this.m_7801_()) {
                return;
            }
            SoundManager soundManager = Minecraft.m_91087_().m_91106_();
            soundManager.m_120386_(null, SoundSource.MUSIC);
            if (this.fadeSeconds > 0.0f) {
                if (this.fadingIn) {
                    this.f_119573_ += masterVolume / (this.fadeSeconds * 20.0f);
                    if (this.f_119573_ >= masterVolume) {
                        this.f_119573_ = masterVolume;
                        this.fadeSeconds = 0.0f;
                        this.fadingIn = false;
                    }
                } else {
                    this.f_119573_ -= masterVolume / (this.fadeSeconds * 20.0f);
                    if (this.f_119573_ <= 0.0f) {
                        this.destroy();
                    }
                }
            } else if (!EntityMusic.isValidEntity(this.ENTITY)) {
                this.fadeOut(2.0f);
            }
            float pitchMod = 1.0f;
            if (((Boolean)ModConfigs.HEALTH_PITCH_PERCENT.get()).booleanValue()) {
                belowHpThreshold = this.PLAYER.m_21223_() / this.PLAYER.m_21233_() * 100.0f <= (float)((Integer)ModConfigs.HEALTH_PITCH_THRESH.get()).intValue();
            } else {
                boolean bl = belowHpThreshold = this.PLAYER.m_21223_() <= (float)((Integer)ModConfigs.HEALTH_PITCH_THRESH.get()).intValue();
            }
            if (belowHpThreshold && !(this.ENTITY instanceof Warden)) {
                pitchMod = (float)((double)pitchMod + (Double)ModConfigs.HEALTH_PITCH_AMOUNT.get());
            }
            if (this.ENTITY instanceof EnderDragon && ((EnderDragon)this.ENTITY).f_31086_ == null && (list = this.ENTITY.m_9236_().m_45976_(EndCrystal.class, AABB.m_165882_((Vec3)new Vec3(0.0, 60.0, 0.0), (double)64.0, (double)64.0, (double)64.0))).isEmpty()) {
                pitchMod = (float)((double)pitchMod + (Double)ModConfigs.DRAGON_PITCH_AMOUNT.get());
            }
            this.f_119574_ = pitchMod;
        }

        public boolean m_7784_() {
            return true;
        }

        public void setVolume(float volume) {
            this.f_119573_ = volume;
        }

        public void setPitch(float pitch) {
            this.f_119574_ = pitch;
        }

        public void destroy() {
            this.m_119609_();
            SoundManager soundManager = Minecraft.m_91087_().m_91106_();
            soundManager.m_120399_((SoundInstance)this);
            INSTANCES.remove(this.SOUND_DATA.soundEvent);
        }

        public void fadeOut(float seconds) {
            this.fadingIn = false;
            this.fadeSeconds = seconds;
            if (seconds == 0.0f) {
                this.destroy();
            }
        }
    }
}

