/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class WrappedList<E>
implements Iterable<E> {
    protected final Class<E> type;
    protected final List<E> list;

    public WrappedList(Class<E> type) {
        Objects.requireNonNull(type, "type must not be null.");
        this.type = type;
        this.list = Lists.newArrayList();
    }

    public final Class<E> getType() {
        return this.type;
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    public boolean add(E element) {
        return this.filter(element) && this.list.add(element);
    }

    public boolean add(int index, E element) {
        if (!this.filter(element)) {
            return false;
        }
        this.list.add(index, element);
        return true;
    }

    public boolean remove(E element) {
        return this.list.remove(element);
    }

    public void clear() {
        this.list.clear();
    }

    @Nullable
    public E get(int index) {
        return this.list.get(index);
    }

    public E get(int index, E defaultValue) {
        try {
            return this.list.get(index);
        }
        catch (IndexOutOfBoundsException ioobe) {
            return defaultValue;
        }
    }

    public int indexOf(Object element) {
        return this.list.indexOf(element);
    }

    public boolean contains(Object element) {
        return this.list.contains(element);
    }

    public int size() {
        return this.list.size();
    }

    public boolean filter(E element) {
        return element != null;
    }
}

