/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.config.ACJsonHandler;
import io.github.thecsdev.tcdcommons.api.config.annotation.NonSerialized;
import io.github.thecsdev.tcdcommons.api.config.annotation.SerializedAs;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

public class AutoConfig
implements ACJsonHandler<JsonObject> {
    protected static final String FILE_EXTENSION = "json";
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @NonSerialized
    public final String fileName;
    @NonSerialized
    public final Path filePath;

    public AutoConfig(String name) {
        this.fileName = name.strip().replaceAll("[\\\\/:*?\"<>|]", "") + ".json";
        this.filePath = FMLLoader.getGamePath().resolve("config").resolve(this.fileName);
    }

    public List<Field> getPropertyFields() {
        return Arrays.asList(this.getClass().getFields()).stream().filter(field -> field.canAccess(this) && (field.getType().isPrimitive() || ACJsonHandler.class.isAssignableFrom(field.getType())) && !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers()) && field.getAnnotation(NonSerialized.class) == null).toList();
    }

    @Nullable
    protected JsonElement serializeProperty(Field property) {
        try {
            Object val = property.get(this);
            if (ACJsonHandler.class.isAssignableFrom(property.getType())) {
                return ((ACJsonHandler)val).saveToJson();
            }
            return GSON.toJsonTree(val);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean deserializeProperty(Field property, JsonElement jEl) {
        try {
            if (ACJsonHandler.class.isAssignableFrom(property.getType())) {
                Object objVal = property.get(jEl);
                if (objVal == null) {
                    throw new NullPointerException();
                }
                ACJsonHandler val = (ACJsonHandler)objVal;
                val.loadFromJsonElement(jEl);
            } else {
                property.set(this, GSON.fromJson(jEl, property.getType()));
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getPropertyName(Field property) {
        SerializedAs sa = property.getAnnotation(SerializedAs.class);
        if (sa != null) {
            return sa.value();
        }
        return property.getName();
    }

    @Override
    public JsonObject saveToJson() {
        JsonObject result = new JsonObject();
        for (Field property : this.getPropertyFields()) {
            JsonElement serializedElement = this.serializeProperty(property);
            if (serializedElement == null) continue;
            result.add(this.getPropertyName(property), serializedElement);
        }
        return result;
    }

    @Override
    public boolean loadFromJson(JsonObject json) {
        for (Field property : this.getPropertyFields()) {
            if (!json.has(property.getName())) continue;
            this.deserializeProperty(property, json.get(this.getPropertyName(property)));
        }
        return true;
    }

    public void saveToFile(boolean log) throws IOException, SecurityException {
        JsonObject json = this.saveToJson();
        String jsonStr = GSON.toJson((JsonElement)json);
        Files.writeString(this.filePath, (CharSequence)jsonStr, StandardOpenOption.CREATE_NEW, StandardOpenOption.TRUNCATE_EXISTING);
        if (log) {
            TCDCommons.LOGGER.info("Saved '" + this.getClass().getSimpleName() + "' config to '" + this.fileName + "'.");
        }
    }

    public void loadFromFile(boolean log) throws IOException {
        if (!this.filePath.toFile().exists()) {
            return;
        }
        String jsonStr = Files.readString(this.filePath);
        JsonObject json = null;
        try {
            json = JsonParser.parseString((String)jsonStr).getAsJsonObject();
        }
        catch (Exception exc) {
            if (exc instanceof JsonParseException) {
                if (log) {
                    TCDCommons.LOGGER.error("Unable to load '" + this.fileName + "' config. Could not parse the JSON.");
                }
            }
            if (exc instanceof JsonSyntaxException) {
                if (log) {
                    TCDCommons.LOGGER.error("Unable to load '" + this.fileName + "' config. Invalid JSON syntax.");
                }
            }
            if (exc instanceof IllegalStateException) {
                if (log) {
                    TCDCommons.LOGGER.error("Unable to load '" + this.fileName + "' config. Invalid JSON element type.");
                }
            }
            throw exc;
        }
        if (json != null) {
            this.loadFromJson(json);
        }
    }
}

