/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.events.TTextFieldWidgetEvents;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.FocusOrigin;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class TTextFieldWidget
extends TElement {
    public static final int TEXT_PADDING = 5;
    protected final StringBuilder text;
    protected int textColor;
    protected int lineSpacing = 4;
    protected boolean multiline = false;
    protected MultiLineLabel multilineText;
    private TTextFieldWidgetEvents __events = new TTextFieldWidgetEvents(this);

    public TTextFieldWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.text = new StringBuilder();
        this.textColor = Color.WHITE.getRGB();
    }

    @Override
    public TTextFieldWidgetEvents getEvents() {
        return this.__events;
    }

    @Override
    public boolean canChangeFocus(FocusOrigin focusOrigin, boolean gainingFocus) {
        return true;
    }

    public boolean getMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(int spacing) {
        this.lineSpacing = Mth.m_14045_((int)spacing, (int)0, (int)20);
    }

    protected final void refreshTextRender(boolean invokeEvent) {
        String txt = this.getText();
        MutableComponent message = TextUtils.literal(txt);
        int w = Math.max(this.getTpeWidth() - 10, 10);
        this.multilineText = MultiLineLabel.m_94341_((Font)this.getTextRenderer(), (FormattedText)message, (int)w);
        if (invokeEvent) {
            this.getEvents().TEXT_CHANGED.p_invoke(handler -> handler.accept(txt));
        }
    }

    public String getText() {
        return this.text.toString();
    }

    public final void setText(String text) {
        this.setText(text, true);
    }

    public void setText(String text, boolean invokeEvent) {
        if (text == null) {
            text = "";
        }
        if (!this.getMultiline()) {
            text = text.replaceAll("[\\t\\n\\r]+", " ");
        }
        this.text.setLength(0);
        this.text.append(text);
        this.refreshTextRender(invokeEvent);
    }

    public final int getTextHeight() {
        Objects.requireNonNull(this.getTextRenderer());
        int fh = 9 + this.getLineSpacing();
        if (this.multilineText == null) {
            return fh;
        }
        return this.multilineText.m_5770_() * fh;
    }

    public void write(String text) {
        if (text == null) {
            return;
        }
        if (!this.getMultiline()) {
            text = text.replaceAll("[\\t\\n\\r]+", " ");
        }
        this.text.append(text);
        this.refreshTextRender(true);
    }

    public void unWrite(boolean isDelete) {
        if (this.getText().length() < 1) {
            return;
        }
        this.text.deleteCharAt(this.text.length() - 1);
        this.refreshTextRender(true);
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, int button) {
        return true;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || keyCode == 335) {
            this.write("\n");
            return true;
        }
        if (keyCode == 32) {
            return false;
        }
        if (TScreen.m_96638_() && super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 259 || keyCode == 261) {
            this.unWrite(keyCode == 261);
            return true;
        }
        return false;
    }

    @Override
    public boolean charTyped(char character, int modifiers) {
        this.write(Character.toString(character));
        return true;
    }

    @Override
    public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        this.renderBackground(matrices, mouseX, mouseY, deltaTime);
        this.drawText(matrices, deltaTime);
    }

    protected void renderBackground(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)T_WIDGETS_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAlpha());
        this.draw9SliceTexture(matrices, this.isFocused() ? 20 : 0, 20, 20, 20, 3);
    }

    protected void drawText(PoseStack matrices, float deltaTime) {
        if (this.multilineText == null || this.screen == null) {
            return;
        }
        Rectangle rr = this.getRenderingBoundingBox();
        if (rr == null) {
            return;
        }
        GuiUtils.enableScissor(this.screen.getClient(), rr.x, rr.y, rr.width, rr.height);
        Objects.requireNonNull(this.getTextRenderer());
        int lh = 9 + this.getLineSpacing();
        this.multilineText.m_6516_(matrices, this.getTpeX() + 5, this.getTpeY() + 5, lh, this.textColor);
        this.screen.resetScissors();
    }
}

