/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.util.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TSelectWidget
extends TButtonWidget {
    protected SWContextMenu contextMenu = null;
    protected BiConsumer<Integer, Integer> ehMoved_forDropdown;
    protected final ArrayList<SWEntry> entries = Lists.newArrayList();

    public TSelectWidget(int x, int y, int width, int height) {
        super(x, y, width, height, null, null);
        this.setMessage(TextUtils.fTranslatable("tcdcommons.gui.tselectwidget.default_label", new Object[0]));
        this.ehMoved_forDropdown = this.getEvents().MOVED.addWeakEventHandler((dX, dY) -> {
            if (this.isDropdownOpen() && this.contextMenu != null) {
                this.contextMenu.updatePositionAndSize();
            }
        });
    }

    @Override
    protected void onClick() {
        if (this.screen == null) {
            return;
        }
        super.onClick();
        if (this.isDropdownOpen()) {
            this.closeDropdownMenu();
            this.screen.setFocusedTChild(this);
            return;
        }
        this.openDropdownMenu();
    }

    public void openDropdownMenu() {
        if (this.isDropdownOpen()) {
            return;
        }
        this.contextMenu = new SWContextMenu();
        this.screen.addTChild(this.contextMenu);
        for (SWEntry entry : this.entries) {
            entry.createContextMenuItem(this.contextMenu);
        }
    }

    public void closeDropdownMenu() {
        if (!this.isDropdownOpen()) {
            return;
        }
        this.contextMenu.getTParent().removeTChild(this.contextMenu);
        this.contextMenu = null;
    }

    public boolean isDropdownOpen() {
        return this.screen != null && this.contextMenu != null && this.contextMenu.screen == this.screen;
    }

    protected void onOptionSelected(SWEntry option) {
        this.setMessage(option.message);
    }

    public TSelectWidget addDropdownOption(Component label, Runnable onSelect) {
        return this.addDropdownOption(label, onSelect, null);
    }

    public TSelectWidget addDropdownOption(Component label, Runnable onSelect, Component tooltip) {
        this.entries.add(new SWEntry(label, onSelect, tooltip));
        return this;
    }

    public TSelectWidget addDropdownSeparator() {
        this.entries.add(new SWEntry(null, null));
        return this;
    }

    public void drawDropdownArrow(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        if (this.getTpeHeight() < 10) {
            return;
        }
        float alpha = this.getAlpha();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)T_WIDGETS_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        int y4 = this.getTpeHeight() / 4;
        int y2 = this.getTpeHeight() / 2;
        int x = this.getTpeWidth() - y4 - y2;
        int uvX = !this.isDropdownOpen() ? 0 : 20;
        TSelectWidget.drawTexture(matrices, this.getTpeX() + x, this.getTpeY() + y4, y2, y2, uvX, 40.0f, 20, 20, 255, 255);
    }

    @Override
    public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        this.drawButton(matrices, mouseX, mouseY, deltaTime);
        this.drawMessage(matrices, HorizontalAlignment.LEFT, deltaTime);
        this.drawDropdownArrow(matrices, mouseX, mouseY, deltaTime);
    }

    @Override
    public TElement next() {
        if (this.isDropdownOpen() && this.contextMenu != null) {
            return this.contextMenu;
        }
        return super.next();
    }

    public final TElement super_next() {
        return super.next();
    }

    protected class SWContextMenu
    extends TContextMenuPanel {
        public SWContextMenu() {
            super(0, 0, TSelectWidget.this.getTpeWidth());
            this.updatePositionAndSize();
        }

        @Override
        public void updatePositionAndSize() {
            this.setPosition(TSelectWidget.this.getTpeX(), TSelectWidget.this.getTpeY() + TSelectWidget.this.getTpeHeight(), false);
            super.updatePositionAndSize();
        }

        @Override
        public TElement previous() {
            return TSelectWidget.this;
        }

        @Override
        public TElement next() {
            TElement snxt = super.next();
            if (snxt != null) {
                return snxt;
            }
            return TSelectWidget.this.super_next();
        }
    }

    protected class SWEntry {
        public final Component message;
        public final Runnable onClick;
        public final Component tooltip;

        public SWEntry(Component message, Runnable onClick) {
            this(message, onClick, null);
        }

        public SWEntry(Component message, Runnable onClick, Component tooltip) {
            this.message = message;
            this.onClick = onClick;
            this.tooltip = tooltip;
        }

        public void createContextMenuItem(TContextMenuPanel cMenu) {
            if (cMenu == null) {
                return;
            }
            if (this.message == null) {
                cMenu.addSeparator();
                return;
            }
            cMenu.addButton(this.message, btn -> {
                if (!TSelectWidget.this.isDropdownOpen()) {
                    return;
                }
                TSelectWidget.this.onClick();
                TSelectWidget.this.onOptionSelected(this);
                if (this.onClick != null) {
                    this.onClick.run();
                }
            }).setTooltip(this.tooltip);
        }
    }
}

