/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import io.github.thecsdev.tcdcommons.api.client.gui.widget.TSelectWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class TSelectEnumWidget<T extends Enum<T>>
extends TSelectWidget {
    protected final Class<? extends Enum<T>> enumType;
    @Nullable
    protected Enum<T> selected;
    @Nullable
    protected Function<Enum<T>, MutableComponent> enumValueToLabel;
    @Nullable
    protected Consumer<Enum<T>> onSelectionChange;

    public TSelectEnumWidget(int x, int y, int width, int height, Class<? extends Enum<T>> enumType) {
        this(x, y, width, height, enumType, null);
    }

    public TSelectEnumWidget(int x, int y, int width, int height, Class<? extends Enum<T>> enumType, @Nullable Enum<T> selectedValue) {
        this(x, y, width, height, enumType, null, null, selectedValue);
    }

    public TSelectEnumWidget(int x, int y, int width, int height, Class<? extends Enum<T>> enumType, @Nullable Function<Enum<T>, MutableComponent> enumValueToLabel, @Nullable Consumer<Enum<T>> onSelectionChange, @Nullable Enum<T> selectedValue) {
        super(x, y, width, height);
        Objects.requireNonNull(enumType, "enumType must not be null.");
        this.enumType = enumType;
        this.setEnumValueToLabel(enumValueToLabel);
        this.setOnSelectionChange(onSelectionChange);
        if (selectedValue != null) {
            this.setSelected(selectedValue, false);
        }
    }

    @Override
    protected void onOptionSelected(TSelectWidget.SWEntry option) {
    }

    @Override
    public void openDropdownMenu() {
        if (this.isDropdownOpen()) {
            return;
        }
        this.entries.clear();
        for (Enum<T> enumValue : this.enumType.getEnumConstants()) {
            this.addDropdownOption((Component)this.enumValueToLabel(enumValue), () -> this.setSelected(enumValue));
        }
        super.openDropdownMenu();
    }

    public Class<? extends Enum<T>> getEnumType() {
        return this.enumType;
    }

    public MutableComponent enumValueToLabel(Enum<T> enumValue) {
        if (enumValue == null) {
            return TextUtils.literal("null");
        }
        return this.enumValueToLabel != null ? this.enumValueToLabel.apply(enumValue) : TextUtils.literal(enumValue.toString());
    }

    @Nullable
    public Enum<T> getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable Enum<T> value) {
        this.setSelected(value, true);
    }

    public void setSelected(@Nullable Enum<T> value, boolean invokeEvent) {
        if (value == this.selected) {
            return;
        }
        this.selected = value;
        this.setMessage((Component)this.enumValueToLabel(value));
        if (invokeEvent && this.onSelectionChange != null) {
            this.onSelectionChange.accept(value);
        }
    }

    @Nullable
    public Function<Enum<T>, MutableComponent> getEnumValueToLabel() {
        return this.enumValueToLabel;
    }

    public void setEnumValueToLabel(@Nullable Function<Enum<T>, MutableComponent> enumValueToLabel) {
        this.enumValueToLabel = enumValueToLabel;
        Enum<T> sel = this.getSelected();
        if (sel != null) {
            this.setMessage((Component)this.enumValueToLabel(sel));
        }
    }

    @Nullable
    public Consumer<Enum<T>> getOnSelectionChange() {
        return this.onSelectionChange;
    }

    public void setOnSelectionChange(@Nullable Consumer<Enum<T>> onSelectionChange) {
        this.onSelectionChange = onSelectionChange;
    }
}

