/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.tcdcommons.api.client.gui.TClickableElement;
import io.github.thecsdev.tcdcommons.api.client.gui.events.TSliderWidgetEvents;
import io.github.thecsdev.tcdcommons.api.client.gui.util.Direction2D;
import io.github.thecsdev.tcdcommons.api.client.gui.util.FocusOrigin;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public abstract class AbstractTSliderWidget
extends TClickableElement {
    protected static final int BUTTON_Y_ENABLED = AbstractTSliderWidget.getButtonYImage(true, false);
    protected static final int BUTTON_Y_DISABLED = AbstractTSliderWidget.getButtonYImage(false, false);
    protected Direction2D sliderDirection;
    protected double value;
    protected int knobSize;
    protected boolean drawMessage;
    private TSliderWidgetEvents __events = new TSliderWidgetEvents(this);

    public AbstractTSliderWidget(int x, int y, int width, int height, double value) {
        super(x, y, width, height, null);
        this.setSliderDirection(Direction2D.RIGHT);
        this.setValue(value, false);
        this.setKnobSize(4);
        this.setDrawMessage(true);
    }

    @Override
    public TSliderWidgetEvents getEvents() {
        return this.__events;
    }

    @Override
    public void setPosition(int x, int y, int flags) {
        super.setPosition(x, y, flags);
        if (this.screen != null && this.screen.getDraggingTChild() == this) {
            this.setValueFromMouse(this.screen.getMouseX(), this.screen.getMouseY());
        }
    }

    public double getValue() {
        return this.value;
    }

    public boolean setValue(double value) {
        return this.setValue(value, true);
    }

    public boolean setValue(double value, boolean applyValue) {
        boolean changed;
        double oldValue = this.value;
        this.value = Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        boolean bl = changed = oldValue != this.value;
        if (applyValue && changed) {
            this.applyValue();
            this.getEvents().VALUE_CHANGED.p_invoke(handler -> handler.accept(this.value));
        }
        this.updateMessage();
        return changed;
    }

    public void setValueFromMouse(double mouseX, double mouseY) {
        int j = this.getKnobSize();
        if (this.getSliderDirection().isHorizontal()) {
            double val = (mouseX - (double)(this.x + j)) / (double)(this.width - j * 2);
            if (this.getSliderDirection() == Direction2D.LEFT) {
                val = 1.0 - Mth.m_14008_((double)val, (double)0.0, (double)1.0);
            }
            this.setValue(val);
        } else {
            double val = (mouseY - (double)(this.y + j)) / (double)(this.height - j * 2);
            if (this.getSliderDirection() == Direction2D.UP) {
                val = 1.0 - Mth.m_14008_((double)val, (double)0.0, (double)1.0);
            }
            this.setValue(val);
        }
    }

    protected abstract void applyValue();

    protected abstract void updateMessage();

    public int getKnobSize() {
        return this.knobSize;
    }

    public void setKnobSize(int size) {
        int i0 = this.getSliderDirection().isHorizontal() ? this.getTpeWidth() : this.getTpeHeight();
        this.knobSize = Mth.m_14045_((int)size, (int)4, (int)Math.max(i0, 4));
    }

    public Direction2D getSliderDirection() {
        return this.sliderDirection;
    }

    public void setSliderDirection(Direction2D direction) {
        Objects.requireNonNull(direction, "direction must not be null.");
        this.sliderDirection = direction;
    }

    public boolean getDrawMessage() {
        return this.drawMessage;
    }

    public void setDrawMessage(boolean draw) {
        this.drawMessage = draw;
    }

    @Override
    protected void onClick() {
    }

    @Override
    public boolean canChangeFocus(FocusOrigin focusOrigin, boolean gainingFocus) {
        return true;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean bl;
        Direction2D dir = this.getSliderDirection();
        boolean bl2 = dir.isHorizontal() ? keyCode == 263 || keyCode == 262 : (bl = keyCode == 265 || keyCode == 264);
        if (bl) {
            float f;
            float f2 = dir.isHorizontal() ? (float)(keyCode == 263 ? -1 : 1) : (f = (float)(keyCode == 265 ? -1 : 1));
            if (dir == Direction2D.LEFT || dir == Direction2D.UP) {
                f *= -1.0f;
            }
            float w = dir.isHorizontal() ? (float)this.getTpeWidth() : (float)this.getTpeHeight();
            return this.setValue(this.getValue() + (double)(f / (w - (float)(this.getKnobSize() * 2))));
        }
        return false;
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, int button) {
        if (button != 0) {
            return false;
        }
        this.setValueFromMouse(mouseX, mouseY);
        if (this.screen != null) {
            this.screen.setFocusedTChild(this);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        if (button != 0) {
            return false;
        }
        this.setValueFromMouse(mouseX, mouseY);
        return true;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (button != 0) {
            return false;
        }
        GuiUtils.playClickSound();
        return true;
    }

    @Override
    public boolean mouseScrolled(int mouseX, int mouseY, int amount) {
        double dAmount = Mth.m_14045_((int)amount, (int)-1, (int)1);
        double divH = this.getTpeWidth() - this.getKnobSize() * 2;
        double divV = this.getTpeHeight() - this.getKnobSize() * 2;
        switch (this.getSliderDirection()) {
            case RIGHT: {
                this.setValue(this.getValue() + dAmount / divH);
                break;
            }
            case DOWN: {
                this.setValue(this.getValue() + dAmount / divV);
                break;
            }
            case UP: {
                this.setValue(this.getValue() + -dAmount / divV);
                break;
            }
            case LEFT: {
                this.setValue(this.getValue() + -dAmount / divH);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        this.drawButton(matrices, mouseX, mouseY, deltaTime, BUTTON_Y_DISABLED);
        this.drawSliderProgressBar(matrices, mouseX, mouseY, deltaTime);
        this.drawSliderKnob(matrices, mouseX, mouseY, deltaTime);
        if (this.getDrawMessage()) {
            this.drawMessage(matrices, deltaTime);
        }
    }

    protected void drawSliderProgressBar(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        if (this.screen != null && this.value > 0.0) {
            int sX = this.getTpeX();
            int sY = this.getTpeY();
            int sW = this.getTpeWidth();
            int sH = this.getTpeHeight();
            switch (this.getSliderDirection()) {
                case RIGHT: {
                    sW = (int)(this.value * (double)sW);
                    break;
                }
                case DOWN: {
                    sH = (int)(this.value * (double)sH);
                    break;
                }
                case LEFT: {
                    sW = (int)(this.value * (double)sW);
                    sX = this.getTpeEndX() - sW;
                    break;
                }
                case UP: {
                    sH = (int)(this.value * (double)sH);
                    sY = this.getTpeEndY() - sH;
                    break;
                }
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)T_WIDGETS_TEXTURE);
            RenderSystem.m_157429_((float)0.6f, (float)0.6f, (float)0.6f, (float)this.getAlpha());
            AbstractTSliderWidget.draw9SliceTexture(matrices, sX, sY, sW, sH, 20, 0, 20, 20, 256, 256, 3);
        }
    }

    protected final void drawSliderKnob(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        int j = this.getKnobSize();
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        switch (this.getSliderDirection()) {
            case RIGHT: {
                x = this.getTpeX() + (int)(this.getValue() * (double)(this.getTpeWidth() - j * 2));
                y = this.getTpeY();
                w = j * 2;
                h = this.getTpeHeight();
                break;
            }
            case LEFT: {
                x = this.getTpeEndX() - (int)(this.getValue() * (double)(this.getTpeWidth() - j * 2)) - j * 2;
                y = this.getTpeY();
                w = j * 2;
                h = this.getTpeHeight();
                break;
            }
            case DOWN: {
                x = this.getTpeX();
                y = this.getTpeY() + (int)(this.getValue() * (double)(this.getTpeHeight() - j * 2));
                w = this.getTpeWidth();
                h = j * 2;
                break;
            }
            case UP: {
                x = this.getTpeX();
                y = this.getTpeEndY() - (int)(this.getValue() * (double)(this.getTpeHeight() - j * 2)) - j * 2;
                w = this.getTpeWidth();
                h = j * 2;
                break;
            }
            default: {
                return;
            }
        }
        this.drawSliderKnob(matrices, mouseX, mouseY, deltaTime, x, y, w, h);
    }

    protected void drawSliderKnob(PoseStack matrices, int mouseX, int mouseY, float deltaTime, int x, int y, int width, int height) {
        int uvU = (!this.isFocusedOrHovered() ? 1 : 2) * 20;
        RenderSystem.m_157456_((int)0, (ResourceLocation)T_WIDGETS_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAlpha());
        AbstractTSliderWidget.draw9SliceTexture(matrices, x, y, width, height, uvU, 0, 20, 20, 256, 256, 3);
    }
}

