/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.util;

import com.google.common.collect.Lists;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.util.WrappedList;
import io.github.thecsdev.tcdcommons.api.util.math.Tuple4;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;

public class TElementList
extends WrappedList<TElement> {
    protected final TParentElement parent;
    protected final Tuple4<TElement, TElement, TElement, TElement> topmostElements = new Tuple4();

    public TElementList(TParentElement parent) {
        super(TElement.class);
        this.parent = Objects.requireNonNull(parent, "parent must not be null.");
    }

    public TParentElement getParent() {
        return this.parent;
    }

    public Tuple4<TElement, TElement, TElement, TElement> getTopmostElements() {
        return this.topmostElements;
    }

    public void updateTopmostChildren() {
        this.topmostElements.clear();
        for (TElement child : this.list) {
            this.updateTopmostChild(child);
        }
    }

    public boolean updateTopmostChild(TElement childToCheck) {
        if (!this.list.contains(childToCheck) && childToCheck != null) {
            return false;
        }
        boolean flag = false;
        if (this.topmostElements.Item1 == null || childToCheck.getTpeY() < ((TElement)this.topmostElements.Item1).getTpeY()) {
            this.topmostElements.Item1 = childToCheck;
            boolean bl = flag = this.topmostElements.Item1 != null;
        }
        if (this.topmostElements.Item2 == null || childToCheck.getTpeY() + childToCheck.getTpeHeight() > ((TElement)this.topmostElements.Item2).getTpeY() + ((TElement)this.topmostElements.Item2).getTpeHeight()) {
            this.topmostElements.Item2 = childToCheck;
            boolean bl = flag = this.topmostElements.Item2 != null;
        }
        if (this.topmostElements.Item3 == null || childToCheck.getTpeX() < ((TElement)this.topmostElements.Item3).getTpeX()) {
            this.topmostElements.Item3 = childToCheck;
            boolean bl = flag = this.topmostElements.Item3 != null;
        }
        if (this.topmostElements.Item4 == null || childToCheck.getTpeX() + childToCheck.getTpeWidth() > ((TElement)this.topmostElements.Item4).getTpeX() + ((TElement)this.topmostElements.Item4).getTpeWidth()) {
            this.topmostElements.Item4 = childToCheck;
            flag = this.topmostElements.Item4 != null;
        }
        return flag;
    }

    @Override
    public boolean filter(TElement element) {
        if (element == null || this.parent == element) {
            return false;
        }
        for (TParentElement pe = this.parent; pe != null; pe = pe.getTParent()) {
            if (pe != element) continue;
            return false;
        }
        return element.canBeAddedTo(this.parent);
    }

    @Override
    public boolean add(TElement child) {
        return this.add(child, true);
    }

    public boolean add(TElement child, boolean reposition) {
        return this.add(this.list.size(), child, reposition);
    }

    public boolean add(int index, TElement child, boolean reposition) {
        if (super.add(index, child)) {
            TElement tElement = child.parent = this.parent instanceof TElement ? (TElement)this.parent : null;
            if (this.parent instanceof TScreen) {
                child.screen = (TScreen)this.parent;
            } else {
                child.updateScreen();
            }
            if (reposition && child.parent != null) {
                child.move(child.parent.getTpeX(), child.parent.getTpeY());
            }
            this.updateTopmostChild(child);
            child.updateRenderingBoundingBox();
            child.onParentChanged();
            if (this.getParent() instanceof TElement) {
                ((TElement)this.getParent()).getEvents().CHILD_AR.p_invoke(handler -> handler.accept((Object)child, (Object)true, (Object)reposition));
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean remove(TElement child) {
        return this.remove(child, true);
    }

    public boolean remove(TElement child, boolean reposition) {
        TElement parent = child.parent;
        if (super.remove(child)) {
            boolean c = this.topmostElements.isCleared();
            if (!c) {
                this.updateTopmostChildren();
            }
            if (reposition && parent != null) {
                child.move(child.parent.getTpeX(), child.parent.getTpeY());
            }
            child.parent = null;
            child.screen = null;
            child.onParentChanged();
            if (!c && this.getParent() instanceof TElement) {
                ((TElement)this.getParent()).getEvents().CHILD_AR.p_invoke(handler -> handler.accept((Object)child, (Object)false, (Object)reposition));
            }
            return true;
        }
        return false;
    }

    public boolean removeIf(Predicate<TElement> predicate) {
        return this.removeIf(predicate, true);
    }

    public boolean removeIf(Predicate<TElement> predicate, boolean reposition) {
        ArrayList toRemove = Lists.newArrayList();
        this.forEach(child -> {
            if (predicate.test((TElement)child)) {
                toRemove.add(child);
            }
        });
        for (TElement child2 : toRemove) {
            this.remove(child2, reposition);
        }
        return toRemove.size() > 0;
    }

    @Override
    public void clear() {
        this.clear(false);
    }

    public void clear(boolean reposition) {
        this.topmostElements.clear();
        for (TElement child : Lists.newArrayList((Iterable)this.list)) {
            this.remove(child, true);
        }
    }
}

