/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public final class GuiUtils {
    private GuiUtils() {
    }

    public static void applyScissor(Minecraft client, int x, int y, int width, int height, Runnable renderingAction) {
        Objects.requireNonNull(client, "client must not be null.");
        Objects.requireNonNull(renderingAction, "renderingAction must not be null.");
        GuiUtils.enableScissor(client, x, y, width, height);
        renderingAction.run();
        GuiUtils.disableScissor();
    }

    public static void enableScissor(Minecraft client, int x, int y, int width, int height) {
        double scale = client.m_91268_().m_85449_();
        x = (int)((double)x * scale);
        y = (int)((double)client.m_91268_().m_85444_() - (double)(y + height) * scale);
        width = (int)((double)width * scale);
        height = (int)((double)height * scale);
        RenderSystem.m_69488_((int)x, (int)y, (int)width, (int)height);
    }

    public static void disableScissor() {
        RenderSystem.m_69471_();
    }

    public static int applyAlpha(int color, float alpha) {
        return color | Mth.m_14167_((float)(alpha * ((float)(color & 0xFF) / 255.0f))) << 24;
    }

    public static void playClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    public static Screen showUrlPrompt(String url, boolean trusted) {
        return GuiUtils.showUrlPrompt(Minecraft.m_91087_().f_91080_, url, trusted);
    }

    public static Screen showUrlPrompt(Screen parent, String url, boolean trusted) {
        ConfirmLinkScreen screen = new ConfirmLinkScreen(accepted -> {
            if (accepted) {
                Util.m_137581_().m_137646_(url);
            }
            Minecraft.m_91087_().m_91152_(parent);
        }, url, trusted);
        Minecraft.m_91087_().m_91152_((Screen)screen);
        return screen;
    }

    public static Screen initScreen(Screen screen) {
        Objects.requireNonNull(screen, "screen must not be null.");
        Minecraft c = Minecraft.m_91087_();
        int w = c.m_91268_().m_85445_();
        int h = c.m_91268_().m_85446_();
        screen.m_6575_(c, w, h);
        return screen;
    }
}

