/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TTooltipElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.FocusOrigin;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TElementList;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class TScreen
extends Screen
implements TParentElement {
    private TElement clickedTChild;
    private TElement focusedTChild;
    private TElement hoveredTChild;
    protected final Point cursorPosition;
    private final TElementList tchildren;
    protected TTooltipElement tooltipElement;
    protected final Rectangle RENDER_RECT = new Rectangle(0, 0, 0, 0);
    @Nullable
    protected Rectangle CURRENT_CHILD_SCISSORS;

    protected TScreen(Component title) {
        super(title);
        this.tchildren = new TElementList(this);
        this.cursorPosition = new Point();
    }

    protected TTooltipElement __createTooltip() {
        return new TTooltipElement(this.getTpeWidth() / 2);
    }

    public final void m_7379_() {
        this.close();
    }

    public void close() {
        if (this.getTChildren().removeIf(child -> child instanceof TContextMenuPanel)) {
            return;
        }
        this.onClosed();
        if (this.getClient().f_91080_ == this) {
            super.m_7379_();
        }
    }

    public final void reInit() {
        GuiUtils.initScreen(this);
    }

    protected void onOpened() {
    }

    protected void onClosed() {
    }

    @Override
    @Nullable
    public Rectangle getRenderingBoundingBox() {
        return this.RENDER_RECT;
    }

    @Override
    public void updateRenderingBoundingBox() {
        this.RENDER_RECT.setSize(this.getTpeWidth(), this.getTpeHeight());
    }

    public Minecraft getClient() {
        if (this.f_96541_ == null) {
            return Minecraft.m_91087_();
        }
        return this.f_96541_;
    }

    public Font getTextRenderer() {
        return this.f_96547_;
    }

    public ItemRenderer getItemRenderer() {
        return this.f_96542_;
    }

    @Override
    public final int getTpeX() {
        return 0;
    }

    @Override
    public final int getTpeY() {
        return 0;
    }

    @Override
    public final int getTpeWidth() {
        return this.f_96543_;
    }

    @Override
    public final int getTpeHeight() {
        return this.f_96544_;
    }

    @Override
    public final int getTpeEndX() {
        return TParentElement.super.getTpeEndX();
    }

    @Override
    public final int getTpeEndY() {
        return TParentElement.super.getTpeEndY();
    }

    @Override
    public final double getZIndex() {
        return 0.0;
    }

    @Override
    public final <T extends TElement> boolean addTChild(T child) {
        return this.addTChild(child, true);
    }

    @Override
    public final <T extends TElement> boolean removeTChild(T child) {
        return this.removeTChild(child, true);
    }

    public boolean shouldRenderInGameHud() {
        return true;
    }

    @Override
    public final TParentElement getTParent() {
        return null;
    }

    @Override
    public TElementList getTChildren() {
        return this.tchildren;
    }

    @Nullable
    public TElement getFocusedTChild() {
        if (this.focusedTChild == null) {
            return null;
        }
        return this.focusedTChild.screen == this ? this.focusedTChild : null;
    }

    public boolean setFocusedTChild(@Nullable TElement child) {
        return this.setFocusedTChild(child, false, FocusOrigin.UNKNOWN);
    }

    public boolean setFocusedTChild(@Nullable TElement child, boolean askForDefocus, FocusOrigin defocusOrigin) {
        boolean approved;
        if (askForDefocus && this.focusedTChild != null && !(approved = this.focusedTChild.canChangeFocus(defocusOrigin, false))) {
            return false;
        }
        this.clickedTChild = child;
        this.focusedTChild = child;
        if (this.m_7282_()) {
            this.m_7897_(false);
        }
        return true;
    }

    @Nullable
    public TElement getHoveredTChild() {
        return this.hoveredTChild;
    }

    @Nullable
    public TElement getDraggingTChild() {
        return this.m_7282_() ? this.clickedTChild : null;
    }

    public int getMouseX() {
        return this.cursorPosition.x;
    }

    public int getMouseY() {
        return this.cursorPosition.y;
    }

    public void m_86600_() {
        super.m_86600_();
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        TElement target;
        this.hoveredTChild = null;
        this.m_7333_(matrices);
        this.forEachChild(child -> {
            this.renderChildTElement(matrices, mouseX, mouseY, delta, (TElement)child, true);
            return false;
        }, child -> {
            this.renderChildTElement(matrices, mouseX, mouseY, delta, (TElement)child, false);
            return false;
        }, true);
        TElement tElement = target = this.focusedTChild != null && this.focusedTChild.getTooltip() != null ? this.focusedTChild : this.hoveredTChild;
        if (target != null && this.tooltipElement != null && target.getTooltip() != null && target.getShownContextMenu() == null) {
            if (this.tooltipElement.getTooltip() != target.getTooltip()) {
                this.tooltipElement.setTooltip(target.getTooltip());
            }
            this.tooltipElement.screen = this;
            this.tooltipElement.parent = null;
            this.tooltipElement.refreshPosition(target, mouseX, mouseY);
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, this.tooltipElement.getZIndex());
            this.tooltipElement.render(matrices, mouseX, mouseY, delta);
            matrices.m_85849_();
        }
    }

    protected void renderChildTElement(PoseStack matrices, int mouseX, int mouseY, float delta, TElement child, boolean isPreRender) {
        if (child == null || !child.isVisible()) {
            return;
        }
        TParentElement parent = child.getTParent();
        Rectangle parentBox = parent.getRenderingBoundingBox();
        Rectangle childBox = child.getRenderingBoundingBox();
        if (parentBox == null || childBox == null) {
            return;
        }
        if (isPreRender && !child.isClickThrough() && child.isEnabledAndVisible() && (this.hoveredTChild == null || child.getZIndex() >= this.hoveredTChild.getZIndex()) && childBox != null && childBox.contains(this.cursorPosition)) {
            this.hoveredTChild = child;
        }
        matrices.m_85836_();
        matrices.m_85837_(0.0, 0.0, child.getZIndex());
        this.CURRENT_CHILD_SCISSORS = parentBox;
        GuiUtils.applyScissor(this.f_96541_, parentBox.x, parentBox.y, parentBox.width, parentBox.height, () -> {
            if (isPreRender) {
                child.render(matrices, mouseX, mouseY, delta);
            } else {
                child.postRender(matrices, mouseX, mouseY, delta);
            }
        });
        this.CURRENT_CHILD_SCISSORS = null;
        matrices.m_85849_();
    }

    public void resetScissors() {
        GuiUtils.disableScissor();
        if (this.CURRENT_CHILD_SCISSORS == null) {
            return;
        }
        GuiUtils.enableScissor(this.f_96541_, this.CURRENT_CHILD_SCISSORS.x, this.CURRENT_CHILD_SCISSORS.y, this.CURRENT_CHILD_SCISSORS.width, this.CURRENT_CHILD_SCISSORS.height);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean clickAccepted;
        int mX = (int)mouseX;
        int mY = (int)mouseY;
        this.cursorPosition.setLocation(mX, mY);
        TContextMenuPanel contextMenu = (TContextMenuPanel)this.findTChildOfType(TContextMenuPanel.class, false);
        TElement captor = this.hoveredTChild;
        while (captor != null && captor.isClickThrough()) {
            captor = captor.parent;
        }
        boolean bl = clickAccepted = captor != null && captor.isEnabledAndVisible() && captor.mousePressed(mX, mY, button);
        if (captor != this.focusedTChild) {
            if (clickAccepted && (captor == null || captor.canChangeFocus(FocusOrigin.MOUSE_CLICK, true))) {
                this.setFocusedTChild(captor, true, FocusOrigin.MOUSE_CLICK);
            } else {
                this.setFocusedTChild(null, true, FocusOrigin.MOUSE_CLICK);
            }
        }
        this.clickedTChild = captor;
        if (!clickAccepted && button == 0) {
            this.m_7897_(true);
        }
        if (contextMenu != null) {
            Rectangle renderRect = contextMenu.getRenderingBoundingBox();
            if (renderRect == null) {
                this.removeTChild(contextMenu);
            } else if (!renderRect.contains(this.cursorPosition)) {
                this.removeTChild(contextMenu);
                return true;
            }
        }
        return captor != null;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.m_7282_() || this.clickedTChild == null || this.clickedTChild.screen != this) {
            return false;
        }
        TElement nextTry = this.clickedTChild;
        boolean dragged = false;
        while (!dragged && nextTry != null) {
            dragged = nextTry.isVisible() && !nextTry.isClickThrough() && nextTry.mouseDragged(mouseX, mouseY, deltaX, deltaY, button);
            if (dragged) continue;
            nextTry = nextTry.parent;
        }
        return dragged;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        boolean b0 = this.clickedTChild != null && this.clickedTChild.isEnabled() && this.clickedTChild.mouseReleased((int)mouseX, (int)mouseY, button);
        this.m_7897_(false);
        return b0;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        TElement captor = this.hoveredTChild;
        while (captor != null && captor.isClickThrough()) {
            captor = captor.parent;
        }
        while (captor != null) {
            if (captor.isEnabledAndVisible() && captor.mouseScrolled(this.getMouseX(), this.getMouseY(), (int)amount)) {
                return true;
            }
            captor = captor.parent;
        }
        return false;
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.cursorPosition.setLocation(mouseX, mouseY);
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        if (keyCode == 348 && this.getFocusedTChild() != null && this.getFocusedTChild().showContextMenu() != null) {
            return true;
        }
        if (keyCode == 258 && this.getTChildren().size() > 0) {
            boolean shift = TScreen.m_96638_();
            FocusOrigin origin = FocusOrigin.TAB;
            TElement nextFocus = null;
            if (this.clickedTChild == null && this.focusedTChild == null) {
                nextFocus = !shift ? (TElement)this.getTChildren().get(0) : this.getLastTChild(true);
            } else if (this.clickedTChild != null && this.focusedTChild == null) {
                nextFocus = this.clickedTChild;
            } else if (this.focusedTChild != null) {
                TElement tElement = nextFocus = shift ? this.focusedTChild.previous() : this.focusedTChild.next();
            }
            while (nextFocus != null) {
                boolean accepted;
                boolean bl = accepted = !nextFocus.isClickThrough() && nextFocus.isEnabledAndVisible() && nextFocus.canChangeFocus(origin, true);
                if (accepted) break;
                nextFocus = shift ? nextFocus.previous() : nextFocus.next();
            }
            this.setFocusedTChild(nextFocus);
            this.__triggerScrollTo(nextFocus);
            return true;
        }
        return this.focusedTChild != null && this.focusedTChild.isEnabled() && this.focusedTChild.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void __triggerScrollTo(TElement child) {
        if (child == null) {
            return;
        }
        TElement panel = child.parent;
        while (panel instanceof TPanelElement && ((TPanelElement)panel).getScrollFlags() == 0) {
            panel = panel.parent;
        }
        if (panel instanceof TPanelElement) {
            ((TPanelElement)panel).scrollToChild(child);
        }
    }

    public boolean m_5534_(char character, int modifiers) {
        return this.focusedTChild != null && this.focusedTChild.isEnabled() && this.focusedTChild.charTyped(character, modifiers);
    }

    protected final void m_169413_() {
        super.m_169413_();
        this.clearTChildren();
        this.tooltipElement = this.__createTooltip();
        this.updateRenderingBoundingBox();
    }

    @Deprecated
    protected final <T extends GuiEventListener & NarratableEntry> T m_7787_(T drawableElement) {
        return drawableElement;
    }

    @Deprecated
    protected final <T extends Widget> T m_169394_(T drawable) {
        return drawable;
    }

    @Deprecated
    protected final <T extends GuiEventListener & Widget> T m_142416_(T selectable) {
        return selectable;
    }

    @Deprecated
    public final List<? extends GuiEventListener> m_6702_() {
        return Lists.newArrayList();
    }

    public final GuiEventListener m_7222_() {
        return super.m_7222_();
    }

    @Deprecated
    public final void m_7522_(GuiEventListener focused) {
        super.m_7522_(focused);
        if (focused == null) {
            this.setFocusedTChild(null);
        }
    }

    @Deprecated
    public final boolean m_5755_(boolean lookForwards) {
        return super.m_5755_(lookForwards);
    }

    @Deprecated
    public final void m_7861_() {
        super.m_7861_();
    }
}

