/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.FocusOrigin;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import java.awt.Rectangle;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class TContextMenuPanel
extends TPanelElement {
    protected static final int BORDER_COLOR = 0x50FFFFFF;

    public TContextMenuPanel(int x, int y, int width) {
        super(x, y, width, 0);
        this.m_93250_((int)(this.getItemRenderer().f_115093_ + 120.0f));
        this.setScrollPadding(0);
        this.setScrollFlags(4);
    }

    @Override
    @Nullable
    public Rectangle getRenderingBoundingBox() {
        if (this.getTParent() != this.screen) {
            return null;
        }
        return super.getRenderingBoundingBox();
    }

    @Override
    public boolean canBeAddedTo(TParentElement parent) {
        return parent instanceof TScreen;
    }

    @Override
    public void onParentChanged() {
        if (this.screen == null) {
            return;
        }
        this.screen.getTChildren().removeIf(child -> child != this && TContextMenuPanel.class.isAssignableFrom(child.getClass()));
    }

    @Override
    @Nullable
    protected final TContextMenuPanel createContextMenu(int x, int y) {
        return null;
    }

    @Override
    protected void renderBackground(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        TContextMenuPanel.m_93172_((PoseStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)GuiUtils.applyAlpha(-16777216, this.getAlpha()));
        this.drawOutline(matrices, 0x50FFFFFF);
    }

    public void updatePositionAndSize() {
        this.height = Math.min(this.getLocalBottomY(), 150);
        if (this.getTParent() != null) {
            int moveX = this.getTParent().getTpeWidth() - (this.getTpeX() + this.getTpeWidth());
            int moveY = this.getTParent().getTpeHeight() - (this.getTpeY() + this.getTpeHeight());
            moveX = Math.min(moveX, 0);
            moveY = Math.min(moveY, 0);
            this.move(moveX, moveY);
        }
        this.updateRenderingBoundingBox();
        for (TElement child : this.getTChildren()) {
            child.updateRenderingBoundingBox();
        }
    }

    @Override
    public <T extends TElement> boolean addTChild(T child, boolean reposition) {
        boolean b0 = super.addTChild(child, reposition);
        if (b0) {
            this.updatePositionAndSize();
        }
        return b0;
    }

    public int getLocalBottomY() {
        return this.topmosts.isFull() ? ((TElement)this.topmosts.Item2).getTpeY() + ((TElement)this.topmosts.Item2).getTpeHeight() - this.getTpeY() + 1 : 0;
    }

    public TButtonWidget addButton(Component label, Consumer<TButtonWidget> action) {
        CMWButton btn = new CMWButton(this.getLocalBottomY(), 15, label);
        btn.setOnClick(action);
        this.addTChild(btn, true);
        if (label != null) {
            int lblW = this.getTextRenderer().m_92895_(label.getString());
            if (lblW > this.getTpeWidth() - 10) {
                this.width = lblW + this.getScrollPadding() * 2 + 10;
            }
            this.updatePositionAndSize();
        }
        return btn;
    }

    public TElement addSeparator() {
        CMWSeparator sep = new CMWSeparator(this.getLocalBottomY());
        this.addTChild(sep, true);
        return sep;
    }

    protected class CMWButton
    extends TButtonWidget {
        public CMWButton(int y, int height, Component message) {
            super(0, y, 0, height, message, null);
        }

        @Override
        @Nullable
        protected final TContextMenuPanel createContextMenu(int x, int y) {
            return null;
        }

        @Override
        public int getTpeX() {
            return TContextMenuPanel.this.getTpeX();
        }

        @Override
        public int getTpeWidth() {
            return TContextMenuPanel.this.getTpeWidth();
        }

        @Override
        public float getAlpha() {
            return TContextMenuPanel.this.getAlpha();
        }

        @Override
        protected void onClick() {
            super.onClick();
            TParentElement parent = TContextMenuPanel.this.getTParent();
            if (parent != null) {
                parent.removeTChild(TContextMenuPanel.this);
            }
        }

        @Override
        public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
            this.drawMessage(matrices, HorizontalAlignment.LEFT, deltaTime);
            if (this.isFocusedOrHovered()) {
                this.drawOutline(matrices, -1);
            }
        }
    }

    protected class CMWSeparator
    extends TElement {
        public CMWSeparator(int y) {
            super(0, y, 0, 3);
        }

        @Override
        @Nullable
        protected final TContextMenuPanel createContextMenu(int x, int y) {
            return null;
        }

        @Override
        public int getTpeX() {
            return TContextMenuPanel.this.getTpeX();
        }

        @Override
        public int getTpeWidth() {
            return TContextMenuPanel.this.getTpeWidth();
        }

        @Override
        public float getAlpha() {
            return TContextMenuPanel.this.getAlpha();
        }

        @Override
        public boolean canChangeFocus(FocusOrigin focusOrigin, boolean gainingFocus) {
            return !gainingFocus;
        }

        @Override
        public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
            int w8 = this.getTpeWidth() / 8;
            this.drawHorizontalLine(matrices, this.getTpeX() + w8, this.getTpeX() + this.getTpeWidth() - w8, this.getTpeY() + 1, GuiUtils.applyAlpha(0x50FFFFFF, this.getAlpha()));
        }
    }
}

