/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.other;

import com.google.common.collect.MapMaker;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.FocusOrigin;
import io.github.thecsdev.tcdcommons.api.client.registry.TCDCommonsClientRegistry;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TEntityRendererElement
extends TElement {
    private static final ConcurrentMap<EntityType<?>, Entity> ENTITY_CACHE = new MapMaker().weakKeys().weakValues().makeMap();
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    protected double scale;
    protected LivingEntity livingEntity;
    protected MultiLineLabel entityTypeName;
    protected int cX;
    protected int cY;
    protected int tY;
    protected int cache_mobSize;
    protected final BiConsumer<Integer, Integer> MOVED_HANDLER;

    @Nullable
    public static Entity getCachedEntityFromType(EntityType<?> entityType) {
        if (entityType == null || !entityType.m_20654_() || TEntityRendererElement.CLIENT.f_91073_ == null) {
            return null;
        }
        if (ENTITY_CACHE.containsKey(entityType)) {
            return (Entity)ENTITY_CACHE.get(entityType);
        }
        Entity newEntity = null;
        try {
            newEntity = entityType.m_20615_((Level)TEntityRendererElement.CLIENT.f_91073_);
        }
        catch (Exception e) {
            newEntity = EntityType.f_20529_.m_20615_((Level)TEntityRendererElement.CLIENT.f_91073_);
        }
        try {
            newEntity.m_146870_();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newEntity != null) {
            ENTITY_CACHE.put(entityType, newEntity);
        }
        return newEntity;
    }

    public TEntityRendererElement(int x, int y, int width, int height) {
        this(x, y, width, height, null);
    }

    public TEntityRendererElement(int x, int y, int width, int height, EntityType<?> entityType) {
        super(x, y, width, height);
        this.setScale(0.9);
        this.setEntityType(entityType);
        this.recalcCache_cXY();
        this.MOVED_HANDLER = this.getEvents().MOVED.addWeakEventHandler((dX, dY) -> this.recalcCache_cXY());
    }

    @Override
    public boolean isClickThrough() {
        return true;
    }

    @Override
    public boolean canChangeFocus(FocusOrigin focusOrigin, boolean gainingFocus) {
        return !gainingFocus;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = Mth.m_14008_((double)scale, (double)0.1, (double)5.0);
        this.recalcCache_mobSize();
    }

    protected void recalcCache_mobSize() {
        if (this.livingEntity == null) {
            this.cache_mobSize = 30;
            return;
        }
        int w = this.getTpeWidth();
        int h = this.getTpeHeight();
        this.cache_mobSize = (int)((double)this.getLivingEntityGUISize(this.livingEntity, Math.min(w, h)) * this.getScale());
    }

    protected void recalcCache_cXY() {
        this.cX = this.getTpeX() + this.getTpeWidth() / 2;
        this.cY = this.getTpeEndY() - this.getTpeHeight() / 4;
        if (this.entityTypeName != null) {
            int n = this.entityTypeName.m_5770_();
            Objects.requireNonNull(this.getTextRenderer());
            this.tY = this.cY - n * 9;
        } else {
            this.tY = this.cY;
        }
    }

    public EntityType<?> getEntityType() {
        return this.livingEntity != null ? this.livingEntity.m_6095_() : null;
    }

    public void setEntityType(EntityType<?> entityType) {
        Entity entity = TEntityRendererElement.getCachedEntityFromType(entityType);
        LivingEntity livingEntity = this.livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (entityType == EntityType.f_20532_) {
            this.livingEntity = this.getClient().f_91074_;
        }
        this.entityTypeName = entityType != null ? MultiLineLabel.m_94341_((Font)this.getTextRenderer(), (FormattedText)entityType.m_20676_(), (int)this.getTpeWidth()) : MultiLineLabel.m_94350_((Font)this.getTextRenderer(), (Component[])new Component[]{TextUtils.literal("-")});
        this.recalcCache_mobSize();
        this.recalcCache_cXY();
    }

    @Override
    public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        if (this.livingEntity == null) {
            this.entityTypeName.m_6276_(matrices, this.cX, this.tY);
            return;
        }
        InventoryScreen.m_98850_((int)this.cX, (int)this.cY, (int)this.cache_mobSize, (float)(-TEntityRendererElement.rInt(mouseX, this.cX)), (float)(-TEntityRendererElement.rInt(mouseY, this.cY)), (LivingEntity)this.livingEntity);
    }

    private static int rInt(int input, int relativeTo) {
        return input - relativeTo;
    }

    public int getLivingEntityGUISize(LivingEntity e, int viewportSize) {
        int maxVal = (int)(50.0f * ((float)viewportSize / 80.0f));
        if (e == null) {
            return maxVal;
        }
        int result = maxVal;
        float f1 = e.m_6095_().m_20680_().f_20377_;
        float f2 = e.m_6095_().m_20680_().f_20378_;
        double d0 = Math.sqrt(f1 * f1 + f2 * f2);
        if (d0 == 0.0) {
            d0 = 0.1;
        }
        result = (int)((double)maxVal / d0);
        result = (int)((double)result * TCDCommonsClientRegistry.getEntityRendererSizeOffset(e.getClass()));
        return result;
    }
}

