/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.tcdcommons.api.client.gui.TDrawableHelper;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.events.TElementEvents;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.FocusOrigin;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TElementList;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public abstract class TElement
extends TDrawableHelper
implements TParentElement {
    public static final int SP_RELATIVE = 1;
    public static final int SP_MOVE_CHILDREN = 2;
    public static final int SP_UPDATE_TOPMOST = 4;
    @Nullable
    public TScreen screen;
    @Nullable
    public TElement parent;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected final TElementList children;
    protected boolean visible;
    protected float localAlpha;
    @Nullable
    protected Component tooltip;
    private final TElementEvents __events = new TElementEvents(this);
    protected final Rectangle RENDER_RECT = new Rectangle();
    private WeakReference<TContextMenuPanel> __contextMenu;

    public TElement(int x, int y, int width, int height) {
        this.children = new TElementList(this);
        this.x = x;
        this.y = y;
        this.width = Math.abs(width);
        this.height = Math.abs(height);
        this.screen = null;
        this.parent = null;
        this.visible = true;
        this.localAlpha = 1.0f;
        this.tooltip = null;
        this.RENDER_RECT.setLocation(this.x, this.y);
        this.RENDER_RECT.setSize(this.width, this.height);
    }

    public TElementEvents getEvents() {
        return this.__events;
    }

    @Override
    @Nullable
    public TParentElement getTParent() {
        return this.parent != null ? this.parent : this.screen;
    }

    @Override
    public TElementList getTChildren() {
        return this.children;
    }

    public final Font getTextRenderer() {
        if (this.screen != null) {
            return this.screen.getTextRenderer();
        }
        return Minecraft.m_91087_().f_91062_;
    }

    public final ItemRenderer getItemRenderer() {
        if (this.screen != null) {
            return this.screen.getItemRenderer();
        }
        return Minecraft.m_91087_().m_91291_();
    }

    public final Minecraft getClient() {
        if (this.screen != null) {
            return this.screen.getClient();
        }
        return Minecraft.m_91087_();
    }

    @Nullable
    public final TScreen updateScreen() {
        if (this.parent != null) {
            this.screen = this.parent.updateScreen();
            return this.screen;
        }
        return this.screen;
    }

    @Override
    public int getTpeX() {
        return this.x;
    }

    @Override
    public int getTpeY() {
        return this.y;
    }

    @Override
    public int getTpeWidth() {
        return this.width;
    }

    @Override
    public int getTpeHeight() {
        return this.height;
    }

    @Override
    public final int getTpeEndX() {
        return super.getTpeEndX();
    }

    @Override
    public final int getTpeEndY() {
        return super.getTpeEndY();
    }

    @Override
    public final <T extends TElement> boolean addTChild(T child) {
        return this.addTChild(child, true);
    }

    @Override
    public final <T extends TElement> boolean removeTChild(T child) {
        return this.removeTChild(child, true);
    }

    @Override
    @Nullable
    public Rectangle getRenderingBoundingBox() {
        if (this.RENDER_RECT.width < 1 || this.RENDER_RECT.height < 1) {
            return null;
        }
        return this.RENDER_RECT;
    }

    @Override
    public void updateRenderingBoundingBox() {
        this.RENDER_RECT.setLocation(this.getTpeX(), this.getTpeY());
        this.RENDER_RECT.setSize(this.getTpeWidth(), this.getTpeHeight());
        TParentElement parent = this.getTParent();
        if (parent == null) {
            return;
        }
        Rectangle pRect = parent.getRenderingBoundingBox();
        if (pRect == null) {
            this.RENDER_RECT.width = 0;
            return;
        }
        if (this.RENDER_RECT.x > pRect.x + pRect.width || this.RENDER_RECT.y > pRect.y + pRect.height) {
            this.RENDER_RECT.width = 0;
            return;
        }
        if (this.RENDER_RECT.x + this.RENDER_RECT.width < pRect.x || this.RENDER_RECT.y + this.RENDER_RECT.height < pRect.y) {
            this.RENDER_RECT.width = 0;
            return;
        }
        this.RENDER_RECT.x = Math.max(this.RENDER_RECT.x, pRect.x);
        this.RENDER_RECT.y = Math.max(this.RENDER_RECT.y, pRect.y);
        this.RENDER_RECT.width = Math.min(this.RENDER_RECT.x + this.RENDER_RECT.width, pRect.x + pRect.width);
        this.RENDER_RECT.height = Math.min(this.RENDER_RECT.y + this.RENDER_RECT.height, pRect.y + pRect.height);
        this.RENDER_RECT.width -= this.RENDER_RECT.x;
        this.RENDER_RECT.height -= this.RENDER_RECT.y;
    }

    public boolean isFocused() {
        return this.screen != null && this.screen.getFocusedTChild() == this;
    }

    public boolean isHovered() {
        return this.screen != null && this.screen.getHoveredTChild() == this;
    }

    public boolean isFocusedOrHovered() {
        return this.isHovered() || this.isFocused();
    }

    public final boolean isBeingDragged() {
        return this.screen != null && this.screen.getDraggingTChild() == this;
    }

    public final boolean isEnabled() {
        return this.getEnabled() && (this.parent == null || this.parent.isEnabled());
    }

    public final boolean isVisible() {
        return this.getVisible() && (this.parent == null || this.parent.isVisible());
    }

    public final boolean isEnabledAndVisible() {
        return this.isEnabled() && this.isVisible();
    }

    public boolean isClickThrough() {
        return false;
    }

    public boolean getEnabled() {
        return true;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public float getAlpha() {
        return this.localAlpha * (this.parent != null ? this.parent.getAlpha() : 1.0f);
    }

    public float getLocalAlpha() {
        return this.localAlpha;
    }

    public float setAlpha(float alpha) {
        this.localAlpha = alpha;
        return this.localAlpha;
    }

    @Nullable
    public final Component getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(@Nullable Component tooltip) {
        this.tooltip = tooltip;
    }

    public final void setPosition(int x, int y, boolean relativeToParent) {
        int flags = 6;
        if (relativeToParent) {
            flags |= 1;
        }
        this.setPosition(x, y, flags);
    }

    public void setPosition(int x, int y, int flags) {
        boolean rel2Parent = this.parent != null && (flags & 1) == 1;
        int n = rel2Parent ? this.parent.y : 0;
        int dx = (x += rel2Parent ? this.parent.x : 0) - this.x;
        int dy = (y += n) - this.y;
        this.x = x;
        this.y = y;
        if ((flags & 2) == 2) {
            this.moveChildren(dx, dy);
        }
        if ((flags & 4) == 4 && this.parent != null) {
            this.parent.children.updateTopmostChildren();
        }
        this.getEvents().MOVED.p_invoke(handler -> handler.accept(dx, dy));
    }

    public final void move(int x, int y) {
        this.move(x, y, true);
    }

    public final void move(int x, int y, boolean invokeEvent) {
        this.x += x;
        this.y += y;
        this.moveChildren(x, y, invokeEvent);
        if (invokeEvent) {
            this.getEvents().MOVED.p_invoke(handler -> handler.accept(x, y));
        }
    }

    public final void moveChildren(int x, int y) {
        this.moveChildren(x, y, true);
    }

    public final void moveChildren(int x, int y, boolean invokeEvent) {
        for (TElement child : this.children) {
            child.move(x, y, invokeEvent);
        }
    }

    @Deprecated(since="1.0", forRemoval=false)
    public void tick() {
    }

    @Override
    public final double getZIndex() {
        return (this.getTParent() != null ? this.getTParent().getZIndex() : 0.0) + (double)this.m_93252_();
    }

    public abstract void render(PoseStack var1, int var2, int var3, float var4);

    public void postRender(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
    }

    public boolean mousePressed(int mouseX, int mouseY, int button) {
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        return false;
    }

    public boolean mouseScrolled(int mouseX, int mouseY, int amount) {
        return false;
    }

    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean charTyped(char character, int modifiers) {
        return false;
    }

    public boolean canChangeFocus(FocusOrigin focusOrigin, boolean gainingFocus) {
        return !gainingFocus || focusOrigin == FocusOrigin.TAB;
    }

    @Nullable
    public final TContextMenuPanel showContextMenu() {
        return this.showContextMenu(this.getTpeX(), this.getTpeEndY());
    }

    @Nullable
    public final TContextMenuPanel showContextMenu(int x, int y) {
        if (this.screen == null) {
            return null;
        }
        TContextMenuPanel contextMenu = this.createContextMenu(x, y);
        if (contextMenu == null) {
            this.__contextMenu = null;
            return null;
        }
        this.__contextMenu = new WeakReference<TContextMenuPanel>(contextMenu);
        this.screen.addTChild(contextMenu, false);
        contextMenu.updatePositionAndSize();
        return contextMenu;
    }

    @Nullable
    public final TContextMenuPanel getShownContextMenu() {
        TContextMenuPanel contextMenu;
        TContextMenuPanel tContextMenuPanel = contextMenu = this.__contextMenu != null ? (TContextMenuPanel)this.__contextMenu.get() : null;
        if (contextMenu == null || contextMenu.screen == null) {
            return null;
        }
        return contextMenu;
    }

    @Nullable
    protected TContextMenuPanel createContextMenu(int x, int y) {
        TContextMenuPanel contextMenu = new TContextMenuPanel(x, y, Mth.m_14045_((int)this.getTpeWidth(), (int)50, (int)150));
        this.onContextMenu(contextMenu);
        this.getEvents().CONTEXT_MENU.p_invoke(handler -> handler.accept(contextMenu));
        if (contextMenu.getTChildren().size() < 1) {
            return null;
        }
        return contextMenu;
    }

    protected void onContextMenu(TContextMenuPanel contextMenu) {
    }

    @Nullable
    public TElement previous() {
        if (this.screen == null) {
            return null;
        }
        AtomicReference<Object> flag = new AtomicReference<Object>(null);
        this.screen.forEachChild(child -> {
            if (child == this) {
                return true;
            }
            flag.set(child);
            return false;
        }, true);
        return flag.get();
    }

    @Nullable
    public TElement next() {
        if (this.screen == null) {
            return null;
        }
        AtomicBoolean flag = new AtomicBoolean(false);
        return this.screen.forEachChild(child -> {
            if (child == this) {
                flag.set(true);
                return false;
            }
            return flag.get();
        }, true);
    }

    public boolean canBeAddedTo(TParentElement parent) {
        return parent != null;
    }

    public void onParentChanged() {
    }

    public void drawTElementText(PoseStack matrices, Component text, HorizontalAlignment alignment, float deltaTime) {
        int color = GuiUtils.applyAlpha(this.getEnabled() ? 0xFFFFFF : 0xA0A0A0, this.getAlpha());
        this.drawTElementText(matrices, text, alignment, color, deltaTime);
    }

    public void drawTElementText(PoseStack matrices, Component text, HorizontalAlignment alignment, int color, float deltaTime) {
        this.drawTElementText(matrices, text, alignment, color, 5, deltaTime);
    }

    public void drawTElementText(PoseStack matrices, Component text, HorizontalAlignment alignment, int color, int padding, float deltaTime) {
        if (this.screen == null) {
            return;
        }
        if (text != null) {
            Font txtR = this.getTextRenderer();
            int x = this.getTpeX();
            int y = this.getTpeY() + (this.getTpeHeight() - 8) / 2;
            int width = this.getTpeWidth();
            switch (alignment) {
                case CENTER: {
                    TElement.drawCenteredText(matrices, txtR, text, x + width / 2, y, color);
                    break;
                }
                case LEFT: {
                    TElement.drawTextWithShadow(matrices, txtR, text, x + padding, y, color);
                    break;
                }
                case RIGHT: {
                    TElement.drawTextWithShadow(matrices, txtR, text, x + width - padding - txtR.m_92895_(text.getString()), y, color);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }
}

