/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.packets.MusicDataRequestPacket;
import xerca.xercamusic.common.packets.MusicDataResponsePacket;

public class MusicDataRequestPacketHandler {
    public static void handle(MusicDataRequestPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("ServerPlayer was null when MusicDataRequestPacketHandler was received");
            return;
        }
        ctx.get().enqueueWork(() -> MusicDataRequestPacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(MusicDataRequestPacket msg, ServerPlayer pl) {
        UUID id = msg.getId();
        int version = msg.getVersion();
        MusicManager.MusicData data = MusicManager.getMusicData(id, version, pl.f_8924_);
        PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> pl);
        MusicDataResponsePacket packet = data != null ? new MusicDataResponsePacket(id, data.version, data.notes) : new MusicDataResponsePacket(id, 0, new ArrayList<NoteEvent>());
        XercaMusic.NETWORK_HANDLER.send(target, (Object)packet);
    }
}

