/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeBinding;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBufferUsage;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.DrawCommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlIndexType;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlPrimitiveType;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlTessellation;
import me.jellysquid.mods.sodium.client.gl.tessellation.TessellationBinding;
import me.jellysquid.mods.sodium.client.gl.util.ElementRange;
import me.jellysquid.mods.sodium.client.gl.util.MultiDrawBatch;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.ShaderChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.format.ChunkModelVertexFormats;
import me.jellysquid.mods.sodium.client.render.chunk.format.VanillaLikeChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import org.lwjgl.system.MemoryUtil;

public class RegionChunkRenderer
extends ShaderChunkRenderer {
    private static final ByteBuffer DRAW_INFO_BUFFER = RegionChunkRenderer.createChunkInfoBuffer();
    private final MultiDrawBatch[] batches;
    private final GlVertexAttributeBinding[] vertexAttributeBindings;
    private final GlMutableBuffer chunkInfoBuffer;
    private final boolean isBlockFaceCullingEnabled;

    private GlVertexAttributeBinding[] getBindingsForType() {
        if (this.vertexType != ChunkModelVertexFormats.VANILLA_LIKE) {
            GlVertexFormat compactFormat = this.vertexFormat;
            return new GlVertexAttributeBinding[]{new GlVertexAttributeBinding(1, compactFormat.getAttribute(ChunkMeshAttribute.POSITION_ID)), new GlVertexAttributeBinding(2, compactFormat.getAttribute(ChunkMeshAttribute.COLOR)), new GlVertexAttributeBinding(3, compactFormat.getAttribute(ChunkMeshAttribute.BLOCK_TEXTURE)), new GlVertexAttributeBinding(4, compactFormat.getAttribute(ChunkMeshAttribute.LIGHT_TEXTURE))};
        }
        GlVertexFormat vanillaFormat = this.vertexFormat;
        return new GlVertexAttributeBinding[]{new GlVertexAttributeBinding(1, vanillaFormat.getAttribute(VanillaLikeChunkMeshAttribute.POSITION)), new GlVertexAttributeBinding(2, vanillaFormat.getAttribute(VanillaLikeChunkMeshAttribute.COLOR)), new GlVertexAttributeBinding(3, vanillaFormat.getAttribute(VanillaLikeChunkMeshAttribute.BLOCK_TEX_ID)), new GlVertexAttributeBinding(4, vanillaFormat.getAttribute(VanillaLikeChunkMeshAttribute.LIGHT))};
    }

    public RegionChunkRenderer(RenderDevice device, ChunkVertexType<?> vertexType) {
        super(device, vertexType);
        this.isBlockFaceCullingEnabled = SodiumClientMod.options().performance.useBlockFaceCulling;
        this.vertexAttributeBindings = this.getBindingsForType();
        try (CommandList commandList = device.createCommandList();){
            this.chunkInfoBuffer = commandList.createMutableBuffer();
            commandList.uploadData(this.chunkInfoBuffer, DRAW_INFO_BUFFER, GlBufferUsage.STATIC_DRAW);
        }
        this.batches = new MultiDrawBatch[GlIndexType.VALUES.length];
        for (int i = 0; i < this.batches.length; ++i) {
            this.batches[i] = MultiDrawBatch.create(ModelQuadFacing.COUNT * 256);
        }
    }

    @Override
    public void render(ChunkRenderMatrices matrices, CommandList commandList, ChunkRenderList list, BlockRenderPass pass, ChunkCameraContext camera) {
        super.begin(pass);
        ChunkShaderInterface shader = (ChunkShaderInterface)this.activeProgram.getInterface();
        shader.setProjectionMatrix(matrices.projection());
        shader.setModelViewMatrix(matrices.modelView());
        shader.setDrawUniforms(this.chunkInfoBuffer);
        for (Map.Entry<RenderRegion, List<RenderSection>> entry : RegionChunkRenderer.sortedRegions(list, pass.isTranslucent())) {
            RenderRegion region = entry.getKey();
            List<RenderSection> regionSections = entry.getValue();
            if (!this.buildDrawBatches(regionSections, pass, camera)) continue;
            this.setModelMatrixUniforms(shader, region, camera);
            this.executeDrawBatches(commandList, this.createTessellationForRegion(commandList, region.getArenas(), pass));
        }
        super.end();
    }

    private boolean buildDrawBatches(List<RenderSection> sections, BlockRenderPass pass, ChunkCameraContext camera) {
        if (sections.isEmpty()) {
            return false;
        }
        for (MultiDrawBatch batch : this.batches) {
            batch.begin();
        }
        for (RenderSection render : RegionChunkRenderer.sortedChunks(sections, pass.isTranslucent())) {
            ChunkGraphicsState state = render.getGraphicsState(pass);
            if (state == null) continue;
            ChunkRenderBounds bounds = render.getBounds();
            long indexOffset = state.getIndexSegment().getOffset();
            int baseVertex = state.getVertexSegment().getOffset() / this.vertexFormat.getStride();
            this.addDrawCall(state.getModelPart(ModelQuadFacing.UNASSIGNED), indexOffset, baseVertex);
            if (!(!this.isBlockFaceCullingEnabled || pass.isTranslucent() && SodiumClientMod.options().performance.useTranslucentFaceSorting)) {
                if (camera.posY > bounds.y1 - 3.0f) {
                    this.addDrawCall(state.getModelPart(ModelQuadFacing.UP), indexOffset, baseVertex);
                }
                if (camera.posY < bounds.y2 + 3.0f) {
                    this.addDrawCall(state.getModelPart(ModelQuadFacing.DOWN), indexOffset, baseVertex);
                }
                if (camera.posX > bounds.x1 - 3.0f) {
                    this.addDrawCall(state.getModelPart(ModelQuadFacing.EAST), indexOffset, baseVertex);
                }
                if (camera.posX < bounds.x2 + 3.0f) {
                    this.addDrawCall(state.getModelPart(ModelQuadFacing.WEST), indexOffset, baseVertex);
                }
                if (camera.posZ > bounds.z1 - 3.0f) {
                    this.addDrawCall(state.getModelPart(ModelQuadFacing.SOUTH), indexOffset, baseVertex);
                }
                if (!(camera.posZ < bounds.z2 + 3.0f)) continue;
                this.addDrawCall(state.getModelPart(ModelQuadFacing.NORTH), indexOffset, baseVertex);
                continue;
            }
            for (ModelQuadFacing facing : ModelQuadFacing.DIRECTIONS) {
                this.addDrawCall(state.getModelPart(facing), indexOffset, baseVertex);
            }
        }
        boolean nonEmpty = false;
        for (MultiDrawBatch batch : this.batches) {
            batch.end();
            nonEmpty |= !batch.isEmpty();
        }
        return nonEmpty;
    }

    private GlTessellation createTessellationForRegion(CommandList commandList, RenderRegion.RenderRegionArenas arenas, BlockRenderPass pass) {
        GlTessellation tessellation = arenas.getTessellation(pass);
        if (tessellation == null) {
            tessellation = this.createRegionTessellation(commandList, arenas);
            arenas.setTessellation(pass, tessellation);
        }
        return tessellation;
    }

    private void executeDrawBatches(CommandList commandList, GlTessellation tessellation) {
        for (int i = 0; i < this.batches.length; ++i) {
            MultiDrawBatch batch = this.batches[i];
            if (batch.isEmpty()) continue;
            try (DrawCommandList drawCommandList = commandList.beginTessellating(tessellation);){
                drawCommandList.multiDrawElementsBaseVertex(batch.getPointerBuffer(), batch.getCountBuffer(), batch.getBaseVertexBuffer(), GlIndexType.VALUES[i]);
                continue;
            }
        }
    }

    private void setModelMatrixUniforms(ChunkShaderInterface shader, RenderRegion region, ChunkCameraContext camera) {
        float x = RegionChunkRenderer.getCameraTranslation(region.getOriginX(), camera.blockX, camera.deltaX);
        float y = RegionChunkRenderer.getCameraTranslation(region.getOriginY(), camera.blockY, camera.deltaY);
        float z = RegionChunkRenderer.getCameraTranslation(region.getOriginZ(), camera.blockZ, camera.deltaZ);
        shader.setRegionOffset(x, y, z);
    }

    private void addDrawCall(ElementRange part, long baseIndexPointer, int baseVertexIndex) {
        if (part != null) {
            MultiDrawBatch batch = this.batches[part.indexType().ordinal()];
            batch.add(baseIndexPointer + (long)part.elementPointer(), part.elementCount(), baseVertexIndex + part.baseVertex());
        }
    }

    private GlTessellation createRegionTessellation(CommandList commandList, RenderRegion.RenderRegionArenas arenas) {
        return commandList.createTessellation(GlPrimitiveType.TRIANGLES, new TessellationBinding[]{TessellationBinding.forVertexBuffer(arenas.vertexBuffers.getBufferObject(), this.vertexAttributeBindings), TessellationBinding.forElementBuffer(arenas.indexBuffers.getBufferObject())});
    }

    @Override
    public void delete() {
        super.delete();
        for (MultiDrawBatch batch : this.batches) {
            batch.delete();
        }
        RenderDevice.INSTANCE.createCommandList().deleteBuffer(this.chunkInfoBuffer);
    }

    private static Iterable<Map.Entry<RenderRegion, List<RenderSection>>> sortedRegions(ChunkRenderList list, boolean translucent) {
        return list.sorted(translucent);
    }

    private static Iterable<RenderSection> sortedChunks(List<RenderSection> chunks, boolean translucent) {
        return translucent ? Lists.reverse(chunks) : chunks;
    }

    private static float getCameraTranslation(int chunkBlockPos, int cameraBlockPos, float cameraPos) {
        return (float)(chunkBlockPos - cameraBlockPos) - cameraPos;
    }

    private static ByteBuffer createChunkInfoBuffer() {
        int stride = 16;
        ByteBuffer data = MemoryUtil.memAlloc((int)(256 * stride));
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 8; ++z) {
                    int i = RenderRegion.getChunkIndex(x, y, z) * stride;
                    data.putFloat(i + 0, (float)x * 16.0f);
                    data.putFloat(i + 4, (float)y * 16.0f);
                    data.putFloat(i + 8, (float)z * 16.0f);
                }
            }
        }
        return data;
    }
}

