/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptionPages;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.VideoSettingsScreen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class SodiumOptionsGUI
extends Screen {
    private final List<OptionPage> pages = new ArrayList<OptionPage>();
    private final List<ControlElement<?>> controls = new ArrayList();
    private final Screen prevScreen;
    private OptionPage currentPage;
    private FlatButtonWidget applyButton;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget undoButton;
    private FlatButtonWidget donateButton;
    private FlatButtonWidget hideDonateButton;
    private boolean hasPendingChanges;
    private ControlElement<?> hoveredElement;

    public SodiumOptionsGUI(Screen prevScreen) {
        super((Component)Component.m_237115_((String)"Embeddium Options"));
        this.prevScreen = prevScreen;
        this.pages.add(SodiumGameOptionPages.general());
        this.pages.add(SodiumGameOptionPages.quality());
        this.pages.add(SodiumGameOptionPages.performance());
        this.pages.add(SodiumGameOptionPages.advanced());
    }

    public void setPage(OptionPage page) {
        this.currentPage = page;
        this.rebuildGUI();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.rebuildGUI();
    }

    private void rebuildGUI() {
        this.controls.clear();
        this.m_169413_();
        if (this.currentPage == null) {
            if (this.pages.isEmpty()) {
                throw new IllegalStateException("No pages are available?!");
            }
            this.currentPage = this.pages.get(0);
        }
        this.rebuildGUIPages();
        this.rebuildGUIOptions();
        this.undoButton = new FlatButtonWidget(new Dim2i(this.f_96543_ - 211, this.f_96544_ - 30, 65, 20), (Component)Component.m_237115_((String)"sodium.options.buttons.undo"), this::undoChanges);
        this.applyButton = new FlatButtonWidget(new Dim2i(this.f_96543_ - 142, this.f_96544_ - 30, 65, 20), (Component)Component.m_237115_((String)"sodium.options.buttons.apply"), this::applyChanges);
        this.closeButton = new FlatButtonWidget(new Dim2i(this.f_96543_ - 73, this.f_96544_ - 30, 65, 20), (Component)Component.m_237115_((String)"gui.done"), this::m_7379_);
        this.donateButton = new FlatButtonWidget(new Dim2i(this.f_96543_ - 128, 6, 100, 20), (Component)Component.m_237115_((String)"sodium.options.buttons.donate"), this::openDonationPage);
        this.hideDonateButton = new FlatButtonWidget(new Dim2i(this.f_96543_ - 26, 6, 20, 20), (Component)Component.m_237113_((String)"x"), this::hideDonationButton);
        if (SodiumClientMod.options().notifications.hideDonationButton) {
            this.setDonationButtonVisibility(false);
        }
        this.m_142416_(this.undoButton);
        this.m_142416_(this.applyButton);
        this.m_142416_(this.closeButton);
        this.m_142416_(this.donateButton);
        this.m_142416_(this.hideDonateButton);
    }

    private void setDonationButtonVisibility(boolean value) {
        this.donateButton.setVisible(value);
        this.hideDonateButton.setVisible(value);
    }

    private void hideDonationButton() {
        SodiumGameOptions options = SodiumClientMod.options();
        options.notifications.hideDonationButton = true;
        try {
            options.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save configuration", e);
        }
        this.setDonationButtonVisibility(false);
    }

    private void rebuildGUIPages() {
        int x = 6;
        int y = 6;
        for (OptionPage page : this.pages) {
            int width = 12 + this.f_96547_.m_92852_((FormattedText)page.getName());
            FlatButtonWidget button = new FlatButtonWidget(new Dim2i(x, y, width, 18), page.getName(), () -> this.setPage(page));
            button.setSelected(this.currentPage == page);
            x += width + 6;
            this.m_142416_(button);
        }
    }

    private void rebuildGUIOptions() {
        int x = 6;
        int y = 28;
        for (OptionGroup group : this.currentPage.getGroups()) {
            for (Option option : group.getOptions()) {
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(x, y, 200, 18));
                this.m_142416_(element);
                this.controls.add(element);
                y += 18;
            }
            y += 4;
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float delta) {
        super.m_7333_(matrixStack);
        this.updateControls();
        super.m_6305_(matrixStack, mouseX, mouseY, delta);
        if (this.hoveredElement != null) {
            this.renderOptionTooltip(matrixStack, this.hoveredElement);
        }
    }

    private void updateControls() {
        ControlElement hovered = this.getActiveControls().filter(ControlElement::isHovered).findFirst().orElse(null);
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
        this.hoveredElement = hovered;
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private Stream<ControlElement<?>> getActiveControls() {
        return this.controls.stream();
    }

    private void renderOptionTooltip(PoseStack matrixStack, ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = 200;
        int boxY = dim.y();
        int boxX = dim.getLimitX() + boxPadding;
        Option<?> option = element.getOption();
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>(this.f_96547_.m_92923_((FormattedText)option.getTooltip(), boxWidth - textPadding * 2));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(Language.m_128107_().m_5536_((FormattedText)Component.m_237110_((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.getLocalizedName()}).m_130940_(ChatFormatting.GRAY)));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.f_96544_ - 40)) {
            boxY -= boxYLimit - boxYCutoff;
        }
        this.m_93179_(matrixStack, boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912, -536870912);
        for (int i = 0; i < tooltip.size(); ++i) {
            this.f_96547_.m_92877_(matrixStack, (FormattedCharSequence)tooltip.get(i), (float)(boxX + textPadding), (float)(boxY + textPadding + i * 12), -1);
        }
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        Minecraft client = Minecraft.m_91087_();
        if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_RELOAD)) {
            client.f_91060_.m_109818_();
        } else if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_UPDATE)) {
            client.f_91060_.m_109826_();
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_ASSET_RELOAD)) {
            client.m_91312_(((Integer)client.f_91066_.m_232119_().m_231551_()).intValue());
            client.m_91088_();
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    private void openDonationPage() {
        Util.m_137581_().m_137646_("https://caffeinemc.net/donate");
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 80 && (modifiers & 1) != 0) {
            Minecraft.m_91087_().m_91152_((Screen)new VideoSettingsScreen(this.prevScreen, Minecraft.m_91087_().f_91066_));
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6913_() {
        return !this.hasPendingChanges;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.prevScreen);
    }
}

