/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.plugin;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.teamderpy.shouldersurfing.ShoulderSurfing;
import com.teamderpy.shouldersurfing.api.IShoulderSurfingPlugin;
import com.teamderpy.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ServiceLoader;

public abstract class PluginLoader {
    private static final PluginLoader INSTANCE = ServiceLoader.load(PluginLoader.class).findFirst().orElseThrow();
    private static final String ENTRYPOINT_KEY = "entrypoint";
    protected static final String PLUGIN_JSON_PATH = "shouldersurfing_plugin.json";

    public abstract void loadPlugins();

    protected void loadPlugin(String modid, Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject configuration = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (configuration.has(ENTRYPOINT_KEY)) {
                String entrypoint = configuration.get(ENTRYPOINT_KEY).getAsString();
                IShoulderSurfingPlugin plugin = (IShoulderSurfingPlugin)Class.forName(entrypoint).getConstructor(new Class[0]).newInstance(new Object[0]);
                plugin.register(ShoulderSurfingRegistrar.getInstance());
                ShoulderSurfing.LOGGER.info("Registered plugin " + modid);
            } else {
                ShoulderSurfing.LOGGER.error("Plugin for " + modid + " does not contain an entrypoint");
            }
        }
        catch (Exception e) {
            ShoulderSurfing.LOGGER.error("Failed to register plugin " + modid, (Throwable)e);
        }
    }

    public static PluginLoader getInstance() {
        return INSTANCE;
    }
}

