/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.entities.IllashooterEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;

public class DispenserEntity
extends Monster
implements IllagerAttack {
    private final List<IllashooterEntity> shooters = new ArrayList<IllashooterEntity>();
    private static final EntityDataAccessor<Boolean> IN_MOTION = SynchedEntityData.m_135353_(DispenserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int spawnTicks;
    private Mob owner;

    public DispenserEntity(EntityType<? extends Monster> p_i48553_1_, Level p_i48553_2_) {
        super(p_i48553_1_, p_i48553_2_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IN_MOTION, (Object)false);
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource p_147189_) {
        if (this.isInMotion()) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_DISPENSER_OPEN.get(), 1.0f, 1.0f);
            this.setInMotion(false);
        }
        return false;
    }

    public void m_8119_() {
        if (this.m_6084_() && !this.isInMotion()) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
            ++this.spawnTicks;
            if (this.spawnTicks > 60 && this.shooters.size() < 5) {
                this.m_5496_(SoundEvents.f_11798_, 1.0f, 1.0f);
                if (!this.f_19853_.f_46443_) {
                    IllashooterEntity illashooter = (IllashooterEntity)((EntityType)ModEntityTypes.Illashooter.get()).m_20615_(this.f_19853_);
                    assert (illashooter != null);
                    illashooter.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    illashooter.m_20334_(0.0, 0.5, 0.0);
                    if (this.m_5647_() != null) {
                        this.f_19853_.m_6188_().m_6546_(illashooter.m_20149_(), this.f_19853_.m_6188_().m_83489_(this.m_5647_().m_5758_()));
                    }
                    illashooter.setOwner((Mob)this);
                    if (this.getOwner() != null) {
                        illashooter.m_6710_(this.getOwner().m_5448_());
                    }
                    this.f_19853_.m_7967_((Entity)illashooter);
                    this.shooters.add(illashooter);
                }
                this.spawnTicks = 0;
            }
            this.updateShooterList();
        }
        if (this.m_20096_()) {
            this.setInMotion(false);
        }
        super.m_8119_();
    }

    public boolean isInMotion() {
        return (Boolean)this.f_19804_.m_135370_(IN_MOTION);
    }

    public void setInMotion(boolean motion) {
        this.f_19804_.m_135381_(IN_MOTION, (Object)motion);
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SoundEvents.f_12600_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_DISPENSER_DESTROY.get();
    }

    public void m_6667_(DamageSource p_70645_1_) {
        super.m_6667_(p_70645_1_);
        if (this.f_19853_.f_46443_) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), d0, d1, d2);
        }
        this.f_20919_ = 19;
    }

    public void updateShooterList() {
        if (!this.shooters.isEmpty()) {
            for (int i = 0; i < this.shooters.size(); ++i) {
                IllashooterEntity clone = this.shooters.get(i);
                if (clone.m_6084_()) continue;
                this.shooters.remove(i);
                --i;
            }
        }
    }

    public Mob getOwner() {
        return this.owner;
    }

    public void setOwner(Mob owner) {
        this.owner = owner;
    }
}

