/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.yellowbrossproductions.illageandspillage.client.render.ISRenderType;
import com.yellowbrossproductions.illageandspillage.entities.projectile.SoulBeamEntity;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SoulBeamRenderer
extends EntityRenderer<SoulBeamEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("illageandspillage", "textures/entity/spiritcaller/soul_beam.png");
    private static final float TEXTURE_WIDTH = 256.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private static final float START_RADIUS = 1.3f;
    private static final float BEAM_RADIUS = 0.7f;
    private final Random random = new Random();

    public SoulBeamRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public Vec3 getRenderOffset(SoulBeamEntity p_114483_, float p_114484_) {
        return new Vec3(this.random.nextGaussian() * 0.03, this.random.nextGaussian() * 0.03, this.random.nextGaussian() * 0.03);
    }

    public void render(SoulBeamEntity beam, float entityYaw, float delta, PoseStack poseStack, MultiBufferSource p_114489_, int light) {
        double collidePosX = beam.prevCollidePosX + (beam.collidePosX - beam.prevCollidePosX) * (double)delta;
        double collidePosY = beam.prevCollidePosY + (beam.collidePosY - beam.prevCollidePosY) * (double)delta;
        double collidePosZ = beam.prevCollidePosZ + (beam.collidePosZ - beam.prevCollidePosZ) * (double)delta;
        double posX = beam.f_19854_ + (beam.m_20185_() - beam.f_19854_) * (double)delta;
        double posY = beam.f_19855_ + (beam.m_20186_() - beam.f_19855_) * (double)delta;
        double posZ = beam.f_19856_ + (beam.m_20189_() - beam.f_19856_) * (double)delta;
        float yaw = beam.prevYaw + (beam.renderYaw - beam.prevYaw) * delta;
        float pitch = beam.prevPitch + (beam.renderPitch - beam.prevPitch) * delta;
        float length = (float)Math.sqrt(Math.pow(collidePosX - posX, 2.0) + Math.pow(collidePosY - posY, 2.0) + Math.pow(collidePosZ - posZ, 2.0));
        int frame = Mth.m_14143_((float)((2.0f + delta) * 2.0f));
        if (frame < 0) {
            frame = 6;
        }
        VertexConsumer ivertexbuilder = p_114489_.m_6299_(ISRenderType.getGlowingEffect(this.getTextureLocation(beam)));
        this.renderStart(frame, poseStack, ivertexbuilder, light);
        this.renderBeam(frame, length, 57.295776f * yaw, 57.295776f * pitch, poseStack, ivertexbuilder, light);
        poseStack.m_85836_();
        poseStack.m_85837_(collidePosX - posX, collidePosY - posY, collidePosZ - posZ);
        this.renderEnd(frame, beam.blockSide, poseStack, ivertexbuilder, light);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(SoulBeamEntity p_114482_) {
        return TEXTURE;
    }

    private void renderFlatQuad(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        float minU = 0.625f;
        float minV = 0.0f;
        float maxU = minU + 0.0625f;
        float maxV = minV + 0.5f;
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_85861_();
        Matrix3f matrix3f = matrixstack$entry.m_85864_();
        this.drawVertex(matrix4f, matrix3f, builder, -1.3f, -1.3f, 0.0f, minU, minV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -1.3f, 1.3f, 0.0f, minU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.3f, 1.3f, 0.0f, maxU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.3f, -1.3f, 0.0f, maxU, minV, 1.0f, packedLightIn);
    }

    private void renderStart(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.m_85836_();
        Quaternion quat = this.f_114476_.m_114470_();
        matrixStackIn.m_85845_(quat);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
    }

    private void renderEnd(int frame, Direction side, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.m_85836_();
        Quaternion quat = this.f_114476_.m_114470_();
        matrixStackIn.m_85845_(quat);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        if (side == null) {
            return;
        }
        matrixStackIn.m_85836_();
        Quaternion sideQuat = side.m_122406_();
        sideQuat.m_80148_(new Quaternion(90.0f, 0.0f, 0.0f, true));
        matrixStackIn.m_85845_(sideQuat);
        matrixStackIn.m_85837_(0.0, 0.0, (double)-0.01f);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
    }

    private void drawBeam(int frame, float length, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        float minU = 0.0f;
        float minV = 0.5f + 0.03125f * (float)frame;
        float maxU = minU + 0.078125f;
        float maxV = minV + 0.03125f;
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_85861_();
        Matrix3f matrix3f = matrixstack$entry.m_85864_();
        this.drawVertex(matrix4f, matrix3f, builder, -0.7f, 0.0f, 0.0f, minU, minV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -0.7f, length, 0.0f, minU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 0.7f, length, 0.0f, maxU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 0.7f, 0.0f, 0.0f, maxU, minV, 1.0f, packedLightIn);
    }

    private void renderBeam(int frame, float length, float yaw, float pitch, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(new Quaternion(90.0f, 0.0f, 0.0f, true));
        matrixStackIn.m_85845_(new Quaternion(0.0f, 0.0f, yaw - 90.0f, true));
        matrixStackIn.m_85845_(new Quaternion(-pitch, 0.0f, 0.0f, true));
        matrixStackIn.m_85836_();
        this.drawBeam(frame, length, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85849_();
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.m_85982_(matrix, offsetX, offsetY, offsetZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f * alpha).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

