/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yellowbrossproductions.illageandspillage.client.model.animation.AbsorberAnimation;
import com.yellowbrossproductions.illageandspillage.entities.AbsorberEntity;
import java.util.Random;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class AbsorberModel<T extends Entity>
extends HierarchicalModel<T>
implements HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("illageandspillage", "absorber"), "main");
    private final ModelPart root;
    private final ModelPart waist;
    private final ModelPart leg2;
    private final ModelPart leg1;
    private final Random random = new Random();

    public AbsorberModel(ModelPart root) {
        this.root = root;
        this.waist = root.m_171324_("waist");
        this.leg2 = root.m_171324_("leg2");
        this.leg1 = root.m_171324_("leg1");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition waist = partdefinition.m_171599_("waist", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(-8.0f, -12.0f, -6.0f, 16.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition chest = waist.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(28, 24).m_171488_(-11.0f, -16.0f, -8.0f, 22.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition arm1 = chest.m_171599_("arm1", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-14.0f, (float)-11.0f, (float)0.0f, (float)-0.8727f, (float)0.1745f, (float)0.0873f));
        PartDefinition glove1 = arm1.m_171599_("glove1", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 16.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)0.0f, (float)-2.0944f, (float)0.1745f, (float)0.0873f));
        PartDefinition fist1 = glove1.m_171599_("fist1", CubeListBuilder.m_171558_().m_171514_(72, 56).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition hammer = fist1.m_171599_("hammer", CubeListBuilder.m_171558_().m_171514_(0, 94).m_171488_(-1.0f, -28.0f, -1.0f, 2.0f, 32.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(8, 116).m_171488_(-3.0f, 4.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(32, 102).m_171488_(-5.0f, -38.0f, -8.0f, 10.0f, 10.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(8, 98).m_171488_(-7.0f, -40.0f, -12.0f, 14.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(8, 98).m_171488_(-7.0f, -40.0f, 8.0f, 14.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition arm2 = chest.m_171599_("arm2", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171480_().m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)14.0f, (float)-11.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)-0.0873f));
        PartDefinition glove2 = arm2.m_171599_("glove2", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171480_().m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 16.0f, 6.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.3491f));
        PartDefinition fist2 = glove2.m_171599_("fist2", CubeListBuilder.m_171558_().m_171514_(72, 56).m_171480_().m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = chest.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-14.0f, (float)-6.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-5.0f));
        PartDefinition eyebrow1 = head.m_171599_("eyebrow1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -2.0f, 0.0f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-3.5f, (float)-4.1f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition eyebrow2 = head.m_171599_("eyebrow2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(0.0f, -2.0f, 0.0f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)-3.5f, (float)-4.1f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition leg2 = partdefinition.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(104, 0).m_171480_().m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 20.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)4.0f, (float)0.0f));
        PartDefinition boot2 = leg2.m_171599_("boot2", CubeListBuilder.m_171558_().m_171514_(104, 26).m_171480_().m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition leg1 = partdefinition.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(104, 0).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 20.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)4.0f, (float)0.0f));
        PartDefinition boot1 = leg1.m_171599_("boot1", CubeListBuilder.m_171558_().m_171514_(104, 26).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        ModelPart head = this.waist.m_171324_("chest").m_171324_("head");
        ModelPart chest = this.waist.m_171324_("chest");
        this.leg1.f_104203_ = -1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.leg2.f_104203_ = 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        if (entity instanceof AbsorberEntity) {
            AbsorberEntity absorber = (AbsorberEntity)entity;
            this.m_233385_(absorber.getAnimationState("attack"), AbsorberAnimation.ATTACK, ageInTicks, absorber.getAnimationSpeed());
            this.m_233385_(absorber.getAnimationState("death"), AbsorberAnimation.DEATH, ageInTicks, absorber.getAnimationSpeed());
            if (absorber.f_20919_ >= 30 && absorber.f_20919_ < 44) {
                chest.f_104200_ += (-0.5f + this.random.nextFloat()) * 0.8f;
                chest.f_104201_ += (-0.5f + this.random.nextFloat()) * 0.8f;
                chest.f_104202_ += (-0.5f + this.random.nextFloat()) * 0.8f;
            }
        }
        head.f_104204_ += netHeadYaw * ((float)Math.PI / 180);
        head.f_104203_ += headPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.waist.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg2.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public ModelPart m_5585_() {
        return this.waist.m_171324_("chest").m_171324_("head");
    }
}

