/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.mixin;

import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.common.FishingHookLogic;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FishingHook.class})
public abstract class FishingHookMixin {
    @Inject(method={"catchingFish"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancel_catchingFish(BlockPos pPos, CallbackInfo ci) {
        FishingHook hook = (FishingHook)this;
        if (FishingHookLogic.getStoredRewards(hook).isEmpty()) {
            ci.cancel();
        }
    }

    @Inject(method={"retrieve"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/eventbus/api/IEventBus;post(Lnet/minecraftforge/eventbus/api/Event;)Z")}, cancellable=true)
    public void retrieve(ItemStack pStack, CallbackInfoReturnable<Integer> cir, @Local List<ItemStack> items) {
        FishingHook hook = (FishingHook)this;
        ServerPlayer player = (ServerPlayer)hook.m_37168_();
        if (player == null) {
            return;
        }
        if (items.stream().anyMatch(stack -> stack.m_204117_(StardewFishing.STARTS_MINIGAME))) {
            CriteriaTriggers.f_10553_.m_40416_(player, pStack, hook, items);
            FishingHookLogic.getStoredRewards(hook).ifPresent(rewards -> rewards.addAll(items));
            FishingHookLogic.startMinigame(player);
            cir.cancel();
        } else {
            FishingHookLogic.modifyRewards(items, 0.0);
            player.m_9236_().m_6269_(null, (Entity)player, (SoundEvent)StardewFishing.PULL_ITEM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

