/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.common.networking;

import com.bonker.stardewfishing.common.FishingHookLogic;
import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;

public record C2SCompleteMinigamePacket(boolean success, double accuracy) {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static C2SCompleteMinigamePacket decode(FriendlyByteBuf buf) {
        boolean success;
        return new C2SCompleteMinigamePacket(success, (success = buf.readBoolean()) ? buf.readDouble() : -1.0);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.success);
        if (this.success) {
            buf.writeDouble(this.accuracy);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        ServerPlayer player = contextSupplier.get().getSender();
        if (player == null) {
            return;
        }
        FishingHook hook = player.f_36083_;
        if (hook == null || FishingHookLogic.getStoredRewards(hook).isEmpty()) {
            LOGGER.warn("{} tried to complete a fishing minigame that doesn't exist", (Object)player.m_6302_());
            return;
        }
        contextSupplier.get().enqueueWork(() -> {
            InteractionHand hand = FishingHookLogic.getRodHand((Player)player);
            if (hand == null) {
                FishingHookLogic.endMinigame((Player)player, false, 0.0);
                LOGGER.warn("{} tried to complete a fishing minigame without a fishing rod", (Object)player.m_6302_());
            } else {
                FishingHookLogic.endMinigame((Player)player, this.success, this.accuracy);
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
        });
    }
}

