/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.common;

import com.bonker.stardewfishing.SFConfig;
import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.common.networking.S2CStartMinigamePacket;
import com.bonker.stardewfishing.common.networking.SFNetworking;
import com.bonker.stardewfishing.server.FishBehaviorReloadListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishingHookLogic {
    private final ArrayList<ItemStack> rewards = new ArrayList();

    public static void attachCap(AttachCapabilitiesEvent<Entity> event) {
        if (!((Entity)event.getObject()).getCapability(CapProvider.CAP).isPresent()) {
            event.addCapability(CapProvider.NAME, (ICapabilityProvider)new CapProvider());
        }
    }

    public static Optional<ArrayList<ItemStack>> getStoredRewards(FishingHook entity) {
        return entity.getCapability(CapProvider.CAP).map(cap -> cap.rewards);
    }

    public static void startMinigame(ServerPlayer player) {
        if (player.f_36083_ == null) {
            return;
        }
        SFNetworking.sendToPlayer(player, new S2CStartMinigamePacket(FishBehaviorReloadListener.getBehavior(FishingHookLogic.getStoredRewards(player.f_36083_).flatMap(rewards -> rewards.stream().filter(stack -> stack.m_204117_(StardewFishing.STARTS_MINIGAME)).findFirst()).orElse(null))));
    }

    public static void endMinigame(Player player, boolean success, double accuracy) {
        if (success && !player.m_9236_().f_46443_) {
            FishingHookLogic.modifyRewards((ServerPlayer)player, accuracy);
            FishingHookLogic.giveRewards((ServerPlayer)player, accuracy);
        }
        if (player.f_36083_ != null) {
            player.f_36083_.m_146870_();
        }
    }

    public static void modifyRewards(ServerPlayer player, double accuracy) {
        if (player.f_36083_ == null) {
            return;
        }
        FishingHookLogic.getStoredRewards(player.f_36083_).ifPresent(rewards -> FishingHookLogic.modifyRewards(rewards, accuracy));
    }

    public static void modifyRewards(List<ItemStack> rewards, double accuracy) {
        if (StardewFishing.QUALITY_FOOD_INSTALLED) {
            int quality = SFConfig.getQuality(accuracy);
            for (ItemStack reward : rewards) {
                if (!reward.m_204117_(StardewFishing.STARTS_MINIGAME)) continue;
                if (quality == 0 && reward.m_41782_() && reward.m_41784_().m_128441_("quality_food")) {
                    if (reward.m_41784_().m_128440_() > 1) {
                        reward.m_41784_().m_128473_("quality_food");
                        continue;
                    }
                    reward.m_41751_(null);
                    continue;
                }
                if (quality <= 0) continue;
                CompoundTag qualityFood = new CompoundTag();
                qualityFood.m_128405_("quality", quality);
                reward.m_41784_().m_128365_("quality_food", (Tag)qualityFood);
            }
        }
    }

    public static void giveRewards(ServerPlayer player, double accuracy) {
        if (player.f_36083_ == null) {
            return;
        }
        InteractionHand hand = FishingHookLogic.getRodHand((Player)player);
        if (hand == null) {
            return;
        }
        FishingHook hook = player.f_36083_;
        FishingHookLogic.getStoredRewards(hook).ifPresent(rewards -> {
            ItemFishedEvent event = new ItemFishedEvent((List)rewards, hook.m_20096_() ? 2 : 1, hook);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                hook.m_146870_();
                return;
            }
            player.m_21120_(hand).m_41622_(event.getRodDamage(), (LivingEntity)player, p -> p.m_21190_(hand));
            ServerLevel level = player.m_9236_();
            for (ItemStack reward : rewards) {
                if (reward.m_204117_(ItemTags.f_13156_)) {
                    player.m_36220_(Stats.f_12939_);
                }
                ItemEntity itementity = new ItemEntity((Level)level, hook.m_20185_(), hook.m_20186_(), hook.m_20189_(), reward);
                double dx = player.m_20185_() - hook.m_20185_();
                double dy = player.m_20186_() - hook.m_20186_();
                double dz = player.m_20189_() - hook.m_20189_();
                double scale = 0.1;
                itementity.m_20334_(dx * scale, dy * scale + Math.sqrt(Math.sqrt(dx * dx + dy * dy + dz * dz)) * 0.08, dz * scale);
                level.m_7967_((Entity)itementity);
                int exp = Mth.m_14107_((double)((double)(player.m_217043_().m_188503_(6) + 1) * SFConfig.getMultiplier(accuracy)));
                level.m_7967_((Entity)new ExperienceOrb((Level)level, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_() + 0.5, exp));
            }
            player.m_9236_().m_6269_(null, (Entity)player, (SoundEvent)StardewFishing.PULL_ITEM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        });
    }

    public static InteractionHand getRodHand(Player player) {
        boolean mainHand = player.m_21120_(InteractionHand.MAIN_HAND).canPerformAction(ToolActions.FISHING_ROD_CAST);
        if (mainHand) {
            return InteractionHand.MAIN_HAND;
        }
        boolean offHand = player.m_21120_(InteractionHand.OFF_HAND).canPerformAction(ToolActions.FISHING_ROD_CAST);
        if (offHand) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    private static class CapProvider
    implements ICapabilityProvider {
        private static final Capability<FishingHookLogic> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<FishingHookLogic>(){});
        private static final ResourceLocation NAME = new ResourceLocation("stardew_fishing", "hook");
        private final LazyOptional<FishingHookLogic> optional = LazyOptional.of(FishingHookLogic::new);

        private CapProvider() {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return this.getCapability(cap);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
            return cap == CAP ? this.optional.cast() : LazyOptional.empty();
        }
    }
}

