/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.client.util;

import java.util.Random;
import net.minecraft.util.Mth;

public class Shake {
    private final Random random = new Random();
    private float strength;
    private float strengthSqr;
    private int interval;
    private float lastX = 0.0f;
    private float lastY = 0.0f;
    private float x = 0.0f;
    private float y = 0.0f;
    private int timer = 0;

    public Shake(float strength, int interval) {
        this.setValues(strength, interval);
    }

    public void setValues(float strength, int interval) {
        this.strength = strength;
        this.strengthSqr = strength * 0.5f * (strength * 0.5f);
        this.interval = interval;
    }

    public void tick() {
        if (++this.timer >= this.interval) {
            this.timer = 0;
            this.lastX = this.x;
            this.lastY = this.y;
            while (this.distSqr() < this.strengthSqr) {
                this.x = Mth.m_14036_((float)(this.lastX + this.random.nextFloat(-this.strength, this.strength)), (float)(-this.strength), (float)this.strength);
                this.y = Mth.m_14036_((float)(this.lastY + this.random.nextFloat(-this.strength, this.strength)), (float)(-this.strength), (float)this.strength);
            }
        }
    }

    public float getXOffset(float partialTick) {
        return this.lastX + partialTick * (this.x - this.lastX) * ((float)this.timer / (float)this.interval);
    }

    public float getYOffset(float partialTick) {
        return this.lastY + partialTick * (this.y - this.lastX) * ((float)this.timer / (float)this.interval);
    }

    private float distSqr() {
        return (this.x - this.lastX) * (this.x - this.lastX) + (this.y - this.lastY) * (this.y - this.lastY);
    }
}

