/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.client;

import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.client.FishingMinigame;
import com.bonker.stardewfishing.client.util.Animation;
import com.bonker.stardewfishing.client.util.RenderUtil;
import com.bonker.stardewfishing.client.util.Shake;
import com.bonker.stardewfishing.common.FishBehavior;
import com.bonker.stardewfishing.common.networking.C2SCompleteMinigamePacket;
import com.bonker.stardewfishing.common.networking.SFNetworking;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class FishingScreen
extends Screen {
    private static final Component TITLE = Component.m_237113_((String)"Fishing Minigame");
    private static final ResourceLocation TEXTURE = new ResourceLocation("stardew_fishing", "textures/minigame.png");
    private static final int GUI_WIDTH = 38;
    private static final int GUI_HEIGHT = 152;
    private static final int HIT_WIDTH = 73;
    private static final int HIT_HEIGHT = 29;
    private static final int PERFECT_WIDTH = 41;
    private static final int PERFECT_HEIGHT = 12;
    private static final float ALPHA_PER_TICK = 0.1f;
    private static final float HANDLE_ROT_FAST = 1.0471976f;
    private static final float HANDLE_ROT_SLOW = -0.44879895f;
    private static final int REEL_FAST_LENGTH = 30;
    private static final int REEL_SLOW_LENGTH = 20;
    private static final int CREAK_LENGTH = 6;
    private int leftPos;
    private int topPos;
    private final FishingMinigame minigame;
    public Status status = Status.HIT_TEXT;
    public double accuracy = -1.0;
    private boolean mouseDown = false;
    private int animationTimer = 0;
    private final Animation textSize = new Animation(0.0f);
    private final Animation progressBar;
    private final Animation bobberPos = new Animation(0.0f);
    private final Animation bobberAlpha = new Animation(1.0f);
    private final Animation fishPos = new Animation(0.0f);
    private final Animation handleRot = new Animation(0.0f);
    private final Shake shake = new Shake(0.75f, 1);
    public int reelSoundTimer = -1;
    private int creakSoundTimer = 0;

    public FishingScreen(FishBehavior behavior) {
        super(TITLE);
        this.minigame = new FishingMinigame(this, behavior);
        this.progressBar = new Animation(this.minigame.getProgress());
    }

    public void m_6305_(PoseStack poseStack, int pMouseX, int pMouseY, float pPartialTick) {
        float partialTick = this.f_96541_.m_91296_();
        if (!this.m_7043_()) {
            float scale = this.textSize.getInterpolated(partialTick) * 1.5f;
            float x = ((float)this.f_96543_ - 73.0f * scale) / 2.0f;
            float y = ((float)this.f_96544_ - 29.0f * scale) / 3.0f;
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, 1.0f);
            RenderUtil.blitF(poseStack, TEXTURE, x * (1.0f / scale), y * (1.0f / scale), 71, 0, 73, 29);
            poseStack.m_85849_();
        } else {
            this.m_7333_(poseStack);
            RenderUtil.drawWithShake(poseStack, this.shake, partialTick, this.status == Status.SUCCESS || this.status == Status.FAILURE, () -> {
                RenderUtil.drawWithBlend(() -> {
                    RenderUtil.blitF(poseStack, TEXTURE, this.leftPos, this.topPos, 0, 0, 38, 152);
                    RenderUtil.drawWithAlpha(this.bobberAlpha.getInterpolated(partialTick), () -> {
                        float bobberY = -32.0f + (142.0f - this.bobberPos.getInterpolated(partialTick));
                        RenderUtil.blitF(poseStack, TEXTURE, this.leftPos + 18, (float)this.topPos + bobberY, 38, 0, 9, 36);
                    });
                });
                RenderUtil.drawWithShake(poseStack, this.shake, partialTick, this.minigame.isBobberOnFish() && this.status == Status.MINIGAME, () -> {
                    float fishY = -12.0f + (142.0f - this.fishPos.getInterpolated(partialTick));
                    RenderUtil.blitF(poseStack, TEXTURE, this.leftPos + 14, (float)this.topPos + fishY, 55, 0, 16, 15);
                });
                float progress = this.progressBar.getInterpolated(partialTick);
                int color = Mth.m_14169_((float)(progress / 3.0f), (float)1.0f, (float)1.0f) | 0xFF000000;
                RenderUtil.fillF(poseStack, this.leftPos + 33, this.topPos + 148, this.leftPos + 37, (float)(this.topPos + 148) - progress * 145.0f, color);
                RenderUtil.drawRotatedAround(poseStack, TEXTURE, this.handleRot.getInterpolated(partialTick), this.leftPos + 5, this.topPos + 129, (float)this.leftPos + 6.5f, (float)this.topPos + 130.5f, 47, 0, 8, 3);
                if (this.status == Status.SUCCESS && this.accuracy == 1.0) {
                    float scale = this.textSize.getInterpolated(partialTick);
                    float x = (float)(this.leftPos + 2) + (41.0f - 41.0f * scale) / 2.0f;
                    float y = (float)this.topPos - 12.0f * scale;
                    poseStack.m_85836_();
                    poseStack.m_85841_(scale, scale, 1.0f);
                    RenderUtil.blitF(poseStack, TEXTURE, x * (1.0f / scale), y * (1.0f / scale), 144, 0, 41, 12);
                    poseStack.m_85849_();
                }
            });
        }
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 38) / 2;
        this.topPos = (this.f_96544_ - 152) / 2;
    }

    public void m_86600_() {
        this.shake.tick();
        switch (this.status) {
            case HIT_TEXT: {
                if (this.animationTimer >= 20) break;
                if (++this.animationTimer == 20) {
                    this.status = Status.MINIGAME;
                    break;
                }
                if (this.animationTimer <= 5) {
                    this.textSize.addValue(0.2f);
                    break;
                }
                if (this.animationTimer <= 15) {
                    this.textSize.addValue(-0.013f);
                    break;
                }
                this.textSize.addValue(-0.16f);
                break;
            }
            case MINIGAME: {
                this.minigame.tick(this.mouseDown);
                boolean onFish = this.minigame.isBobberOnFish();
                this.progressBar.setValue(this.minigame.getProgress());
                this.bobberPos.setValue(this.minigame.getBobberPos());
                this.bobberAlpha.addValue(onFish ? 0.1f : -0.1f, 0.4f, 1.0f);
                this.fishPos.setValue(this.minigame.getFishPos());
                this.handleRot.addValue(onFish ? 1.0471976f : -0.44879895f);
                if (this.reelSoundTimer == -1 || --this.reelSoundTimer == 0) {
                    this.reelSoundTimer = onFish ? 30 : 20;
                    this.playSound(onFish ? (SoundEvent)StardewFishing.REEL_FAST.get() : (SoundEvent)StardewFishing.REEL_SLOW.get());
                }
                if (this.creakSoundTimer > 0) {
                    --this.creakSoundTimer;
                }
                if (!this.mouseDown || this.creakSoundTimer != 0) break;
                this.creakSoundTimer = 6;
                this.playSound((SoundEvent)StardewFishing.REEL_CREAK.get());
                break;
            }
            case SUCCESS: 
            case FAILURE: {
                if (--this.animationTimer == 0) {
                    this.m_7379_();
                    break;
                }
                if (this.animationTimer >= 15) {
                    this.textSize.addValue(0.2f);
                    break;
                }
                if (this.animationTimer >= 5) {
                    this.textSize.addValue(-0.013f);
                    break;
                }
                this.textSize.addValue(-0.16f);
            }
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 || pButton == 1) {
            if (!this.mouseDown) {
                this.playSound((SoundEvent)StardewFishing.REEL_CREAK.get());
                this.mouseDown = true;
            }
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 || pButton == 1) {
            if (this.mouseDown) {
                this.mouseDown = false;
            }
            return true;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public void m_7379_() {
        super.m_7379_();
        SFNetworking.sendToServer(new C2SCompleteMinigamePacket(this.status == Status.SUCCESS, this.accuracy));
        this.stopReelingSounds();
    }

    public boolean m_6913_() {
        return this.status == Status.MINIGAME;
    }

    public boolean m_7043_() {
        return this.status != Status.HIT_TEXT;
    }

    public void setResult(boolean success, double accuracy) {
        this.status = success ? Status.SUCCESS : Status.FAILURE;
        this.accuracy = accuracy;
        this.animationTimer = 20;
        this.textSize.reset(0.0f);
        this.progressBar.freeze();
        this.bobberPos.freeze();
        this.bobberAlpha.freeze();
        this.fishPos.freeze();
        this.handleRot.freeze();
        this.playSound(success ? (SoundEvent)StardewFishing.COMPLETE.get() : (SoundEvent)StardewFishing.FISH_ESCAPE.get());
        this.shake.setValues(2.0f, 1);
    }

    public void playSound(SoundEvent soundEvent) {
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)soundEvent, (float)1.0f));
    }

    public void stopReelingSounds() {
        this.f_96541_.m_91106_().m_120386_(StardewFishing.REEL_FAST.getId(), null);
        this.f_96541_.m_91106_().m_120386_(StardewFishing.REEL_SLOW.getId(), null);
    }

    public static enum Status {
        HIT_TEXT,
        MINIGAME,
        SUCCESS,
        FAILURE;

    }
}

