/*
 * Decompiled with CFR 0.152.
 */
package com.dreu.potionshrines.blocks;

import com.dreu.potionshrines.PotionShrines;
import com.dreu.potionshrines.blocks.ShrineBlockEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ShrineRenderer
implements BlockEntityRenderer<ShrineBlockEntity> {
    public ShrineRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ShrineBlockEntity shrineEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        float cooldown = shrineEntity.getRemainingCooldown();
        if (cooldown == 0.0f) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, Math.sin((double)((float)shrineEntity.m_58904_().m_46467_() + partialTicks) * 0.05) * 0.1, 0.5);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(((float)shrineEntity.m_58904_().m_46467_() + partialTicks) % 360.0f));
            RenderSystem.m_157427_(GameRenderer::m_172673_);
            RenderSystem.m_69482_();
            poseStack.m_85841_(0.88889f, 0.88889f, 0.88889f);
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            itemRenderer.m_115189_(this.getBakedIconOrDefault(shrineEntity.getIcon()), ItemStack.f_41583_, 0xF000F0, combinedOverlay, poseStack, bufferSource.m_6299_(RenderType.m_110463_()));
            poseStack.m_85849_();
        } else if (cooldown < 40.0f) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, (double)(-cooldown) * 0.01, 0.5);
            float normalizedCooldown = cooldown / 40.0f;
            poseStack.m_85841_(1.0f - normalizedCooldown * normalizedCooldown, 1.0f - normalizedCooldown * normalizedCooldown, 1.0f - normalizedCooldown * normalizedCooldown);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(((float)shrineEntity.m_58904_().m_46467_() + partialTicks) * (1.0f - normalizedCooldown * normalizedCooldown) % 360.0f));
            RenderSystem.m_157427_(GameRenderer::m_172673_);
            RenderSystem.m_69482_();
            poseStack.m_85841_(0.88889f, 0.88889f, 0.88889f);
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            itemRenderer = Minecraft.m_91087_().m_91291_();
            itemRenderer.m_115189_(this.getBakedIconOrDefault(shrineEntity.getIcon()), ItemStack.f_41583_, 0xF000F0, combinedOverlay, poseStack, bufferSource.m_6299_(RenderType.m_110463_()));
            poseStack.m_85849_();
        } else if (cooldown > (float)(shrineEntity.getMaxCooldown() - 20)) {
            cooldown = (float)shrineEntity.getMaxCooldown() - cooldown;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, (double)cooldown * 0.04 + 0.1, 0.5);
            float normalizedCooldown = (cooldown - 1.0f) / 19.0f;
            poseStack.m_85841_(1.0f - normalizedCooldown * normalizedCooldown, 1.0f - normalizedCooldown * normalizedCooldown, 1.0f - normalizedCooldown * normalizedCooldown);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(((float)shrineEntity.m_58904_().m_46467_() + partialTicks) * (1.0f + normalizedCooldown * normalizedCooldown * 8.0f) % 360.0f));
            RenderSystem.m_157427_(GameRenderer::m_172673_);
            RenderSystem.m_69482_();
            poseStack.m_85841_(0.88889f, 0.88889f, 0.88889f);
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            itemRenderer = Minecraft.m_91087_().m_91291_();
            itemRenderer.m_115189_(this.getBakedIconOrDefault(shrineEntity.getIcon()), ItemStack.f_41583_, 0xF000F0, combinedOverlay, poseStack, bufferSource.m_6299_(RenderType.m_110463_()));
            poseStack.m_85849_();
        }
        RenderSystem.m_69482_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("potion_shrines", "textures/recharging.png"));
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, -1.375, 0.5);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        float uvY = 1.0f - (float)shrineEntity.getRemainingCooldown() / (float)shrineEntity.getMaxCooldown();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        for (int i = 0; i < 4; ++i) {
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), -0.125f, 0.0f, 0.1876f).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), 0.125f, 0.0f, 0.1876f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), 0.125f, 1.0625f * uvY, 0.1876f).m_7421_(1.0f, 1.0f - uvY).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), -0.125f, 1.0625f * uvY, 0.1876f).m_7421_(0.0f, 1.0f - uvY).m_5752_();
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        }
        Tesselator.m_85913_().m_85914_();
        poseStack.m_85849_();
    }

    private BakedModel getBakedIconOrDefault(String key) {
        return PotionShrines.BAKED_ICONS.get(key) == null ? PotionShrines.BAKED_ICONS.get("default") : PotionShrines.BAKED_ICONS.get(key);
    }
}

