/*
 * Decompiled with CFR 0.152.
 */
package com.ferri.arnus.unidentifiedenchantments.compat.jei;

import com.ferri.arnus.unidentifiedenchantments.compat.jei.UnidentifiedEnchantmentRecipeManagerPlugin;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

@JeiPlugin
public class UnidentifiedEnchantmentsPlugin
implements IModPlugin {
    public static List<IJeiAnvilRecipe> hiddenlist = new ArrayList<IJeiAnvilRecipe>();
    private List<ItemStack> enchantedBooks = new ArrayList<ItemStack>();

    public UnidentifiedEnchantmentsPlugin() {
        for (Enchantment enchantment : Registry.f_122825_) {
            this.enchantedBooks.add(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, 1)));
        }
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("unidentifiedenchantments", "jeiplugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeManager recipeManager = jeiRuntime.getRecipeManager();
        IJeiHelpers jeiHelpers = jeiRuntime.getJeiHelpers();
        IFocusFactory focusFactory = jeiHelpers.getFocusFactory();
        List<IFocus> enchantedBookFocuses = this.enchantedBooks.stream().map(enchantedBook -> focusFactory.createFocus(RecipeIngredientRole.INPUT, (IIngredientType)VanillaTypes.ITEM_STACK, enchantedBook)).toList();
        List enchantedBookRecipes = recipeManager.createRecipeLookup(RecipeTypes.ANVIL).limitFocus(enchantedBookFocuses).get().toList();
        hiddenlist = enchantedBookRecipes;
        recipeManager.hideRecipes(RecipeTypes.ANVIL, enchantedBookRecipes);
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        registration.addRecipeManagerPlugin((IRecipeManagerPlugin)new UnidentifiedEnchantmentRecipeManagerPlugin());
    }
}

