/*
 * Decompiled with CFR 0.152.
 */
package com.ferri.arnus.unidentifiedenchantments.capability;

import com.ferri.arnus.unidentifiedenchantments.capability.IHiddenEnchantments;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class HiddenEnchantments
implements IHiddenEnchantments {
    private Map<Enchantment, String> hiddenmap = new HashMap<Enchantment, String>();
    private final ItemStack stack;
    private final RandomSource random = RandomSource.m_216327_();
    private final String[] words = new String[]{"the", "elder", "scrolls", "klaatu", "berata", "niktu", "xyzzy", "bless", "curse", "light", "darkness", "fire", "air", "earth", "water", "hot", "dry", "cold", "wet", "ignite", "snuff", "embiggen", "twist", "shorten", "stretch", "fiddle", "destroy", "imbue", "galvanize", "enchant", "free", "limited", "range", "of", "towards", "inside", "sphere", "cube", "self", "other", "ball", "mental", "physical", "grow", "shrink", "demon", "elemental", "spirit", "animal", "creature", "beast", "humanoid", "undead", "fresh", "stale", "phnglui", "mglwnafh", "cthulhu", "rlyeh", "wgahnagl", "fhtagn", "baguette"};

    public HiddenEnchantments(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public void setHiddenMap(Map<Enchantment, String> hiddenmap) {
        ListTag listtag = new ListTag();
        for (Enchantment enchantment : hiddenmap.keySet()) {
            if (enchantment == null) continue;
            CompoundTag storeEnchantment = new CompoundTag();
            storeEnchantment.m_128359_("id", String.valueOf(EnchantmentHelper.m_182432_((Enchantment)enchantment)));
            storeEnchantment.m_128359_("text", hiddenmap.get(enchantment));
            listtag.add((Object)storeEnchantment);
        }
        if (listtag.isEmpty()) {
            this.stack.m_41784_().m_128473_("HiddenEnchantments");
        } else {
            this.stack.m_41784_().m_128365_("HiddenEnchantments", (Tag)listtag);
        }
    }

    @Override
    public Map<Enchantment, String> getHiddenMap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        ListTag listtag = this.stack.m_41784_().m_128437_("HiddenEnchantments", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            Registry.f_122825_.m_6612_(EnchantmentHelper.m_182446_((CompoundTag)compoundtag)).ifPresent(enc -> map.put(enc, compoundtag.m_128461_("text")));
        }
        return map;
    }

    @Override
    public void add(Enchantment enchantment) {
        Map<Enchantment, String> map = this.getHiddenMap();
        map.put(enchantment, this.getRandomName(75));
        this.setHiddenMap(map);
    }

    public void clearHiddenMap() {
        this.stack.m_41784_().m_128473_("HiddenEnchantments");
    }

    public String getRandomName(int pMaxWidth) {
        StringBuilder stringbuilder = new StringBuilder();
        int i = this.random.m_188503_(2) + 3;
        for (int j = 0; j < i; ++j) {
            if (j != 0) {
                stringbuilder.append(" ");
            }
            stringbuilder.append((String)Util.m_214670_((Object[])this.words, (RandomSource)this.random));
        }
        stringbuilder.setLength(pMaxWidth);
        return stringbuilder.toString().replace('\u0000', ' ').strip();
    }
}

