/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.protectyourstructures;

import me.khajiitos.protectyourstructures.Config;
import me.khajiitos.protectyourstructures.Effects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventListeners {
    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent e) {
        Config.load((RegistryAccess)e.getServer().m_206579_());
    }

    public BoundingBox getStructureWholeBox(ServerLevel level, BlockPos blockPos, ResourceKey<Structure> structureKey) {
        StructureManager manager = level.m_215010_();
        Structure structure = (Structure)manager.m_220521_().m_175515_(Registry.f_235725_).m_6246_(structureKey);
        BoundingBox boundingBox = new BoundingBox(0, 0, 0, 0, 0, 0);
        if (structure == null) {
            return boundingBox;
        }
        for (StructureStart structureStart : manager.m_220504_(SectionPos.m_123199_((BlockPos)blockPos), structure)) {
            boundingBox.m_162386_(structureStart.m_73601_());
        }
        return boundingBox;
    }

    @SubscribeEvent
    public void tickPlayer(TickEvent.PlayerTickEvent e) {
        Player player = e.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.f_19797_ % 20 == 0) {
                for (ResourceKey resourceKey : Config.structures) {
                    BoundingBox structureBox = this.getStructureWholeBox(player2.m_9236_(), player2.m_20097_(), (ResourceKey<Structure>)resourceKey);
                    if (!structureBox.m_71049_(new BoundingBox(player2.m_20097_()))) continue;
                    player2.m_7292_(new MobEffectInstance(Effects.SACRED_PLACE_EFFECT, 600));
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent e) {
        if (e.getPlayer() != null && !e.getPlayer().m_150110_().f_35937_ && e.getPlayer().m_21023_(Effects.SACRED_PLACE_EFFECT) && e.getState().m_60734_() != Blocks.f_50085_) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.EntityPlaceEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150110_().f_35937_ && player.m_21023_(Effects.SACRED_PLACE_EFFECT)) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlaceFluid(FillBucketEvent e) {
        if (e.getEntity() != null && !e.getEntity().m_150110_().f_35937_ && e.getEntity().m_21023_(Effects.SACRED_PLACE_EFFECT)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlaceBlockByInteract(PlayerInteractEvent.RightClickBlock e) {
        if (e.getEntity() != null && !e.getEntity().m_150110_().f_35937_ && e.getItemStack().m_41720_() instanceof BlockItem && e.getEntity().m_21023_(Effects.SACRED_PLACE_EFFECT)) {
            e.setCanceled(true);
        }
    }
}

