/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.common.wrapper;

import fr.raksrinana.fallingtree.common.wrapper.IEnchantment;
import fr.raksrinana.fallingtree.common.wrapper.IItem;
import fr.raksrinana.fallingtree.common.wrapper.IItemStack;
import fr.raksrinana.fallingtree.common.wrapper.IPlayer;
import fr.raksrinana.fallingtree.forge.common.wrapper.ItemWrapper;
import fr.raksrinana.fallingtree.forge.compat.TetraCompat;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackWrapper
implements IItemStack {
    @NotNull
    private final ItemStack raw;

    @Override
    public boolean isEmpty() {
        return this.raw.m_41619_();
    }

    @Override
    public boolean isDamageable() {
        return this.raw.m_41763_();
    }

    @Override
    public int getDamage() {
        return this.raw.m_41773_();
    }

    @Override
    public int getMaxDamage() {
        return this.raw.m_41776_();
    }

    @Override
    public void damage(int amount, @NotNull IPlayer player) {
        this.raw.m_41622_(amount, (LivingEntity)((Player)player.getRaw()), entity -> {});
        TetraCompat.tickHoningProgression(this, player);
    }

    @Override
    @NotNull
    public IItem getItem() {
        return new ItemWrapper(this.raw.m_41720_());
    }

    @Override
    public int getEnchantLevel(@Nullable IEnchantment enchantment) {
        if (enchantment == null) {
            return 0;
        }
        return this.raw.getEnchantmentLevel((Enchantment)enchantment.getRaw());
    }

    @Override
    public boolean hasOneOfEnchantAtLeast(@NotNull Collection<IEnchantment> enchantments, int minLevel) {
        Map itemEnchantments = EnchantmentHelper.m_44831_((ItemStack)this.raw);
        for (IEnchantment enchantment : enchantments) {
            Enchantment key = (Enchantment)enchantment.getRaw();
            if (!itemEnchantments.containsKey(key) || (Integer)itemEnchantments.get(key) < minLevel) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Optional<IEnchantment> getAnyEnchant(@NotNull Collection<IEnchantment> enchantments) {
        Map itemEnchantments = EnchantmentHelper.m_44831_((ItemStack)this.raw);
        for (IEnchantment enchantment : enchantments) {
            Enchantment key = (Enchantment)enchantment.getRaw();
            if (!itemEnchantments.containsKey(key)) continue;
            return Optional.of(enchantment);
        }
        return Optional.empty();
    }

    @Override
    public boolean canPerformAxeAction() {
        return this.raw.canPerformAction(ToolActions.AXE_DIG);
    }

    public ItemStackWrapper(@NotNull ItemStack raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    public String toString() {
        return "ItemStackWrapper(raw=" + this.getRaw() + ")";
    }

    @NotNull
    public ItemStack getRaw() {
        return this.raw;
    }
}

