/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.common.config.proxy;

import fr.raksrinana.fallingtree.common.FallingTreeCommon;
import fr.raksrinana.fallingtree.common.config.IResettable;
import fr.raksrinana.fallingtree.common.config.IToolConfiguration;
import fr.raksrinana.fallingtree.common.config.enums.DamageRounding;
import fr.raksrinana.fallingtree.common.wrapper.IItem;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class ToolProxyConfiguration
implements IToolConfiguration,
IResettable {
    private final IToolConfiguration delegate;
    private Double speedMultiplicand;
    private Boolean forceToolUsage;

    @Override
    public void reset() {
        this.setSpeedMultiplicand(null);
        this.setForceToolUsage(null);
    }

    @Override
    @NotNull
    public Collection<IItem> getDeniedItems(@NotNull FallingTreeCommon<?> mod) {
        return this.delegate.getDeniedItems(mod);
    }

    @Override
    @NotNull
    public Collection<IItem> getAllowedItems(@NotNull FallingTreeCommon<?> mod) {
        return this.delegate.getAllowedItems(mod);
    }

    @Override
    public boolean isPreserve() {
        return this.delegate.isPreserve();
    }

    @Override
    public boolean isIgnoreTools() {
        return this.delegate.isIgnoreTools();
    }

    @Override
    public double getDamageMultiplicand() {
        return this.delegate.getDamageMultiplicand();
    }

    @Override
    public DamageRounding getDamageRounding() {
        return this.delegate.getDamageRounding();
    }

    @Override
    public double getSpeedMultiplicand() {
        return Optional.ofNullable(this.speedMultiplicand).orElseGet(this.delegate::getSpeedMultiplicand);
    }

    @Override
    public boolean isForceToolUsage() {
        return Optional.ofNullable(this.forceToolUsage).orElseGet(this.delegate::isForceToolUsage);
    }

    public ToolProxyConfiguration(IToolConfiguration delegate) {
        this.delegate = delegate;
    }

    public void setSpeedMultiplicand(Double speedMultiplicand) {
        this.speedMultiplicand = speedMultiplicand;
    }

    public void setForceToolUsage(Boolean forceToolUsage) {
        this.forceToolUsage = forceToolUsage;
    }
}

