/*
 * Decompiled with CFR 0.152.
 */
package andrews.swampier_swamps.objects.blocks;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MudStairsBlock
extends StairBlock {
    private static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private static final VoxelShape TOP_AABB = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape OCTET_NNN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)6.0, (double)8.0);
    private static final VoxelShape OCTET_NNP = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)6.0, (double)16.0);
    private static final VoxelShape OCTET_NPN = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)8.0, (double)14.0, (double)8.0);
    private static final VoxelShape OCTET_NPP = Block.m_49796_((double)0.0, (double)6.0, (double)8.0, (double)8.0, (double)14.0, (double)16.0);
    private static final VoxelShape OCTET_PNN = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)8.0);
    private static final VoxelShape OCTET_PNP = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)6.0, (double)16.0);
    private static final VoxelShape OCTET_PPN = Block.m_49796_((double)8.0, (double)6.0, (double)0.0, (double)16.0, (double)14.0, (double)8.0);
    private static final VoxelShape OCTET_PPP = Block.m_49796_((double)8.0, (double)6.0, (double)8.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape[] TOP_SHAPES = MudStairsBlock.makeShapes(TOP_AABB, OCTET_NNN, OCTET_PNN, OCTET_NNP, OCTET_PNP);
    private static final VoxelShape[] BOTTOM_SHAPES = MudStairsBlock.makeShapes(BOTTOM_AABB, OCTET_NPN, OCTET_PPN, OCTET_NPP, OCTET_PPP);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] makeShapes(VoxelShape shape1, VoxelShape shape2, VoxelShape shape3, VoxelShape shape4, VoxelShape shape5) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(type -> MudStairsBlock.makeStairShape(type, shape1, shape2, shape3, shape4, shape5)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape makeStairShape(int type, VoxelShape shape1, VoxelShape shape2, VoxelShape shape3, VoxelShape shape4, VoxelShape shape5) {
        VoxelShape voxelshape = shape1;
        if ((type & 1) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)shape1, (VoxelShape)shape2);
        }
        if ((type & 2) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)shape3);
        }
        if ((type & 4) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)shape4);
        }
        if ((type & 8) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)shape5);
        }
        return voxelshape;
    }

    public MudStairsBlock(BlockState state, BlockBehaviour.Properties properties) {
        super(state, properties);
    }

    public MudStairsBlock(Supplier<BlockState> state, BlockBehaviour.Properties properties) {
        super(state, properties);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return (state.m_61143_((Property)f_56842_) == Half.TOP ? TOP_SHAPES : BOTTOM_SHAPES)[SHAPE_BY_STATE[this.getShapeIndex(state)]];
    }

    private int getShapeIndex(BlockState state) {
        return ((StairsShape)state.m_61143_((Property)f_56843_)).ordinal() * 4 + ((Direction)state.m_61143_((Property)f_56841_)).m_122416_();
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType pathComputationType) {
        return false;
    }
}

