/*
 * Decompiled with CFR 0.152.
 */
package andrews.swampier_swamps.mixins;

import andrews.swampier_swamps.registry.SSBlocks;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.sensing.SecondaryPoiSensor;
import net.minecraft.world.entity.npc.Villager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SecondaryPoiSensor.class})
public class SecondaryPoiSensorMixin {
    @Unique
    private final List<GlobalPos> fertileFarmlandPosList = Lists.newArrayList();

    @Inject(method={"doTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/npc/Villager;)V"}, at={@At(value="HEAD")})
    public void injectDoTick(ServerLevel level, Villager entity, CallbackInfo ci) {
        ResourceKey resourceKey = level.m_46472_();
        BlockPos pos = entity.m_20183_();
        for (int x = -4; x <= 4; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    BlockPos offsetPos = pos.m_7918_(x, y, z);
                    if (!entity.m_7141_().m_35571_().f_35600_().equals("farmer") || level.m_8055_(offsetPos).m_60734_() != SSBlocks.FERTILE_FARMLAND.get()) continue;
                    this.fertileFarmlandPosList.add(GlobalPos.m_122643_((ResourceKey)resourceKey, (BlockPos)offsetPos));
                }
            }
        }
    }

    @ModifyVariable(method={"doTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/npc/Villager;)V"}, at=@At(value="STORE"), ordinal=0)
    public List<GlobalPos> modifyVarDoTick(List<GlobalPos> pos) {
        if (!this.fertileFarmlandPosList.isEmpty()) {
            pos.addAll(this.fertileFarmlandPosList);
            this.fertileFarmlandPosList.clear();
        }
        return pos;
    }
}

