/*
 * Decompiled with CFR 0.152.
 */
package andrews.swampier_swamps.entities;

import andrews.swampier_swamps.registry.SSEntities;
import andrews.swampier_swamps.registry.SSTags;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Dragonfly
extends Animal
implements FlyingAnimal {
    private static final EntityDataAccessor<Integer> DRAGONFLY_TYPE = SynchedEntityData.m_135353_(Dragonfly.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DRAGONFLY_SCALE = SynchedEntityData.m_135353_(Dragonfly.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Dragonfly(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        navigation.m_26440_(false);
        navigation.m_7008_(false);
        navigation.m_26443_(true);
        return navigation;
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FlyingWanderGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundOnFloorGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag compound) {
        spawnData = super.m_6518_(level, difficulty, spawnType, spawnData, compound);
        if (compound != null && compound.m_128425_("Variant", 3)) {
            this.setDragonflyType(compound.m_128451_("Variant"));
            return spawnData;
        }
        this.setDragonflyType(level.m_213780_().m_188503_(4) + 1);
        return spawnData;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getDragonflyType());
        compound.m_128405_("Scale", this.getDragonflyScale());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDragonflyType(compound.m_128451_("Variant"));
        this.setDragonflyScale(compound.m_128451_("Scale"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DRAGONFLY_TYPE, (Object)0);
        this.f_19804_.m_135372_(DRAGONFLY_SCALE, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22280_, 0.8).m_22268_(Attributes.f_22279_, 0.3);
    }

    public static boolean checkDragonflySpawnRules(EntityType<? extends Animal> entity, LevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource rand) {
        return level.m_8055_(pos.m_7495_()).m_204336_(SSTags.Blocks.DRAGONFLIES_SPAWNABLE_ON) && Dragonfly.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)SSEntities.DRAGONFLY.get()).m_20615_((Level)level);
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        return false;
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    public int getDragonflyType() {
        if ((Integer)this.f_19804_.m_135370_(DRAGONFLY_TYPE) == 0) {
            Random rand = new Random();
            this.f_19804_.m_135381_(DRAGONFLY_TYPE, (Object)(rand.nextInt(4) + 1));
        }
        return (Integer)this.f_19804_.m_135370_(DRAGONFLY_TYPE);
    }

    public void setDragonflyType(int typeId) {
        this.f_19804_.m_135381_(DRAGONFLY_TYPE, (Object)typeId);
    }

    public int getDragonflyScale() {
        if ((Integer)this.f_19804_.m_135370_(DRAGONFLY_SCALE) == 0) {
            Random rand = new Random();
            this.f_19804_.m_135381_(DRAGONFLY_SCALE, (Object)(rand.nextInt(5) + 1));
        }
        return (Integer)this.f_19804_.m_135370_(DRAGONFLY_SCALE);
    }

    public void setDragonflyScale(int typeId) {
        this.f_19804_.m_135381_(DRAGONFLY_SCALE, (Object)typeId);
    }

    public boolean isMoving() {
        return this.f_19790_ != this.m_20185_() && this.f_19791_ != this.m_20186_() && this.f_19792_ != this.m_20189_();
    }

    static class FlyingWanderGoal
    extends Goal {
        private final PathfinderMob mob;

        public FlyingWanderGoal(PathfinderMob mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.mob = mob;
        }

        public boolean m_8036_() {
            return this.mob.m_21573_().m_26571_() && this.mob.m_217043_().m_188503_(15) == 0;
        }

        public boolean m_8045_() {
            return this.mob.m_21573_().m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                this.mob.m_21573_().m_26536_(this.mob.m_21573_().m_7864_(new BlockPos(vec3), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 findPos() {
            Vec3 viewVector = this.mob.m_20252_(0.0f);
            Vec3 hoverPos = HoverRandomPos.m_148465_((PathfinderMob)this.mob, (int)8, (int)7, (double)viewVector.f_82479_, (double)viewVector.f_82481_, (float)1.5707964f, (int)3, (int)2);
            return hoverPos != null ? hoverPos : AirAndWaterRandomPos.m_148357_((PathfinderMob)this.mob, (int)8, (int)4, (int)-1, (double)viewVector.f_82479_, (double)viewVector.f_82481_, (double)1.5707963705062866);
        }
    }

    static class RandomLookAroundOnFloorGoal
    extends RandomLookAroundGoal {
        private final PathfinderMob mob;

        public RandomLookAroundOnFloorGoal(PathfinderMob mob) {
            super((Mob)mob);
            this.mob = mob;
        }

        public boolean m_8036_() {
            return !this.mob.m_20075_().m_60795_() && this.mob.m_217043_().m_188501_() < 0.04f;
        }
    }
}

