/*
 * Decompiled with CFR 0.152.
 */
package andrews.swampier_swamps.config.configs;

import andrews.swampier_swamps.config.util.ConfigHelper;
import net.minecraftforge.common.ForgeConfigSpec;

public class SSCommonConfig {
    public ConfigHelper.ConfigValueListener<Integer> waterRange;
    public ConfigHelper.ConfigValueListener<Integer> growthMultiplier;
    public ConfigHelper.ConfigValueListener<Integer> explosionStrength;
    public ConfigHelper.ConfigValueListener<Boolean> givesNegativeEffects;
    public ConfigHelper.ConfigValueListener<Boolean> isFurnaceFuel;
    public ConfigHelper.ConfigValueListener<Integer> burnTime;
    public ConfigHelper.ConfigValueListener<Boolean> allowWaldo;
    public ConfigHelper.ConfigValueListener<Double> waldoDamageModifier;
    public ConfigHelper.ConfigValueListener<Boolean> alterRecipes;
    public ConfigHelper.ConfigValueListener<Integer> growBaldCypressFromSaplings;
    public ConfigHelper.ConfigValueListener<Boolean> doLilyPadsSink;
    public ConfigHelper.ConfigValueListener<Boolean> doLilyPadsBreak;
    public ConfigHelper.ConfigValueListener<Integer> shouldLilyPadsGrow;
    public ConfigHelper.ConfigValueListener<Integer> lilyPadSinkTimeStage1;
    public ConfigHelper.ConfigValueListener<Integer> lilyPadSinkTimeStage2;
    public ConfigHelper.ConfigValueListener<Integer> lilyPadSinkTimeStage3;
    public ConfigHelper.ConfigValueListener<Integer> lilyPadResetTime;

    public SSCommonConfig(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
        builder.comment(" Common Settings for Swampier Swamps").push("Settings");
        builder.push("Fertile Farmland");
        this.waterRange = subscriber.subscribe(builder.comment("This can be used to adjust how far away from Water, Fertile Farmland\r\ncan turn into Moist Fertile Farmland. Vanilla Farmland uses 4 as its value.".indent(1)).defineInRange("waterRange", 3, 1, 8));
        this.growthMultiplier = subscriber.subscribe(builder.comment("The multiplier used to speed up Crop growth.".indent(1)).defineInRange("growthMultiplier", 6, 1, 10));
        builder.pop();
        builder.push("Swamp Gas");
        this.explosionStrength = subscriber.subscribe(builder.comment("This can be used to alter how big the Swamp Gas explosions are.".indent(1)).defineInRange("explosionStrength", 6, 1, 10));
        this.givesNegativeEffects = subscriber.subscribe(builder.comment("Whether the Swamp Gas Cloud will give Living Entities negative effects,\r\nwhen they walk through it (for example Effects like Poison).".indent(1)).define("givesNegativeEffects", true));
        this.isFurnaceFuel = subscriber.subscribe(builder.comment("This can be used to prevent Swamp Gas from being used as Furnace Fuel.".indent(1)).define("isFurnaceFuel", true));
        this.burnTime = subscriber.subscribe(builder.comment("How long the Swamp Gas fuels a Furnace. (Measured in Ticks)".indent(1)).defineInRange("burnTime", 4000, 10, 60000));
        builder.pop();
        builder.push("Frog");
        this.allowWaldo = subscriber.subscribe(builder.comment("This can be used to prevent Frogs from becoming \"killers\" when named Swallow Me Waldo".indent(1)).define("allowWaldo", true));
        this.waldoDamageModifier = subscriber.subscribe(builder.comment("This value is a Damage multiplier for the \"Swallow Me Waldo\" Frog, meaning \r\nthe value used will be multiplied with the Waldo Frogs base damage. (10 by Default)\r\nThis can get out of hand quickly, so be careful with it. Unless you want a\r\nFrog that can swallow a Wither.".indent(1)).defineInRange("waldoDamageModifier", 2.0, 1.0, 100.0));
        builder.pop();
        builder.push("Brewing");
        this.alterRecipes = subscriber.subscribe(builder.comment("This can be used to disable all changes done to Brewing by Swampier Swamps, in case\r\nof compatibility issues, or any other reason.\r\nThe changes are:\r\n* Altered Leaping Potion Recipe to use Frog Legs instead of Rabbit Paws\r\n+ Added Recipe for Luck Potions, crafted with Rabbit Paws".indent(1)).define("alterRecipes", true));
        builder.pop();
        builder.push("Tree Stuff");
        this.growBaldCypressFromSaplings = subscriber.subscribe(builder.comment("Used to determine whether Bald Cypress Trees can grow from planting Oak Saplings\r\nin a 2x2 pattern. (Like Big Jungle Trees)\nValues:\r\n0: Disables Bald Cypress growth from Oak Saplings completely\r\n1: Bald Cypresses only grow from Oak Saplings, in Biomes specified in #can_bald_cypress_grow_in\r\n2: Enables Bald Cypress growth from Oak Saplings, in all biomes".indent(1)).defineInRange("growBaldCypressFromSaplings", 2, 0, 2));
        builder.pop();
        builder.push("Lily Pad");
        this.doLilyPadsSink = subscriber.subscribe(builder.comment("This can be used to disable Lily Pad sinking completely.\r\nValues:\r\ntrue: Lily Pads will sink when a big Entity stands on them\r\nfalse: Lily Pads wont sink when any Entity stands on them".indent(1)).define("doLilyPadsSink", true));
        this.doLilyPadsBreak = subscriber.subscribe(builder.comment("This is used to determine whether Lily Pads break once they reach their final sink stage.\r\nValues:\r\ntrue: Lily Pads will break\r\nfalse: Lily Pads wont break, and instead become collision-less (like dripleafs)".indent(1)).define("doLilyPadsBreak", true));
        this.shouldLilyPadsGrow = subscriber.subscribe(builder.comment("Whether Lily Pads should grow. To be specific, this makes Small Lily Pads grow into\r\nLily Pads, which grow into Large Lily Pads. And lastly Large Lily Pads create Small\r\nones around themselves.\r\nValues:\r\n0: Disables Lily Pad growth completely\r\n1: Lily Pads only grow in Biomes specified in #can_lily_pad_grow_in\r\n2: Enables Lily Pad growth in all biomes".indent(1)).defineInRange("shouldLilyPadsGrow", 1, 0, 2));
        this.lilyPadSinkTimeStage1 = subscriber.subscribe(builder.comment("These values control how long it takes for the Lily Pad to advance/reset its sink stage.\r\nThis is measured in ticks.".indent(1)).defineInRange("lilyPadSinkTimeStage1", 5, 1, 200));
        this.lilyPadSinkTimeStage2 = subscriber.subscribe(builder.defineInRange("lilyPadSinkTimeStage2", 5, 1, 200));
        this.lilyPadSinkTimeStage3 = subscriber.subscribe(builder.defineInRange("lilyPadSinkTimeStage3", 10, 1, 200));
        this.lilyPadResetTime = subscriber.subscribe(builder.defineInRange("lilyPadResetTime", 20, 1, 200));
        builder.pop();
        builder.pop();
    }
}

