/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.lootjournal.client.renderer;

import com.mojang.blaze3d.platform.Window;
import com.obscuria.lootjournal.LootJournalConfig;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum Anchor {
    TOP_LEFT(window -> 0, (window, offset) -> offset, separation -> 12 + separation, false),
    TOP_RIGHT(Window::m_85445_, (window, offset) -> offset, separation -> 12 + separation, true),
    BOTTOM_LEFT(window -> 0, (window, offset) -> window.m_85446_() - offset - 12, separation -> -12 - separation, false),
    BOTTOM_RIGHT(Window::m_85445_, (window, offset) -> window.m_85446_() - offset - 12, separation -> -12 - separation, true);

    private final Function<Window, Integer> originXFunc;
    private final BiFunction<Window, Integer, Integer> originYFunc;
    private final Function<Integer, Integer> stepFunc;
    private final boolean inverted;

    private Anchor(Function<Window, Integer> originXFunc, BiFunction<Window, Integer, Integer> originYFunc, Function<Integer, Integer> stepFunc, boolean inverted) {
        this.originXFunc = originXFunc;
        this.originYFunc = originYFunc;
        this.stepFunc = stepFunc;
        this.inverted = inverted;
    }

    public int originX(Window window) {
        return this.originXFunc.apply(window);
    }

    public int originY(Window window) {
        return this.originYFunc.apply(window, (Integer)LootJournalConfig.offset.get());
    }

    public int step() {
        return this.stepFunc.apply((Integer)LootJournalConfig.separation.get());
    }

    public boolean isInverted() {
        return this.inverted;
    }
}

