/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.entity.inactive_navigations;

import com.abdelaziz.canary.common.entity.NavigatingEntity;
import com.abdelaziz.canary.common.world.ServerWorldExtended;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
extends Level
implements ServerWorldExtended {
    @Mutable
    @Shadow
    @Final
    Set<Mob> f_143246_;
    private ReferenceOpenHashSet<PathNavigation> activeNavigations;

    protected ServerLevelMixin(WritableLevelData p_220352_, ResourceKey<Level> p_220353_, Holder<DimensionType> p_220354_, Supplier<ProfilerFiller> p_220355_, boolean p_220356_, boolean p_220357_, long p_220358_, int p_220359_) {
        super(p_220352_, p_220353_, p_220354_, p_220355_, p_220356_, p_220357_, p_220358_, p_220359_);
    }

    @Redirect(method={"sendBlockUpdated(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;I)V"}, at=@At(value="INVOKE", target="Ljava/util/Set;iterator()Ljava/util/Iterator;"))
    private Iterator<Mob> getActiveListeners(Set<Mob> set) {
        return Collections.emptyIterator();
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(MinecraftServer p_214999_, Executor p_215000_, LevelStorageSource.LevelStorageAccess p_215001_, ServerLevelData p_215002_, ResourceKey<?> p_215003_, LevelStem p_215004_, ChunkProgressListener p_215005_, boolean p_215006_, long p_215007_, List<?> p_215008_, boolean p_215009_, CallbackInfo ci) {
        this.f_143246_ = new ReferenceOpenHashSet(this.f_143246_);
        this.activeNavigations = new ReferenceOpenHashSet();
    }

    @Override
    public void setNavigationActive(Mob mobEntity) {
        this.activeNavigations.add((Object)((NavigatingEntity)mobEntity).getRegisteredNavigation());
    }

    @Override
    public void setNavigationInactive(Mob mobEntity) {
        this.activeNavigations.remove((Object)((NavigatingEntity)mobEntity).getRegisteredNavigation());
    }

    @Inject(method={"sendBlockUpdated(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;I)V"}, at={@At(value="INVOKE", target="Ljava/util/Set;iterator()Ljava/util/Iterator;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void updateActiveListeners(BlockPos pos, BlockState oldState, BlockState newState, int arg3, CallbackInfo ci, VoxelShape string, VoxelShape voxelShape, List<PathNavigation> list) {
        for (PathNavigation entityNavigation : this.activeNavigations) {
            if (!entityNavigation.m_200903_(pos)) continue;
            list.add(entityNavigation);
        }
    }

    public boolean isConsistent() {
        int i = 0;
        for (Mob mobEntity : this.f_143246_) {
            PathNavigation entityNavigation = mobEntity.m_21573_();
            if ((entityNavigation.m_26570_() != null && ((NavigatingEntity)mobEntity).isRegisteredToWorld()) != this.activeNavigations.contains((Object)entityNavigation)) {
                return false;
            }
            if (entityNavigation.m_26570_() == null) continue;
            ++i;
        }
        return this.activeNavigations.size() == i;
    }
}

