/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.block.hopper;

import com.abdelaziz.canary.api.inventory.CanaryInventory;
import com.abdelaziz.canary.common.block.entity.SleepingBlockEntity;
import com.abdelaziz.canary.common.block.entity.inventory_change_tracking.InventoryChangeListener;
import com.abdelaziz.canary.common.block.entity.inventory_change_tracking.InventoryChangeTracker;
import com.abdelaziz.canary.common.block.entity.inventory_comparator_tracking.ComparatorTracker;
import com.abdelaziz.canary.common.entity.movement_tracker.SectionedEntityMovementListener;
import com.abdelaziz.canary.common.entity.movement_tracker.SectionedInventoryEntityMovementTracker;
import com.abdelaziz.canary.common.entity.movement_tracker.SectionedItemEntityMovementTracker;
import com.abdelaziz.canary.common.hopper.BlockStateOnlyInventory;
import com.abdelaziz.canary.common.hopper.CanaryStackList;
import com.abdelaziz.canary.common.hopper.HopperCachingState;
import com.abdelaziz.canary.common.hopper.HopperHelper;
import com.abdelaziz.canary.common.hopper.InventoryHelper;
import com.abdelaziz.canary.common.hopper.UpdateReceiver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.loading.LoadingModList;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={HopperBlockEntity.class}, priority=950)
public abstract class HopperBlockEntityMixin
extends BlockEntity
implements Hopper,
UpdateReceiver,
CanaryInventory,
InventoryChangeListener,
SectionedEntityMovementListener {
    @Nullable
    private Container insertBlockInventory;
    @Nullable
    private Container extractBlockInventory;
    private AABB[] collectItemEntityBoxes;
    private long collectItemEntityAttemptTime;
    private long myModCountAtLastInsert;
    private long myModCountAtLastExtract;
    private long myModCountAtLastItemCollect;
    private HopperCachingState.BlockInventory insertionMode = HopperCachingState.BlockInventory.UNKNOWN;
    private HopperCachingState.BlockInventory extractionMode = HopperCachingState.BlockInventory.UNKNOWN;
    private SectionedInventoryEntityMovementTracker<Container> extractInventoryEntityTracker;
    @Nullable
    private CanaryInventory insertInventory;
    @Nullable
    private CanaryInventory extractInventory;
    @Nullable
    private CanaryStackList insertStackList;
    @Nullable
    private CanaryStackList extractStackList;
    private long insertStackListModCount;
    private long extractStackListModCount;
    private SectionedItemEntityMovementTracker<ItemEntity> collectItemEntityTracker;
    private AABB insertInventoryEntityBox;
    private long insertInventoryEntityFailedSearchTime;
    private AABB extractInventoryEntityBox;
    private long extractInventoryEntityFailedSearchTime;
    private boolean collectItemEntityTrackerWasEmpty;
    private boolean shouldCheckSleep;
    private SectionedInventoryEntityMovementTracker<Container> insertInventoryEntityTracker;
    @Shadow
    private long f_59303_;

    @Shadow
    @Nullable
    private static native Container m_155596_(Level var0, Hopper var1);

    @Shadow
    private static native boolean m_59380_(Container var0, ItemStack var1, int var2, Direction var3);

    @Shadow
    public abstract boolean m_59409_();

    @Shadow
    public abstract void m_59395_(int var1);

    @Shadow
    protected abstract boolean m_59407_();

    public HopperBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(cancellable=true, method={"ejectItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/HopperBlockEntity;)Z"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;isFullContainer(Lnet/minecraft/world/Container;Lnet/minecraft/core/Direction;)Z")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void canaryInsert(Level world, BlockPos pos, BlockState hopperState, HopperBlockEntity hopper, CallbackInfoReturnable<Boolean> cir, Container insertInventory, Direction direction) {
        boolean insertInventoryWasEmptyHopperNotDisabled;
        if (insertInventory == null || !(hopper instanceof HopperBlockEntity) || hopper instanceof WorldlyContainer) {
            return;
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)HopperBlockEntity.m_59390_((Level)world, (BlockPos)pos);
        CanaryStackList hopperStackList = InventoryHelper.getCanaryStackList(hopperBlockEntity);
        if (hopperBlockEntity.insertInventory == insertInventory && hopperStackList.getModCount() == hopperBlockEntity.myModCountAtLastInsert && hopperBlockEntity.insertStackList != null && hopperBlockEntity.insertStackList.getModCount() == hopperBlockEntity.insertStackListModCount) {
            cir.setReturnValue((Object)false);
            return;
        }
        boolean bl = insertInventoryWasEmptyHopperNotDisabled = insertInventory instanceof HopperBlockEntityMixin && !((HopperBlockEntityMixin)insertInventory).m_59409_() && hopperBlockEntity.insertStackList != null && hopperBlockEntity.insertStackList.getOccupiedSlots() == 0;
        if (hopperBlockEntity.insertInventory != insertInventory || hopperBlockEntity.insertStackList.getFullSlots() != hopperBlockEntity.insertStackList.size()) {
            Direction fromDirection = ((Direction)hopperState.m_61143_((Property)HopperBlock.f_54021_)).m_122424_();
            int size = hopperStackList.size();
            for (int i = 0; i < size; ++i) {
                boolean transferSuccess;
                ItemStack transferStack = (ItemStack)hopperStackList.get(i);
                if (transferStack.m_41619_() || !(transferSuccess = HopperHelper.tryMoveSingleItem(insertInventory, transferStack, fromDirection))) continue;
                if (insertInventoryWasEmptyHopperNotDisabled) {
                    HopperBlockEntityMixin receivingHopper = (HopperBlockEntityMixin)insertInventory;
                    int k = 8;
                    if (receivingHopper.f_59303_ >= hopperBlockEntity.f_59303_) {
                        k = 7;
                    }
                    receivingHopper.m_59395_(k);
                }
                insertInventory.m_6596_();
                cir.setReturnValue((Object)true);
                return;
            }
        }
        hopperBlockEntity.myModCountAtLastInsert = hopperStackList.getModCount();
        if (hopperBlockEntity.insertStackList != null) {
            hopperBlockEntity.insertStackListModCount = hopperBlockEntity.insertStackList.getModCount();
        }
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"suckInItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/Hopper;)Z"}, at={@At(value="FIELD", target="Lnet/minecraft/core/Direction;DOWN:Lnet/minecraft/core/Direction;", shift=At.Shift.AFTER)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void canaryExtract(Level world, Hopper to, CallbackInfoReturnable<Boolean> cir) {
        Container from = HopperBlockEntityMixin.m_155596_(world, to);
        if (!(to instanceof HopperBlockEntityMixin)) {
            return;
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)to;
        if (from != hopperBlockEntity.extractInventory || hopperBlockEntity.extractStackList == null) {
            return;
        }
        CanaryStackList hopperStackList = InventoryHelper.getCanaryStackList(hopperBlockEntity);
        CanaryStackList fromStackList = hopperBlockEntity.extractStackList;
        if (hopperStackList.getModCount() == hopperBlockEntity.myModCountAtLastExtract && fromStackList.getModCount() == hopperBlockEntity.extractStackListModCount) {
            ComparatorTracker comparatorTracker;
            if (!(from instanceof ComparatorTracker) || (comparatorTracker = (ComparatorTracker)from).hasAnyComparatorNearby()) {
                fromStackList.runComparatorUpdatePatternOnFailedExtract(fromStackList, from);
            }
            cir.setReturnValue((Object)false);
            return;
        }
        int[] availableSlots = from instanceof WorldlyContainer ? ((WorldlyContainer)from).m_7071_(Direction.DOWN) : null;
        int fromSize = availableSlots != null ? availableSlots.length : from.m_6643_();
        for (int i = 0; i < fromSize; ++i) {
            int fromSlot = availableSlots != null ? availableSlots[i] : i;
            ItemStack itemStack = (ItemStack)fromStackList.get(fromSlot);
            if (itemStack.m_41619_() || !HopperBlockEntityMixin.m_59380_(from, itemStack, fromSlot, Direction.DOWN)) continue;
            ItemStack takenItem = from.m_7407_(fromSlot, 1);
            assert (!takenItem.m_41619_());
            boolean transferSuccess = HopperHelper.tryMoveSingleItem((Container)to, takenItem, null);
            if (transferSuccess) {
                to.m_6596_();
                from.m_6596_();
                cir.setReturnValue((Object)true);
                return;
            }
            ItemStack restoredStack = (ItemStack)fromStackList.get(fromSlot);
            if (restoredStack.m_41619_()) {
                restoredStack = takenItem;
            } else {
                restoredStack.m_41769_(1);
            }
            from.m_6836_(fromSlot, restoredStack);
        }
        hopperBlockEntity.myModCountAtLastExtract = hopperStackList.getModCount();
        if (fromStackList != null) {
            hopperBlockEntity.extractStackListModCount = fromStackList.getModCount();
        }
        cir.setReturnValue((Object)false);
    }

    @Redirect(method={"tryMoveItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;inventoryFull()Z"))
    private static boolean canaryHopperIsFull(HopperBlockEntity hopperBlockEntity) {
        CanaryStackList canaryStackList = InventoryHelper.getCanaryStackList((HopperBlockEntityMixin)hopperBlockEntity);
        return canaryStackList.getFullSlots() == canaryStackList.size();
    }

    @Redirect(method={"tryMoveItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;isEmpty()Z"))
    private static boolean canaryHopperIsEmpty(HopperBlockEntity hopperBlockEntity) {
        CanaryStackList canaryStackList = InventoryHelper.getCanaryStackList((HopperBlockEntityMixin)hopperBlockEntity);
        return canaryStackList.getOccupiedSlots() == 0;
    }

    @Override
    public void invalidateCacheOnNeighborUpdate(boolean fromAbove) {
        if (fromAbove) {
            if (this.extractionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.extractionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
                this.invalidateBlockExtractionData();
            }
        } else if (this.insertionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.insertionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            this.invalidateBlockInsertionData();
        }
    }

    @Override
    public void invalidateCacheOnNeighborUpdate(Direction fromDirection) {
        boolean fromAbove;
        boolean bl = fromAbove = fromDirection == Direction.UP;
        if (fromAbove || this.m_58900_().m_61143_((Property)HopperBlock.f_54021_) == fromDirection) {
            this.invalidateCacheOnNeighborUpdate(fromAbove);
        }
    }

    @Redirect(method={"ejectItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/HopperBlockEntity;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;getAttachedContainer(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/Container;"))
    private static Container nullify(Level world, BlockPos pos, BlockState state) {
        return null;
    }

    @ModifyVariable(method={"ejectItems"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;getAttachedContainer(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/Container;"))
    private static Container getCanaryOutputInventory(Container inventory, Level world, BlockPos pos, BlockState hopperState, HopperBlockEntity hopper) {
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        return hopperBlockEntity.getInsertInventory(world, hopperState);
    }

    @Redirect(method={"suckInItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/Hopper;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;getItemsAtAndAbove(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/Hopper;)Ljava/util/List;"))
    private static List<ItemEntity> canaryGetInputItemEntities(Level world, Hopper hopper) {
        if (!(hopper instanceof HopperBlockEntityMixin)) {
            return HopperBlockEntity.m_155589_((Level)world, (Hopper)hopper);
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        if (hopperBlockEntity.collectItemEntityTracker == null) {
            hopperBlockEntity.initCollectItemEntityTracker();
        }
        long modCount = InventoryHelper.getCanaryStackList(hopperBlockEntity).getModCount();
        if ((hopperBlockEntity.collectItemEntityTrackerWasEmpty || hopperBlockEntity.myModCountAtLastItemCollect == modCount) && hopperBlockEntity.collectItemEntityTracker.isUnchangedSince(hopperBlockEntity.collectItemEntityAttemptTime)) {
            hopperBlockEntity.collectItemEntityAttemptTime = hopperBlockEntity.f_59303_;
            return Collections.emptyList();
        }
        hopperBlockEntity.myModCountAtLastItemCollect = modCount;
        hopperBlockEntity.shouldCheckSleep = false;
        List<ItemEntity> itemEntities = hopperBlockEntity.collectItemEntityTracker.getEntities(hopperBlockEntity.collectItemEntityBoxes);
        hopperBlockEntity.collectItemEntityAttemptTime = hopperBlockEntity.f_59303_;
        hopperBlockEntity.collectItemEntityTrackerWasEmpty = itemEntities.isEmpty();
        return itemEntities;
    }

    private void cacheInsertBlockInventory(Container insertInventory) {
        assert (!(insertInventory instanceof Entity));
        if (insertInventory instanceof CanaryInventory) {
            CanaryInventory optimizedInventory = (CanaryInventory)insertInventory;
            this.cacheInsertCanaryInventory(optimizedInventory);
        } else {
            this.insertInventory = null;
            this.insertStackList = null;
            this.insertStackListModCount = 0L;
        }
        if (insertInventory instanceof BlockEntity || insertInventory instanceof CompoundContainer) {
            this.insertBlockInventory = insertInventory;
            if (insertInventory instanceof InventoryChangeTracker) {
                this.insertionMode = HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY;
                ((InventoryChangeTracker)insertInventory).listenForMajorInventoryChanges(this);
            } else {
                this.insertionMode = HopperCachingState.BlockInventory.BLOCK_ENTITY;
            }
        } else if (insertInventory == null) {
            this.insertBlockInventory = null;
            this.insertionMode = HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY;
        } else {
            this.insertBlockInventory = insertInventory;
            this.insertionMode = insertInventory instanceof BlockStateOnlyInventory ? HopperCachingState.BlockInventory.BLOCK_STATE : HopperCachingState.BlockInventory.UNKNOWN;
        }
    }

    private void cacheInsertCanaryInventory(CanaryInventory optimizedInventory) {
        CanaryStackList insertInventoryStackList = InventoryHelper.getCanaryStackList(optimizedInventory);
        this.insertInventory = optimizedInventory;
        this.insertStackList = insertInventoryStackList;
        this.insertStackListModCount = insertInventoryStackList.getModCount() - 1L;
    }

    private void cacheExtractCanaryInventory(CanaryInventory optimizedInventory) {
        CanaryStackList extractInventoryStackList = InventoryHelper.getCanaryStackList(optimizedInventory);
        this.insertInventory = optimizedInventory;
        this.insertStackList = extractInventoryStackList;
        this.insertStackListModCount = extractInventoryStackList.getModCount() - 1L;
    }

    @Overwrite
    private static boolean m_59397_(Container inv, Direction side) {
        int[] availableSlots = inv instanceof WorldlyContainer ? ((WorldlyContainer)inv).m_7071_(side) : null;
        int fromSize = availableSlots != null ? availableSlots.length : inv.m_6643_();
        for (int i = 0; i < fromSize; ++i) {
            int slot;
            int n = slot = availableSlots != null ? availableSlots[i] : i;
            if (inv.m_8020_(slot).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private void cacheExtractBlockInventory(Container extractInventory) {
        assert (!(extractInventory instanceof Entity));
        if (extractInventory instanceof CanaryInventory) {
            CanaryInventory optimizedInventory = (CanaryInventory)extractInventory;
            this.cacheExtractCanaryInventory(optimizedInventory);
        } else {
            this.extractInventory = null;
            this.extractStackList = null;
            this.extractStackListModCount = 0L;
        }
        if (extractInventory instanceof BlockEntity || extractInventory instanceof CompoundContainer) {
            this.extractBlockInventory = extractInventory;
            if (extractInventory instanceof InventoryChangeTracker) {
                this.extractionMode = HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY;
                ((InventoryChangeTracker)extractInventory).listenForMajorInventoryChanges(this);
            } else {
                this.extractionMode = HopperCachingState.BlockInventory.BLOCK_ENTITY;
            }
        } else if (extractInventory == null) {
            this.extractBlockInventory = null;
            this.extractionMode = HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY;
        } else {
            this.extractBlockInventory = extractInventory;
            this.extractionMode = extractInventory instanceof BlockStateOnlyInventory ? HopperCachingState.BlockInventory.BLOCK_STATE : HopperCachingState.BlockInventory.UNKNOWN;
        }
    }

    public Container getExtractBlockInventory(Level world) {
        Container blockInventory = this.extractBlockInventory;
        switch (this.extractionMode) {
            case NO_BLOCK_INVENTORY: {
                return null;
            }
            case BLOCK_STATE: 
            case REMOVAL_TRACKING_BLOCK_ENTITY: {
                return blockInventory;
            }
            case BLOCK_ENTITY: {
                BlockEntity blockEntity = (BlockEntity)Objects.requireNonNull(blockInventory);
                BlockPos pos = blockEntity.m_58899_();
                BlockPos thisPos = this.m_58899_();
                if (blockEntity.m_58901_() || pos.m_123341_() != thisPos.m_123341_() || pos.m_123342_() != thisPos.m_123342_() + 1 || pos.m_123343_() != thisPos.m_123343_()) break;
                CanaryInventory optimizedInventory = this.extractInventory;
                if (optimizedInventory != null) {
                    CanaryStackList insertInventoryStackList = InventoryHelper.getCanaryStackList(optimizedInventory);
                    if (insertInventoryStackList == this.extractStackList) {
                        return optimizedInventory;
                    }
                    this.invalidateBlockExtractionData();
                    break;
                }
                return blockInventory;
            }
        }
        blockInventory = HopperHelper.vanillaGetBlockInventory(world, this.m_58899_().m_7494_());
        blockInventory = HopperHelper.replaceDoubleInventory(blockInventory);
        this.cacheExtractBlockInventory(blockInventory);
        return blockInventory;
    }

    public Container getInsertBlockInventory(Level world, BlockState hopperState) {
        Container blockInventory = this.insertBlockInventory;
        switch (this.insertionMode) {
            case NO_BLOCK_INVENTORY: {
                return null;
            }
            case BLOCK_STATE: 
            case REMOVAL_TRACKING_BLOCK_ENTITY: {
                return blockInventory;
            }
            case BLOCK_ENTITY: {
                BlockEntity blockEntity = (BlockEntity)Objects.requireNonNull(blockInventory);
                BlockPos pos = blockEntity.m_58899_();
                Direction direction = (Direction)hopperState.m_61143_((Property)HopperBlock.f_54021_);
                BlockPos transferPos = this.m_58899_().m_121945_(direction);
                if (blockEntity.m_58901_() || !pos.equals((Object)transferPos)) break;
                CanaryInventory optimizedInventory = this.insertInventory;
                if (optimizedInventory != null) {
                    CanaryStackList insertInventoryStackList = InventoryHelper.getCanaryStackList(optimizedInventory);
                    if (insertInventoryStackList == this.insertStackList) {
                        return optimizedInventory;
                    }
                    this.invalidateBlockInsertionData();
                    break;
                }
                return blockInventory;
            }
        }
        Direction direction = (Direction)hopperState.m_61143_((Property)HopperBlock.f_54021_);
        blockInventory = HopperHelper.vanillaGetBlockInventory(world, this.m_58899_().m_121945_(direction));
        blockInventory = HopperHelper.replaceDoubleInventory(blockInventory);
        this.cacheInsertBlockInventory(blockInventory);
        return blockInventory;
    }

    public Container getInsertInventory(Level world, BlockState hopperState) {
        Container blockInventory = this.getInsertBlockInventory(world, hopperState);
        if (blockInventory != null) {
            return blockInventory;
        }
        if (this.insertInventoryEntityTracker == null) {
            this.initInsertInventoryTracker(world, hopperState);
        }
        if (this.insertInventoryEntityTracker.isUnchangedSince(this.insertInventoryEntityFailedSearchTime)) {
            this.insertInventoryEntityFailedSearchTime = this.f_59303_;
            return null;
        }
        this.insertInventoryEntityFailedSearchTime = Long.MIN_VALUE;
        this.shouldCheckSleep = false;
        List<Container> inventoryEntities = this.insertInventoryEntityTracker.getEntities(this.insertInventoryEntityBox);
        if (inventoryEntities.isEmpty()) {
            this.insertInventoryEntityFailedSearchTime = this.f_59303_;
            return null;
        }
        Container inventory = inventoryEntities.get(world.f_46441_.m_188503_(inventoryEntities.size()));
        if (inventory instanceof CanaryInventory) {
            CanaryInventory optimizedInventory = (CanaryInventory)inventory;
            CanaryStackList insertInventoryStackList = InventoryHelper.getCanaryStackList(optimizedInventory);
            if (inventory != this.insertInventory || this.insertStackList != insertInventoryStackList) {
                this.cacheInsertCanaryInventory(optimizedInventory);
            }
        }
        return inventory;
    }

    @Redirect(method={"suckInItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/Hopper;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;getSourceContainer(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/Hopper;)Lnet/minecraft/world/Container;"))
    private static Container getExtractInventory(Level world, Hopper hopper) {
        if (!(hopper instanceof HopperBlockEntityMixin)) {
            return HopperBlockEntityMixin.m_155596_(world, hopper);
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        Container blockInventory = hopperBlockEntity.getExtractBlockInventory(world);
        if (blockInventory != null) {
            return blockInventory;
        }
        if (hopperBlockEntity.extractInventoryEntityTracker == null) {
            hopperBlockEntity.initExtractInventoryTracker(world);
        }
        if (hopperBlockEntity.extractInventoryEntityTracker.isUnchangedSince(hopperBlockEntity.extractInventoryEntityFailedSearchTime)) {
            hopperBlockEntity.extractInventoryEntityFailedSearchTime = hopperBlockEntity.f_59303_;
            return null;
        }
        hopperBlockEntity.extractInventoryEntityFailedSearchTime = Long.MIN_VALUE;
        hopperBlockEntity.shouldCheckSleep = false;
        List<Container> inventoryEntities = hopperBlockEntity.extractInventoryEntityTracker.getEntities(hopperBlockEntity.extractInventoryEntityBox);
        if (inventoryEntities.isEmpty()) {
            hopperBlockEntity.extractInventoryEntityFailedSearchTime = hopperBlockEntity.f_59303_;
            return null;
        }
        Container inventory = inventoryEntities.get(world.f_46441_.m_188503_(inventoryEntities.size()));
        if (inventory instanceof CanaryInventory) {
            CanaryInventory optimizedInventory = (CanaryInventory)inventory;
            CanaryStackList extractInventoryStackList = InventoryHelper.getCanaryStackList(optimizedInventory);
            if (inventory != hopperBlockEntity.extractInventory || hopperBlockEntity.extractStackList != extractInventoryStackList) {
                hopperBlockEntity.cacheExtractCanaryInventory(optimizedInventory);
            }
        }
        return inventory;
    }

    private void initCollectItemEntityTracker() {
        assert (this.f_58857_ instanceof ServerLevel);
        ArrayList<AABB> list = new ArrayList<AABB>();
        AABB encompassingBox = null;
        for (AABB box : HopperHelper.getHopperPickupVolumeBoxes(this)) {
            AABB offsetBox = box.m_82386_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_());
            list.add(offsetBox);
            encompassingBox = encompassingBox == null ? offsetBox : encompassingBox.m_82367_(offsetBox);
        }
        list.add(encompassingBox);
        this.collectItemEntityBoxes = list.toArray(new AABB[0]);
        this.collectItemEntityTracker = SectionedItemEntityMovementTracker.registerAt((ServerLevel)this.f_58857_, encompassingBox, ItemEntity.class);
        this.collectItemEntityAttemptTime = Long.MIN_VALUE;
    }

    private void initExtractInventoryTracker(Level world) {
        assert (world instanceof ServerLevel);
        BlockPos pos = this.m_58899_().m_121945_(Direction.UP);
        this.extractInventoryEntityBox = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1));
        this.extractInventoryEntityTracker = SectionedInventoryEntityMovementTracker.registerAt((ServerLevel)this.f_58857_, this.extractInventoryEntityBox, Container.class);
        this.extractInventoryEntityFailedSearchTime = Long.MIN_VALUE;
    }

    private void initInsertInventoryTracker(Level world, BlockState hopperState) {
        assert (world instanceof ServerLevel);
        Direction direction = (Direction)hopperState.m_61143_((Property)HopperBlock.f_54021_);
        BlockPos pos = this.m_58899_().m_121945_(direction);
        this.insertInventoryEntityBox = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1));
        this.insertInventoryEntityTracker = SectionedInventoryEntityMovementTracker.registerAt((ServerLevel)this.f_58857_, this.insertInventoryEntityBox, Container.class);
        this.insertInventoryEntityFailedSearchTime = Long.MIN_VALUE;
    }

    @Intrinsic
    public void m_155250_(BlockState state) {
        super.m_155250_(state);
    }

    @Inject(method={"setBlockState(Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="HEAD")})
    private void invalidateOnSetCachedState(BlockState state, CallbackInfo ci) {
        if (LoadingModList.get().getModFileById("quark") == null && this.f_58857_ != null && !this.f_58857_.m_5776_() && state.m_61143_((Property)HopperBlock.f_54021_) != this.m_58900_().m_61143_((Property)HopperBlock.f_54021_)) {
            this.invalidateCachedData();
        }
    }

    private void invalidateCachedData() {
        this.shouldCheckSleep = false;
        this.invalidateInsertionData();
        this.invalidateExtractionData();
    }

    private void invalidateInsertionData() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.insertInventoryEntityTracker != null) {
                this.insertInventoryEntityTracker.unRegister(serverWorld);
                this.insertInventoryEntityTracker = null;
                this.insertInventoryEntityBox = null;
                this.insertInventoryEntityFailedSearchTime = 0L;
            }
        }
        if (this.insertionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
            assert (this.insertBlockInventory != null);
            ((InventoryChangeTracker)this.insertBlockInventory).stopListenForMajorInventoryChanges(this);
        }
        this.invalidateBlockInsertionData();
    }

    private void invalidateBlockInsertionData() {
        this.insertionMode = HopperCachingState.BlockInventory.UNKNOWN;
        this.insertBlockInventory = null;
        this.insertInventory = null;
        this.insertStackList = null;
        this.insertStackListModCount = 0L;
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
    }

    private void invalidateExtractionData() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.extractInventoryEntityTracker != null) {
                this.extractInventoryEntityTracker.unRegister(serverWorld);
                this.extractInventoryEntityTracker = null;
                this.extractInventoryEntityBox = null;
                this.extractInventoryEntityFailedSearchTime = 0L;
            }
            if (this.collectItemEntityTracker != null) {
                this.collectItemEntityTracker.unRegister(serverWorld);
                this.collectItemEntityTracker = null;
                this.collectItemEntityBoxes = null;
                this.collectItemEntityTrackerWasEmpty = false;
            }
        }
        if (this.extractionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
            assert (this.extractBlockInventory != null);
            ((InventoryChangeTracker)this.extractBlockInventory).stopListenForMajorInventoryChanges(this);
        }
        this.invalidateBlockExtractionData();
    }

    private void invalidateBlockExtractionData() {
        if (this.extractionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
            assert (this.extractBlockInventory != null);
            ((InventoryChangeTracker)this.extractBlockInventory).stopListenForMajorInventoryChanges(this);
        }
        this.extractionMode = HopperCachingState.BlockInventory.UNKNOWN;
        this.extractBlockInventory = null;
        this.extractInventory = null;
        this.extractStackList = null;
        this.extractStackListModCount = 0L;
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
    }

    @Inject(method={"pushItemsTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;tryMoveItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z", shift=At.Shift.AFTER)})
    private static void checkSleepingConditions(Level world, BlockPos pos, BlockState state, HopperBlockEntity blockEntity, CallbackInfo ci) {
        ((HopperBlockEntityMixin)blockEntity).checkSleepingConditions();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkSleepingConditions() {
        Container blockInventory;
        if (this.m_59407_()) {
            return;
        }
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (!(hopperBlockEntityMixin instanceof SleepingBlockEntity)) return;
        SleepingBlockEntity thisSleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
        if (thisSleepingBlockEntity.isSleeping()) {
            return;
        }
        if (!this.shouldCheckSleep) {
            this.shouldCheckSleep = true;
            return;
        }
        HopperBlockEntityMixin hopperBlockEntityMixin2 = this;
        if (!(hopperBlockEntityMixin2 instanceof InventoryChangeTracker)) return;
        InventoryChangeTracker thisTracker = (InventoryChangeTracker)((Object)hopperBlockEntityMixin2);
        boolean listenToExtractTracker = false;
        boolean listenToInsertTracker = false;
        boolean listenToExtractEntities = false;
        boolean listenToInsertEntities = false;
        CanaryStackList thisStackList = InventoryHelper.getCanaryStackList(this);
        if (this.extractionMode != HopperCachingState.BlockInventory.BLOCK_STATE && thisStackList.getFullSlots() != thisStackList.size()) {
            if (this.extractionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
                ComparatorTracker comparatorTracker;
                blockInventory = this.extractBlockInventory;
                if (this.extractStackList == null || !(blockInventory instanceof InventoryChangeTracker)) return;
                if (this.extractStackList.maybeSendsComparatorUpdatesOnFailedExtract() && (!(blockInventory instanceof ComparatorTracker) || (comparatorTracker = (ComparatorTracker)blockInventory).hasAnyComparatorNearby())) return;
                listenToExtractTracker = true;
            } else {
                if (this.extractionMode != HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) return;
                listenToExtractEntities = true;
            }
        }
        if (this.insertionMode != HopperCachingState.BlockInventory.BLOCK_STATE && 0 < thisStackList.getOccupiedSlots()) {
            if (this.insertionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
                blockInventory = this.insertBlockInventory;
                if (this.insertStackList == null || !(blockInventory instanceof InventoryChangeTracker)) return;
                listenToInsertTracker = true;
            } else {
                if (this.insertionMode != HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) return;
                listenToInsertEntities = true;
            }
        }
        if (listenToExtractTracker) {
            ((InventoryChangeTracker)this.extractBlockInventory).listenForContentChangesOnce(this.extractStackList, this);
        }
        if (listenToInsertTracker) {
            ((InventoryChangeTracker)this.insertBlockInventory).listenForContentChangesOnce(this.insertStackList, this);
        }
        if (listenToInsertEntities) {
            if (this.insertInventoryEntityTracker == null) {
                this.initInsertInventoryTracker(this.f_58857_, this.m_58900_());
            }
            this.insertInventoryEntityTracker.listenToEntityMovementOnce(this);
        }
        if (listenToExtractEntities) {
            if (this.extractInventoryEntityTracker == null) {
                this.initExtractInventoryTracker(this.f_58857_);
            }
            this.extractInventoryEntityTracker.listenToEntityMovementOnce(this);
            if (this.collectItemEntityTracker == null) {
                this.initCollectItemEntityTracker();
            }
            this.collectItemEntityTracker.listenToEntityMovementOnce(this);
        }
        thisTracker.listenForContentChangesOnce(thisStackList, this);
        thisSleepingBlockEntity.startSleeping();
    }

    @Override
    public void handleInventoryContentModified(Container inventory) {
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
    }

    @Override
    public void handleInventoryRemoved(Container inventory) {
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
        if (inventory == this.insertBlockInventory) {
            this.invalidateBlockInsertionData();
        }
        if (inventory == this.extractBlockInventory) {
            this.invalidateBlockExtractionData();
        }
        if (inventory == this) {
            this.invalidateCachedData();
        }
    }

    @Override
    public boolean handleComparatorAdded(Container inventory) {
        HopperBlockEntityMixin hopperBlockEntityMixin;
        if (inventory == this.extractBlockInventory && (hopperBlockEntityMixin = this) instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
            return true;
        }
        return false;
    }

    @Override
    public void handleEntityMovement(Class<?> category) {
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
    }
}

