/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import untamedwilds.config.ConfigFeatureControl;
import untamedwilds.config.ConfigMobControl;

public record UntamedWildsBiomeModifier(TagKey<Biome> dimension, List<HolderSet<Biome>> biomes, List<HolderSet<Biome>> blacklist, GenerationStep.Decoration decoration, Holder<PlacedFeature> feature, String configOption) implements BiomeModifier
{
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"untamedwilds");
    public static final RegistryObject<Codec<UntamedWildsBiomeModifier>> BIOME_MODIFIER_SERIALIZER = BIOME_MODIFIER_SERIALIZERS.register("biome_modifier_serializer", () -> RecordCodecBuilder.create(builder -> builder.group((App)TagKey.m_203877_((ResourceKey)Registry.f_122885_).fieldOf("dimension").forGetter(UntamedWildsBiomeModifier::dimension), (App)Biome.f_47432_.listOf().fieldOf("biomes").forGetter(UntamedWildsBiomeModifier::biomes), (App)Biome.f_47432_.listOf().fieldOf("blacklist").forGetter(UntamedWildsBiomeModifier::blacklist), (App)GenerationStep.Decoration.f_224188_.fieldOf("decoration").forGetter(UntamedWildsBiomeModifier::decoration), (App)PlacedFeature.f_191773_.fieldOf("feature").forGetter(UntamedWildsBiomeModifier::feature), (App)PrimitiveCodec.STRING.fieldOf("configOption").forGetter(UntamedWildsBiomeModifier::configOption)).apply((Applicative)builder, UntamedWildsBiomeModifier::new)));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        ForgeConfigSpec.BooleanValue option = ConfigFeatureControl.options.get(this.configOption);
        if (this.configOption.isEmpty() || option != null && ((Boolean)option.get()).booleanValue() || option == null && (Integer)ConfigFeatureControl.probUnderground.get() != 0 && ((Boolean)ConfigMobControl.masterSpawner.get()).booleanValue()) {
            if (phase != BiomeModifier.Phase.ADD) {
                return;
            }
            if (!biome.m_203656_(this.dimension)) {
                return;
            }
            if (this.blacklist.stream().anyMatch(set -> set.m_203333_(biome))) {
                return;
            }
            if (this.biomes.isEmpty() || this.biomes.stream().anyMatch(set -> set.m_203333_(biome))) {
                builder.getGenerationSettings().m_204201_(this.decoration, this.feature);
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)BIOME_MODIFIER_SERIALIZER.get();
    }
}

