/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.item;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import untamedwilds.UntamedWilds;
import untamedwilds.util.EntityUtils;
import untamedwilds.util.ModCreativeModeTab;

public class MobSpawnItem
extends Item {
    private final Supplier<? extends EntityType<?>> entity;

    public MobSpawnItem(Supplier<? extends EntityType<?>> typeIn, Item.Properties properties) {
        super(properties);
        this.entity = typeIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        EntityUtils.buildTooltipData(stack, tooltip, this.entity.get(), EntityUtils.getVariantName(this.entity.get(), this.getSpecies(stack)));
    }

    public Component m_7626_(ItemStack stack) {
        return MutableComponent.m_237204_((ComponentContents)new TranslatableContents("entity.untamedwilds." + EntityUtils.getRegistryName(this.entity.get()) + "_" + EntityUtils.getVariantName(this.entity.get(), this.getSpecies(stack))));
    }

    public InteractionResult m_6225_(UseOnContext useContext) {
        Level worldIn = useContext.m_43725_();
        if (!(worldIn instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = useContext.m_43722_();
        BlockPos pos = useContext.m_8083_();
        Direction facing = useContext.m_43719_();
        BlockState blockState = worldIn.m_8055_(pos);
        BlockPos spawnPos = blockState.m_60812_((BlockGetter)worldIn, pos).m_83281_() ? pos : pos.m_121945_(facing);
        EntityType<?> entity = EntityUtils.getEntityTypeFromTag(itemStack.m_41783_(), this.entity.get());
        boolean doVerticalOffset = !Objects.equals(pos, spawnPos) && facing == Direction.UP;
        EntityUtils.createMobFromItem((ServerLevel)worldIn, itemStack, entity, this.getSpecies(itemStack), spawnPos, useContext.m_43723_(), doVerticalOffset);
        if (useContext.m_43723_() != null && !useContext.m_43723_().m_7500_()) {
            itemStack.m_41774_(1);
        }
        return InteractionResult.CONSUME;
    }

    private int getSpecies(ItemStack itemIn) {
        if (itemIn.m_41783_() != null && itemIn.m_41783_().m_128441_("CustomModelData")) {
            return itemIn.m_41783_().m_128451_("CustomModelData");
        }
        UntamedWilds.LOGGER.error("No variant found in this itemstack NBT data");
        return 0;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (group == ModCreativeModeTab.untamedwilds_items) {
            for (int i = 0; i < EntityUtils.getNumberOfSpecies(this.entity.get()); ++i) {
                CompoundTag baseTag = new CompoundTag();
                ItemStack item = new ItemStack((ItemLike)this);
                baseTag.m_128405_("variant", i);
                baseTag.m_128405_("CustomModelData", i);
                item.m_41751_(baseTag);
                items.add((Object)item);
            }
        }
    }
}

