/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.reptile;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import oshi.util.tuples.Pair;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAmphibious;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INestingMob;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.LayEggsOnNestGoal;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.control.look.SmartSwimmerLookControl;
import untamedwilds.entity.ai.control.movement.SmartSwimmingMoveControl;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModTags;
import untamedwilds.util.EntityUtils;

public class EntityMonitor
extends ComplexMobAmphibious
implements ISpecies,
INeedsPostUpdate,
INewSkins,
INestingMob {
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(EntityMonitor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static Animation IDLE_TONGUE;
    public static Animation ATTACK_THRASH;
    public int swimProgress;
    public float offset;
    public Pair<Float, Float> head_movement;
    private float neck_val = 0.0f;
    private float head_val = 0.0f;

    public EntityMonitor(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new SmartSwimmingMoveControl((Mob)this, 40, 5, 0.25f, 0.3f, true);
        this.f_21365_ = new SmartSwimmerLookControl(this, 20);
        IDLE_TONGUE = Animation.create((int)20);
        ATTACK_THRASH = Animation.create((int)30);
        this.head_movement = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        this.ticksToSit = 20;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22282_, 0.1).m_22268_(Attributes.f_22279_, 0.7).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22278_, 0.2);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new SmartMeleeAttackGoal((PathfinderMob)this, 1.4, false));
        this.f_21345_.m_25352_(2, (Goal)new SmartMateGoal(this, 0.7));
        this.f_21345_.m_25352_(2, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, (float)this.m_21133_(Attributes.f_22277_), 1.0, 1.1, input -> EntityMonitor.getEcoLevel(input) > EntityMonitor.getEcoLevel((LivingEntity)this)));
        this.f_21345_.m_25352_(3, (Goal)new SmartWanderGoal(this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new LayEggsOnNestGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, new HuntMobTarget<LivingEntity>(this, LivingEntity.class, true, false, input -> EntityMonitor.getEcoLevel(input) < EntityMonitor.getEcoLevel((LivingEntity)this)));
    }

    public float m_5610_(BlockPos p_149140_, LevelReader p_149141_) {
        return 0.0f;
    }

    @Override
    public boolean wantsToBeOnLand() {
        return true;
    }

    @Override
    public boolean wantsToBeInWater() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.m_20069_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.003, 0.0));
                if (!this.isNotMoving() && this.f_19796_.m_188503_(5) == 0 && this.m_20184_().m_165924_() > 0.08) {
                    Vec3 testpos = this.m_20182_().m_82520_(Math.cos(Math.toRadians(this.m_146908_() + 90.0f)) * -0.8, 0.0, Math.sin(Math.toRadians(this.m_146908_() + 90.0f)) * -0.8);
                    BlockPos testblockpos = new BlockPos(testpos);
                    if (this.f_19853_.m_8055_(new BlockPos((Vec3i)testblockpos.m_7495_())).m_204336_(BlockTags.f_144283_)) {
                        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, this.f_19853_.m_8055_(testblockpos.m_7495_())), testpos.f_82479_, testpos.f_82480_ + 0.2, testpos.f_82481_, 2, (double)this.f_19796_.m_188501_() * 0.2, (double)this.f_19796_.m_188501_() * 0.2, (double)this.f_19796_.m_188501_() * 0.2, 0.0);
                    } else {
                        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123768_, testpos.f_82479_, testpos.f_82480_ + 0.2, testpos.f_82481_, 2, (double)this.f_19796_.m_188501_() * 0.2, (double)this.f_19796_.m_188501_() * 0.2, (double)this.f_19796_.m_188501_() * 0.2, 0.0);
                    }
                }
            }
            if (this.f_19853_.m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
            if (this.getAnimation() == NO_ANIMATION && this.m_5448_() == null && !this.m_5803_()) {
                int i = this.f_19796_.m_188503_(3000);
                if (i <= 10 && !this.m_20069_()) {
                    this.m_21573_().m_26573_();
                    this.setSitting(true);
                } else if ((i == 11 || this.m_20069_()) && this.isSitting()) {
                    this.setSitting(false);
                } else if (i > 2900) {
                    if (this.m_20160_() && this.m_146895_() != null) {
                        this.setAnimation(ATTACK_THRASH);
                        this.m_7327_(this.m_146895_());
                    } else {
                        this.setAnimation(IDLE_TONGUE);
                    }
                }
            }
        } else {
            if ((double)Math.abs(this.m_146908_() - this.f_19859_) > 0.005) {
                this.offset = Mth.m_14189_((float)0.05f, (float)this.offset, (float)(this.m_146908_() - this.f_19859_));
            }
            if (this.m_20069_() && !this.isNotMoving()) {
                if (this.swimProgress < 20) {
                    ++this.swimProgress;
                }
            } else if ((!this.m_20069_() || this.isNotMoving()) && this.swimProgress > 0) {
                --this.swimProgress;
            }
            if (this.f_19797_ % 120 < 11) {
                if (this.f_19797_ % 120 == 1) {
                    this.neck_val = (float)((double)0.8f - this.f_19796_.m_188500_() * (double)1.6f);
                    this.head_val = (float)((double)0.4f - this.f_19796_.m_188500_() * (double)0.8f);
                }
                this.head_movement = new Pair((Object)Float.valueOf(Mth.m_14179_((float)0.1f, (float)((Float)this.head_movement.getA()).floatValue(), (float)this.neck_val)), (Object)Float.valueOf(Mth.m_14179_((float)0.1f, (float)((Float)this.head_movement.getB()).floatValue(), (float)this.head_val)));
            }
        }
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.m_5803_() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.f_19853_.m_45976_(EntityMonitor.class, this.m_20191_().m_82377_(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            return list.size() >= 1;
        }
        return false;
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.m_6162_()) {
            this.setAnimation(ATTACK_THRASH);
            this.setAnimationTick(0);
            if (entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 40, 0));
                if (!(this.m_20160_() || !(entityIn.m_20205_() * entityIn.m_20206_() < 0.4f) || entityIn instanceof TamableAnimal && ((TamableAnimal)entityIn).m_21824_())) {
                    entityIn.m_20329_((Entity)this);
                    ((LivingEntity)entityIn).m_21153_(10.0f);
                }
            }
        }
        return flag;
    }

    public double m_6048_() {
        return 0.0;
    }

    public void m_7332_(Entity p_20312_) {
        this.positionPreyInJaw(p_20312_, Entity::m_6034_);
    }

    private void positionPreyInJaw(Entity p_19957_, Entity.MoveFunction p_19958_) {
        if (this.m_20363_(p_19957_)) {
            int rev = this.getAnimationTick() % 12 >= 6 ? -1 : 1;
            int factor = rev * (this.getAnimationTick() % 12);
            double d0 = this.m_20186_() + this.m_6048_() + p_19957_.m_6049_();
            p_19958_.m_20372_(p_19957_, this.m_20185_() + Math.cos(Math.toRadians(this.m_146908_() + 90.0f + (float)(factor * 4))) * 1.0, d0, this.m_20189_() + Math.sin(Math.toRadians(this.m_146908_() + 90.0f + (float)(factor * 4))) * 1.0);
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemstack.m_41619_() && this.m_6084_() && hand.equals((Object)InteractionHand.MAIN_HAND)) {
            this.setAnimation(ATTACK_THRASH);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntityUtils.dropEggs(this, "egg_monitor", this.getOffspring());
        return null;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        SoundEvent soundevent = this.m_6162_() ? SoundEvents.f_12488_ : SoundEvents.f_12487_;
        this.m_5496_(soundevent, 0.15f, 1.0f);
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        this.performRetaliation(damageSource, this.m_21223_(), amount, true);
        return super.m_6469_(damageSource, amount);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, IDLE_TONGUE, ATTACK_THRASH};
    }

    @Override
    public void updateAttributes() {
        this.m_21051_(Attributes.f_22281_).m_22100_((double)EntityMonitor.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.m_21051_(Attributes.f_22276_).m_22100_((double)EntityMonitor.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.m_21153_(this.m_21233_());
    }

    @Override
    public boolean wantsToLayEggs() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    @Override
    public void setEggStatus(boolean status) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)status);
    }

    @Override
    public Block getNestType() {
        return (Block)ModBlock.NEST_REPTILE.get();
    }

    @Override
    public boolean isValidNestBlock(BlockPos pos) {
        return this.f_19853_.m_46859_(pos) && this.f_19853_.m_8055_(pos.m_7495_()).m_204336_(ModTags.ModBlockTags.VALID_REPTILE_NEST) && this.getNestType().m_49966_().m_60710_((LevelReader)this.f_19853_, pos);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("has_egg", this.wantsToLayEggs());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setEggStatus(compound.m_128471_("has_egg"));
    }
}

