/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.reptile;

import com.mojang.math.Vector3d;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import untamedwilds.entity.ComplexMobAmphibious;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INestingMob;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.AmphibiousRandomSwimGoal;
import untamedwilds.entity.ai.AmphibiousTransition;
import untamedwilds.entity.ai.LayEggsOnNestGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.control.movement.SmartSwimmingMoveControl;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModEntity;
import untamedwilds.init.ModItems;
import untamedwilds.init.ModTags;
import untamedwilds.util.EntityUtils;

public class EntityAnaconda
extends ComplexMobAmphibious
implements ISpecies,
INeedsPostUpdate,
INewSkins,
INestingMob {
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(EntityAnaconda.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final int length;
    public final EntityAnacondaPart[] anacondaParts;
    public final float[] buffer = new float[3];
    public int ringBufferIndex = -1;
    public final double[][] ringBuffer = new double[64][3];

    public EntityAnaconda(EntityType<? extends ComplexMobTerrestrial> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SmartSwimmingMoveControl((Mob)this, 20, 5, 0.3f, 0.4f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.ticksToSit = 40;
        this.length = this.getMultiparts();
        this.anacondaParts = new EntityAnacondaPart[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.anacondaParts[i] = new EntityAnacondaPart(this, this.m_20205_(), this.m_20206_());
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
    }

    private void setPartPosition(EntityAnacondaPart part, double offsetX, double offsetY, double offsetZ) {
        part.m_6034_(this.m_20185_() + offsetX * (double)part.scale, this.m_20186_() + offsetY * (double)part.scale, this.m_20189_() + offsetZ * (double)part.scale);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.anacondaParts;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 0.6).m_22268_(Attributes.f_22279_, 0.6).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22278_, 0.8).m_22268_(Attributes.f_22284_, 4.0);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.3, false));
        this.f_21345_.m_25352_(2, (Goal)new SmartMateGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new AmphibiousTransition(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LayEggsOnNestGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new AmphibiousRandomSwimGoal(this, 0.7, 400));
        this.f_21345_.m_25352_(4, (Goal)new SmartWanderGoal(this, 0.7, false){

            @Override
            public boolean m_8036_() {
                if (this.creature.huntingCooldown != 0) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, new HuntMobTarget<LivingEntity>(this, LivingEntity.class, true, 30, false, input -> EntityAnaconda.getEcoLevel(input) < EntityAnaconda.getEcoLevel((LivingEntity)this)));
    }

    @Override
    public void m_8107_() {
        block15: {
            int i;
            super.m_8107_();
            if (!this.f_19853_.f_46443_) {
                if (this.f_19797_ % 1000 == 0 && this.f_19796_.m_188503_(40) == 0) {
                    this.m_5552_(new ItemStack((ItemLike)ModItems.MATERIAL_SNAKE_SKIN.get()), 0.2f);
                }
                if (this.f_19853_.m_46467_() % 4000L == 0L) {
                    this.m_5634_(1.0f);
                }
                if (this.getAnimation() == NO_ANIMATION && this.m_5448_() == null && !this.m_5803_()) {
                    i = this.f_19796_.m_188503_(3000);
                    if (i <= 10 && !this.m_20069_() && this.isNotMoving() && this.canMove()) {
                        this.m_21573_().m_26573_();
                        this.setSitting(true);
                    }
                    if ((i == 11 || this.m_20069_() || this.isActive()) && this.isSitting()) {
                        this.setSitting(false);
                    }
                }
                if (this.m_20069_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.006, 0.0));
                }
                this.setAngry(this.m_5448_() != null);
            }
            if (this.m_21525_() || this.m_6162_()) break block15;
            if (this.canMove()) {
                if (this.ringBufferIndex < 0) {
                    for (i = 0; i < this.ringBuffer.length; ++i) {
                        this.ringBuffer[i][0] = this.m_146908_();
                        this.ringBuffer[i][1] = this.m_20186_();
                    }
                }
                ++this.ringBufferIndex;
                if (this.ringBufferIndex == this.ringBuffer.length) {
                    this.ringBufferIndex = 0;
                }
                this.ringBuffer[this.ringBufferIndex][0] = this.m_146908_();
                this.ringBuffer[this.ringBufferIndex][1] = this.m_20186_();
                Vector3d[] avector3d = new Vector3d[this.anacondaParts.length];
                for (int j = 0; j < this.anacondaParts.length; ++j) {
                    this.anacondaParts[j].collideWithNearbyEntities();
                    avector3d[j] = new Vector3d(this.anacondaParts[j].m_20185_(), this.anacondaParts[j].m_20186_(), this.anacondaParts[j].m_20189_());
                }
                float f15 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f16 = Mth.m_14089_((float)f15);
                float yaw = this.m_146908_() * ((float)Math.PI / 180);
                float pitch = this.m_146909_() * ((float)Math.PI / 180);
                float f3 = Mth.m_14031_((float)yaw) * (1.0f - Math.abs(this.m_146909_() / 90.0f));
                float f18 = Mth.m_14089_((float)yaw) * (1.0f - Math.abs(this.m_146909_() / 90.0f));
                double[] adouble = this.getMovementOffsets(5, 1.0f);
                for (int k = 0; k < this.getMultiparts(); ++k) {
                    EntityAnacondaPart anaconda_part = this.anacondaParts[k];
                    double[] adouble1 = this.getMovementOffsets(5 + k * 2, 1.0f);
                    float f7 = yaw + (float)Mth.m_14175_((double)(adouble1[0] - adouble[0])) * ((float)Math.PI / 180);
                    float f20 = Mth.m_14031_((float)f7) * (1.0f - Math.abs(this.m_146909_() / 90.0f));
                    float f21 = Mth.m_14089_((float)f7) * (1.0f - Math.abs(this.m_146909_() / 90.0f));
                    float f23 = k == 0 ? (float)(k + 1) : (float)((k + 1) * -1);
                    float value = pitch * (float)k;
                    this.setPartPosition(anaconda_part, -(f3 * 0.5f + f20 * f23) * f16, value, (f18 * 0.5f + f21 * f23) * f16);
                    this.anacondaParts[k].f_19854_ = avector3d[k].f_86214_;
                    this.anacondaParts[k].f_19855_ = avector3d[k].f_86215_;
                    this.anacondaParts[k].f_19856_ = avector3d[k].f_86216_;
                    this.anacondaParts[k].f_19790_ = avector3d[k].f_86214_;
                    this.anacondaParts[k].f_19791_ = avector3d[k].f_86215_;
                    this.anacondaParts[k].f_19792_ = avector3d[k].f_86216_;
                }
            } else {
                for (int k = 0; k < this.getMultiparts(); ++k) {
                    EntityAnacondaPart anaconda_part = this.anacondaParts[k];
                    this.setPartPosition(anaconda_part, 0.0, 0.0, 0.0);
                    this.anacondaParts[k].f_19854_ = this.m_20185_();
                    this.anacondaParts[k].f_19855_ = this.m_20186_();
                    this.anacondaParts[k].f_19856_ = this.m_20189_();
                    this.anacondaParts[k].f_19790_ = this.m_20185_();
                    this.anacondaParts[k].f_19791_ = this.m_20186_();
                    this.anacondaParts[k].f_19792_ = this.m_20189_();
                }
            }
        }
    }

    public double[] getMovementOffsets(int p_70974_1_, float partialTicks) {
        if (this.m_21224_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - p_70974_1_ & 0x3F;
        int j = this.ringBufferIndex - p_70974_1_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = this.ringBuffer[j][0] - d0;
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = Mth.m_14139_((double)partialTicks, (double)this.ringBuffer[i][2], (double)this.ringBuffer[j][2]);
        return adouble;
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.m_5803_() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.f_19853_.m_45976_(EntityAnaconda.class, this.m_20191_().m_82377_(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            return list.size() >= 1;
        }
        return false;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    @Override
    protected SoundEvent m_7515_() {
        if (this.isAngry()) {
            return super.m_7515_();
        }
        return null;
    }

    @Nullable
    public EntityAnaconda getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        if (!this.isEggLayer()) {
            return this.create_offspring(new EntityAnaconda((EntityType<? extends ComplexMobTerrestrial>)((EntityType)ModEntity.ANACONDA.get()), this.f_19853_));
        }
        return null;
    }

    public boolean m_7327_(Entity entityIn) {
        float f = (float)this.m_21051_(Attributes.f_22281_).m_22135_();
        boolean flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), f);
        if (flag) {
            if (this.huntingCooldown == 0 && entityIn instanceof LivingEntity && !(entityIn instanceof Player) && entityIn.m_20205_() * entityIn.m_20206_() < 1.2f && entityIn instanceof TamableAnimal && !((TamableAnimal)entityIn).m_21824_()) {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11695_, SoundSource.BLOCKS, 1.0f, 1.0f);
                EntityUtils.spawnParticlesOnEntity(this.f_19853_, (LivingEntity)entityIn, ParticleTypes.f_123759_, 6, 2);
                this.m_20256_(new Vec3(entityIn.m_20185_() - this.m_20185_(), entityIn.m_20186_() - this.m_20186_(), entityIn.m_20189_() - this.m_20189_()).m_82490_((double)0.15f));
                this.huntingCooldown = 144000;
                entityIn.m_142687_(Entity.RemovalReason.KILLED);
            }
            return true;
        }
        return false;
    }

    public boolean attackEntityPartFrom(EntityAnacondaPart anaconda_part, DamageSource source, float amount) {
        return this.m_6469_(source, amount);
    }

    @Override
    public boolean isEggLayer() {
        return EntityAnaconda.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "eggLayer") == 1;
    }

    public int getMultiparts() {
        return 3;
    }

    @Override
    public boolean wantsToLayEggs() {
        return this.isEggLayer() && (Boolean)this.f_19804_.m_135370_(HAS_EGG) != false;
    }

    @Override
    public void setEggStatus(boolean status) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)status);
    }

    @Override
    public Block getNestType() {
        return (Block)ModBlock.NEST_REPTILE.get();
    }

    @Override
    public boolean isValidNestBlock(BlockPos pos) {
        return this.f_19853_.m_46859_(pos) && this.f_19853_.m_8055_(pos.m_7495_()).m_204336_(ModTags.ModBlockTags.VALID_REPTILE_NEST) && this.getNestType().m_49966_().m_60710_((LevelReader)this.f_19853_, pos);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("has_egg", this.wantsToLayEggs());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setEggStatus(compound.m_128471_("has_egg"));
    }

    @Override
    public void updateAttributes() {
        this.m_21051_(Attributes.f_22281_).m_22100_((double)EntityAnaconda.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.m_21051_(Attributes.f_22276_).m_22100_((double)EntityAnaconda.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.m_21153_(this.m_21233_());
    }

    public static class EntityAnacondaPart
    extends PartEntity<EntityAnaconda> {
        private final EntityDimensions size;
        public float scale = 1.0f;

        public EntityAnacondaPart(EntityAnaconda parent, float sizeX, float sizeY) {
            super((Entity)parent);
            this.size = EntityDimensions.m_20395_((float)sizeX, (float)sizeY);
            this.m_6210_();
        }

        protected void collideWithNearbyEntities() {
            List entities = this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82377_((double)0.2f, 0.0, (double)0.2f));
            Entity parent = this.getParent();
            if (parent != null) {
                entities.stream().filter(entity -> entity != parent && (!(entity instanceof EntityAnacondaPart) || ((EntityAnacondaPart)((Object)entity)).getParent() != parent) && entity.m_6094_()).forEach(entity -> entity.m_7334_(parent));
            }
        }

        public InteractionResult mobInteract(Player player, InteractionHand hand) {
            return this.getParent() == null ? InteractionResult.PASS : ((EntityAnaconda)this.getParent()).m_6071_(player, hand);
        }

        public void m_7334_(Entity entityIn) {
            entityIn.m_7334_((Entity)this);
        }

        public boolean m_5829_() {
            return true;
        }

        public boolean m_6469_(DamageSource source, float amount) {
            return !this.m_6673_(source) && ((EntityAnaconda)this.getParent()).attackEntityPartFrom(this, source, amount);
        }

        protected void m_8097_() {
        }

        protected void m_7378_(CompoundTag compound) {
        }

        protected void m_7380_(CompoundTag compound) {
        }

        public boolean m_7306_(Entity entityIn) {
            return this == entityIn || this.getParent() == entityIn;
        }

        public Packet<?> m_5654_() {
            throw new UnsupportedOperationException();
        }

        public EntityDimensions getSize(Pose poseIn) {
            return this.size.m_20388_(this.scale);
        }
    }
}

