/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.arthropod;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.unique.ButterflyFlutterGoal;
import untamedwilds.entity.ai.unique.ButterflyFlutterTowardsGoal;
import untamedwilds.util.EntityUtils;

public class EntityButterfly
extends ComplexMob
implements FlyingAnimal,
ISpecies,
INewSkins,
INeedsPostUpdate {
    private static final EntityDataAccessor<Boolean> DIMORPHISM = SynchedEntityData.m_135353_(EntityButterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RESTING = SynchedEntityData.m_135353_(EntityButterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int flight_counter = 0;

    public EntityButterfly(EntityType<? extends EntityButterfly> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_19804_.m_135372_(DIMORPHISM, (Object)false);
        this.f_19804_.m_135372_(RESTING, (Object)false);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22280_, 2.0);
    }

    protected PathNavigation m_6037_(Level p_27815_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_27815_){

            public boolean m_6342_(BlockPos p_27947_) {
                return !this.f_26495_.m_8055_(p_27947_.m_7495_()).m_60795_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new ButterflyFlutterTowardsGoal(this, 1.0f));
        this.f_21345_.m_25352_(1, (Goal)new ButterflyFlutterGoal(this, 1.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isResting() && !this.m_9236_().m_5776_()) {
            this.m_20256_(Vec3.f_82478_);
            boolean flag = this.m_20067_();
            if (this.f_19853_.m_8055_(this.m_20183_()).m_60795_()) {
                this.setResting(false);
                if (!flag) {
                    this.f_19853_.m_5898_(null, 1025, this.m_20183_(), 0);
                }
            } else if (this.f_19796_.m_188503_(800) == 0) {
                this.setResting(false);
                this.flight_counter = 200;
            }
        } else if (this.flight_counter > 0) {
            --this.flight_counter;
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.f_19797_ % 1000 == 0 && this.wantsToBreed() && !this.isMale()) {
                this.breed();
            }
            if (this.f_19853_.m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
        }
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity p_27415_) {
    }

    protected void m_6138_() {
    }

    public boolean m_6147_() {
        return this.isResting();
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && !this.m_5803_() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.f_19853_.m_45976_(EntityButterfly.class, this.m_20191_().m_82377_(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.m_146762_(this.getPregnancyTime());
                ((EntityButterfly)list.get(0)).m_146762_(this.getPregnancyTime());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return null;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemstack.m_41720_() == Items.f_42590_ && this.m_6084_()) {
            EntityUtils.turnEntityIntoItem((LivingEntity)this, "bottle_butterfly");
            itemstack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_142535_(float p_148702_, float p_148703_, DamageSource p_148704_) {
        return false;
    }

    protected void m_7840_(double p_27419_, boolean p_27420_, BlockState p_27421_, BlockPos p_27422_) {
    }

    @Override
    public void updateAttributes() {
        this.setDimorphism(EntityButterfly.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "dimorphism") == 1);
    }

    public boolean hasDimorphism() {
        return (Boolean)this.f_19804_.m_135370_(DIMORPHISM);
    }

    private void setDimorphism(boolean dimorphism) {
        this.f_19804_.m_135381_(DIMORPHISM, (Object)dimorphism);
    }

    public boolean isResting() {
        return (Boolean)this.f_19804_.m_135370_(RESTING);
    }

    public void setResting(boolean resting) {
        this.f_19804_.m_135381_(RESTING, (Object)resting);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hasDimorphism", this.hasDimorphism());
        compound.m_128379_("resting", this.isResting());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDimorphism(compound.m_128471_("hasDimorphism"));
        this.setResting(compound.m_128471_("resting"));
    }

    @Override
    public ResourceLocation getTexture() {
        ResourceLocation texture_path = EntityUtils.getSkinFromEntity(this);
        if (this.hasDimorphism()) {
            String trimmed_path = texture_path.m_135815_().substring(0, texture_path.m_135815_().lastIndexOf(46));
            return new ResourceLocation("untamedwilds", trimmed_path + "_" + this.getGenderString() + ".png");
        }
        return texture_path;
    }

    public boolean m_29443_() {
        return !this.isResting();
    }
}

