/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.unique;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import untamedwilds.entity.mammal.EntityBear;
import untamedwilds.util.EntityUtils;

public class BearRaidChestsGoal
extends MoveToBlockGoal {
    private Container targetInventory;
    private final EntityBear taskOwner;
    private final int executionChance;
    private int searchCooldown;

    public BearRaidChestsGoal(EntityBear entityIn, int chance) {
        super((PathfinderMob)entityIn, 1.0, 10, 3);
        this.taskOwner = entityIn;
        this.executionChance = chance;
        this.searchCooldown = 100;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.taskOwner.m_21824_() || !this.taskOwner.m_20096_() || this.taskOwner.getHunger() > 60 || this.taskOwner.m_217043_().m_188503_(this.executionChance) != 0 || this.taskOwner.m_5448_() != null) {
            return false;
        }
        return super.m_8036_();
    }

    public void m_8056_() {
        this.taskOwner.m_21573_().m_26519_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 1.0);
        super.m_8056_();
    }

    public void m_8041_() {
        this.taskOwner.setSitting(false);
        super.m_8041_();
    }

    public void m_8037_() {
        if (this.taskOwner.m_20275_(this.f_25602_.m_123341_(), this.f_25602_.m_123342_(), this.f_25602_.m_123343_()) < 4.0) {
            this.taskOwner.m_21563_().m_24950_((double)this.f_25602_.m_123341_(), (double)((float)this.f_25602_.m_123342_() + 1.5f), (double)this.f_25602_.m_123343_(), 10.0f, (float)this.taskOwner.m_8132_());
            this.taskOwner.m_21573_().m_26573_();
            this.taskOwner.setSitting(true);
            --this.searchCooldown;
            BlockEntity blockEntity = this.taskOwner.f_19853_.m_7702_(this.f_25602_);
            if (blockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                this.taskOwner.f_19853_.m_7696_(this.f_25602_, chest.m_58900_().m_60734_(), 1, 1);
            }
            if (this.searchCooldown == 0) {
                this.searchCooldown = 100;
                this.stealItem();
            }
        }
        super.m_8037_();
    }

    protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
        if (worldIn.m_7702_(pos) != null && BearRaidChestsGoal.getInventoryAtPosition(worldIn, pos) != null && !BearRaidChestsGoal.isInventoryEmpty(BearRaidChestsGoal.getInventoryAtPosition(worldIn, pos), Direction.UP)) {
            this.targetInventory = BearRaidChestsGoal.getInventoryAtPosition(worldIn, pos);
            this.f_25602_ = pos;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.taskOwner.getHunger() >= 60 || this.targetInventory.m_7983_() || this.f_25601_ > 1200) {
            BlockEntity blockEntity = this.taskOwner.f_19853_.m_7702_(this.f_25602_);
            if (blockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                this.taskOwner.f_19853_.m_7696_(this.f_25602_, chest.m_58900_().m_60734_(), 1, 0);
            }
            return false;
        }
        return true;
    }

    private boolean stealItem() {
        block7: {
            if (this.targetInventory == null) break block7;
            Direction enumfacing = Direction.DOWN;
            if (BearRaidChestsGoal.isInventoryEmpty(this.targetInventory, enumfacing)) {
                return false;
            }
            Container container = this.targetInventory;
            if (container instanceof WorldlyContainer) {
                int[] aint;
                WorldlyContainer isidedinventory = (WorldlyContainer)container;
                for (int i : aint = isidedinventory.m_7071_(enumfacing)) {
                    ItemStack itemstack = this.targetInventory.m_8020_(i);
                    if (itemstack.m_41619_() || !BearRaidChestsGoal.canExtractItemFromSlot(this.targetInventory, itemstack, i, enumfacing)) continue;
                    EntityUtils.consumeItemStack(this.taskOwner, itemstack);
                    if (!itemstack.m_41720_().m_41472_() && PotionUtils.m_43547_((ItemStack)itemstack).isEmpty()) {
                        this.taskOwner.m_5552_(itemstack, 0.2f);
                    }
                    return true;
                }
            } else {
                int j = this.targetInventory.m_6643_();
                for (int k = 0; k < j; ++k) {
                    ItemStack itemstack = this.targetInventory.m_8020_(k);
                    if (itemstack.m_41619_() || !BearRaidChestsGoal.canExtractItemFromSlot(this.targetInventory, itemstack, k, enumfacing)) continue;
                    this.targetInventory.m_6836_(k, ItemStack.f_41583_);
                    this.taskOwner.setAnimation(EntityBear.ATTACK_SWIPE);
                    EntityUtils.consumeItemStack(this.taskOwner, itemstack);
                    if (!itemstack.m_41720_().m_41472_() && PotionUtils.m_43547_((ItemStack)itemstack).isEmpty()) {
                        this.taskOwner.m_5552_(itemstack, 0.2f);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static Container getInventoryAtPosition(LevelReader worldIn, BlockPos pos) {
        BlockEntity tileentity;
        Container iinventory = null;
        if (worldIn.m_7702_(pos) != null && (tileentity = worldIn.m_7702_(pos)) instanceof Container) {
            iinventory = (Container)tileentity;
        }
        return iinventory;
    }

    private static boolean isInventoryEmpty(Container inventoryIn, Direction side) {
        if (inventoryIn instanceof WorldlyContainer) {
            int[] aint;
            WorldlyContainer isidedinventory = (WorldlyContainer)inventoryIn;
            for (int i : aint = isidedinventory.m_7071_(side)) {
                if (isidedinventory.m_8020_(i).m_41619_()) continue;
                return false;
            }
        } else {
            int j = inventoryIn.m_6643_();
            for (int k = 0; k < j; ++k) {
                if (inventoryIn.m_8020_(k).m_41619_()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canExtractItemFromSlot(Container inventoryIn, ItemStack stack, int index, Direction side) {
        return !(inventoryIn instanceof WorldlyContainer) || ((WorldlyContainer)inventoryIn).m_7157_(index, stack, side);
    }

    public double m_8052_() {
        return 0.5;
    }
}

