/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class MeleeAttackCircle
extends Goal {
    protected final PathfinderMob attacker;
    protected int attackTick;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private float extraReach;
    private long field_220720_k;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    private byte invert = 1;

    public MeleeAttackCircle(PathfinderMob entityIn, double speedIn, boolean useLongMemory) {
        this(entityIn, speedIn, useLongMemory, 0.0f);
    }

    public MeleeAttackCircle(PathfinderMob entityIn, double speedIn, boolean useLongMemory, float reach) {
        this.attacker = entityIn;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.extraReach = reach;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.attacker.m_6162_()) {
            return false;
        }
        long i = this.attacker.f_19853_.m_46467_();
        if (i - this.field_220720_k < 20L) {
            return false;
        }
        this.field_220720_k = i;
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.path = this.attacker.m_21573_().m_6570_((Entity)livingentity, 0);
                this.delayCounter = 4 + this.attacker.m_217043_().m_188503_(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.attacker.m_21573_().m_6570_((Entity)livingentity, 0);
        return this.path != null;
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity == null || this.attacker.m_20146_() < 40 && !this.attacker.m_6040_() || !livingentity.m_6084_()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.m_21573_().m_26571_();
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.attacker.m_21573_().m_26536_(this.path, this.speedTowardsTarget);
        this.attacker.m_21561_(true);
        this.delayCounter = 0;
    }

    public void m_8041_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity == null || !TargetingConditions.m_148352_().m_26885_((LivingEntity)this.attacker, livingentity)) {
            this.attacker.m_6710_(null);
        }
        this.attacker.m_21561_(false);
        this.attacker.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        double d0 = this.attacker.m_20275_(livingentity.m_20185_(), livingentity.m_20191_().f_82289_, livingentity.m_20189_());
        --this.delayCounter;
        if ((this.longMemory || this.attacker.m_21574_().m_148306_((Entity)livingentity)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingentity.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.m_217043_().m_188501_() < 0.05f)) {
            this.targetX = livingentity.m_20185_();
            this.targetY = livingentity.m_20191_().f_82289_;
            this.targetZ = livingentity.m_20189_();
            if (this.attacker.f_19797_ % 400 == 0) {
                this.invert = (byte)(this.invert * -1);
            }
            if (this.attacker.f_19797_ % 400 > 80) {
                if (this.attacker.m_5448_() != null && this.attacker.f_19797_ % 10 == 0) {
                    double x = this.attacker.m_5448_().m_20185_() + Math.cos((float)this.attacker.f_19797_ / 60.0f) * 10.0 * (double)this.invert;
                    double z = this.attacker.m_5448_().m_20189_() + Math.sin((float)this.attacker.f_19797_ / 60.0f) * 10.0 * (double)this.invert;
                    this.attacker.m_21573_().m_26519_(x, this.attacker.m_5448_().m_20186_(), z, (double)2.3f);
                }
            } else {
                this.attacker.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                this.delayCounter = 4 + this.attacker.m_217043_().m_188503_(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.delayCounter += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.attacker.m_21573_().m_26570_() != null ? ((finalPathPoint = this.attacker.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.delayCounter += 10;
                } else if (d0 > 256.0) {
                    this.delayCounter += 5;
                }
                if (!this.attacker.m_21573_().m_5624_((Entity)livingentity, this.speedTowardsTarget * 1.5)) {
                    this.delayCounter += 15;
                }
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.checkAndPerformAttack(livingentity, this.attacker.m_20275_(this.targetX, this.targetY, this.targetZ));
    }

    protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
        double d0 = this.getAttackReachSqr(enemy);
        if (this.attacker.m_142582_((Entity)enemy) && distToEnemySqr <= d0 && this.attackTick <= 0) {
            this.attackTick = 20;
            this.attacker.m_7327_((Entity)enemy);
            this.attacker.m_21563_().m_24960_((Entity)enemy, 30.0f, 30.0f);
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.attacker.m_20205_() * 2.0f * this.attacker.m_20205_() * 2.0f + attackTarget.m_20205_() + this.extraReach;
    }
}

