/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import untamedwilds.entity.ComplexMobAquatic;

public class FishBreachGoal
extends Goal {
    private static final int[] JUMP_DISTANCES = new int[]{0, 1, 3, 4};
    private final ComplexMobAquatic taskOwner;
    private final int chance;
    private boolean inWater;
    private final boolean safeJumping;

    public FishBreachGoal(ComplexMobAquatic entityIn, int chance) {
        this(entityIn, chance, true);
    }

    public FishBreachGoal(ComplexMobAquatic entityIn, int chance, boolean safeJumping) {
        this.taskOwner = entityIn;
        this.chance = chance;
        this.safeJumping = safeJumping;
    }

    public boolean m_8036_() {
        if (this.taskOwner.m_217043_().m_188503_(this.chance) != 0) {
            return false;
        }
        Direction direction = this.taskOwner.m_6374_();
        int i = direction.m_122429_();
        int j = direction.m_122431_();
        BlockPos blockpos = this.taskOwner.m_20183_();
        for (int k : JUMP_DISTANCES) {
            if (this.isAirAbove(blockpos, i, j, k) && (!this.safeJumping || this.canJumpTo(blockpos, i, j, k))) continue;
            return false;
        }
        return true;
    }

    private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
        BlockPos blockpos = pos.m_7918_(dx * scale, 0, dz * scale);
        return this.taskOwner.f_19853_.m_6425_(blockpos).m_205070_(FluidTags.f_13131_) && !this.taskOwner.f_19853_.m_8055_(blockpos).m_60767_().m_76334_();
    }

    private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
        return this.taskOwner.f_19853_.m_8055_(pos.m_7918_(dx * scale, 1, dz * scale)).m_60795_() && this.taskOwner.f_19853_.m_8055_(pos.m_7918_(dx * scale, 2, dz * scale)).m_60795_();
    }

    public boolean m_8045_() {
        double d0 = this.taskOwner.m_20184_().f_82480_;
        return !(d0 * d0 < (double)0.03f && this.taskOwner.m_146909_() != 0.0f && Math.abs(this.taskOwner.m_146909_()) < 10.0f && this.taskOwner.m_20069_() || this.taskOwner.m_20096_());
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        Direction direction = this.taskOwner.m_6374_();
        this.taskOwner.m_20256_(this.taskOwner.m_20184_().m_82520_((double)direction.m_122429_() * 0.6, 0.6, (double)direction.m_122431_() * 0.6));
        this.taskOwner.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.taskOwner.m_146926_(0.0f);
    }

    public void m_8037_() {
        boolean flag = this.inWater;
        if (!flag) {
            FluidState fluidstate = this.taskOwner.f_19853_.m_6425_(this.taskOwner.m_20183_());
            this.inWater = fluidstate.m_205070_(FluidTags.f_13131_);
        }
        if (this.inWater && !flag) {
            this.taskOwner.m_5496_(SoundEvents.f_11805_, 1.0f, 1.0f);
        }
        Vec3 vec3 = this.taskOwner.m_20184_();
        if (vec3.f_82480_ * vec3.f_82480_ < (double)0.03f && this.taskOwner.m_146909_() != 0.0f) {
            this.taskOwner.m_146926_(Mth.m_14201_((float)this.taskOwner.m_146909_(), (float)0.0f, (float)0.2f));
        } else if (vec3.m_82553_() > (double)1.0E-5f) {
            double d0 = vec3.m_165924_();
            double d1 = Math.atan2(-vec3.f_82480_, d0) * 57.2957763671875;
            this.taskOwner.m_146926_((float)d1);
        }
    }
}

