/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.client.model;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import net.minecraft.util.Mth;
import untamedwilds.entity.fish.EntitySawfish;

public class ModelSawfish
extends AdvancedEntityModel<EntitySawfish> {
    public AdvancedModelBox body_main;
    public AdvancedModelBox head_main;
    public AdvancedModelBox fin_right;
    public AdvancedModelBox body_2;
    public AdvancedModelBox fin_left;
    public AdvancedModelBox head_rostrum;
    public AdvancedModelBox head_teeth;
    public AdvancedModelBox body_3;
    public AdvancedModelBox fin_pelvic_right;
    public AdvancedModelBox fin_pelvic_left;
    public AdvancedModelBox fin_dorsal;
    public AdvancedModelBox tail_fin;
    public AdvancedModelBox fin_dorsal_1;
    private final ModelAnimator animator;
    private static AdvancedModelBox[] bodyParts_passive;

    public ModelSawfish() {
        this.texWidth = 64;
        this.texHeight = 64;
        this.fin_left = new AdvancedModelBox((AdvancedEntityModel)this, 0, 37);
        this.fin_left.setRotationPoint(1.0f, 1.49f, 0.0f);
        this.fin_left.addBox(0.0f, -1.0f, 0.0f, 8.0f, 2.0f, 8.0f, 0.0f);
        this.setRotateAngle(this.fin_left, 0.0f, 1.0471976f, 0.0f);
        this.fin_pelvic_left = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.fin_pelvic_left.setRotationPoint(4.0f, 0.99f, -1.0f);
        this.fin_pelvic_left.addBox(-6.0f, -1.0f, 0.0f, 6.0f, 2.0f, 6.0f, 0.0f);
        this.setRotateAngle(this.fin_pelvic_left, 0.0f, 0.91053826f, 0.0f);
        this.fin_dorsal = new AdvancedModelBox((AdvancedEntityModel)this, 48, 0);
        this.fin_dorsal.setRotationPoint(0.0f, -2.0f, -2.0f);
        this.fin_dorsal.addBox(-1.0f, -8.0f, 0.0f, 2.0f, 8.0f, 5.0f, 0.0f);
        this.setRotateAngle(this.fin_dorsal, -0.3642502f, 0.0f, 0.0f);
        this.fin_pelvic_right = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.fin_pelvic_right.mirror = true;
        this.fin_pelvic_right.setRotationPoint(-4.0f, 0.99f, -1.0f);
        this.fin_pelvic_right.addBox(0.0f, -1.0f, 0.0f, 6.0f, 2.0f, 6.0f, 0.0f);
        this.setRotateAngle(this.fin_pelvic_right, 0.0f, -0.91053826f, 0.0f);
        this.fin_right = new AdvancedModelBox((AdvancedEntityModel)this, 0, 37);
        this.fin_right.mirror = true;
        this.fin_right.setRotationPoint(-1.0f, 1.49f, 0.0f);
        this.fin_right.addBox(-8.0f, -1.0f, 0.0f, 8.0f, 2.0f, 8.0f, 0.0f);
        this.setRotateAngle(this.fin_right, 0.0f, -1.0471976f, 0.0f);
        this.head_rostrum = new AdvancedModelBox((AdvancedEntityModel)this, 22, 44);
        this.head_rostrum.setRotationPoint(0.0f, 0.0f, -8.0f);
        this.head_rostrum.addBox(-1.5f, 0.0f, -18.0f, 3.0f, 2.0f, 18.0f, 0.0f);
        this.body_main = new AdvancedModelBox((AdvancedEntityModel)this, 12, 0);
        this.body_main.setRotationPoint(0.0f, 21.5f, 0.0f);
        this.body_main.addBox(-5.0f, -2.5f, -8.0f, 10.0f, 5.0f, 16.0f, 0.0f);
        this.head_main = new AdvancedModelBox((AdvancedEntityModel)this, 0, 48);
        this.head_main.setRotationPoint(0.0f, 0.5f, -8.0f);
        this.head_main.addBox(-4.0f, -2.0f, -8.0f, 8.0f, 4.0f, 8.0f, 0.0f);
        this.fin_dorsal_1 = new AdvancedModelBox((AdvancedEntityModel)this, 48, 0);
        this.fin_dorsal_1.setRotationPoint(0.0f, -2.0f, -2.0f);
        this.fin_dorsal_1.addBox(-1.0f, -6.0f, 0.0f, 2.0f, 7.0f, 5.0f, 0.0f);
        this.setRotateAngle(this.fin_dorsal_1, -0.3642502f, 0.0f, 0.0f);
        this.body_2 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 21);
        this.body_2.setRotationPoint(0.0f, 0.5f, 8.0f);
        this.body_2.addBox(-3.5f, -2.0f, 0.0f, 7.0f, 4.0f, 12.0f, 0.0f);
        this.tail_fin = new AdvancedModelBox((AdvancedEntityModel)this, 48, 40);
        this.tail_fin.setRotationPoint(0.0f, -2.0f, 10.0f);
        this.tail_fin.addBox(-1.0f, -8.0f, 0.0f, 2.0f, 12.0f, 6.0f, 0.0f);
        this.setRotateAngle(this.tail_fin, -0.59184116f, 0.0f, 0.0f);
        this.body_3 = new AdvancedModelBox((AdvancedEntityModel)this, 30, 25);
        this.body_3.setRotationPoint(0.0f, 0.5f, 12.0f);
        this.body_3.addBox(-2.0f, -1.5f, 0.0f, 4.0f, 3.0f, 12.0f, 0.0f);
        this.head_teeth = new AdvancedModelBox((AdvancedEntityModel)this, 34, 21);
        this.head_teeth.setRotationPoint(0.0f, 1.5f, 0.0f);
        this.head_teeth.addBox(-3.5f, 0.0f, -17.0f, 7.0f, 0.0f, 16.0f, 0.0f);
        this.body_main.addChild((BasicModelPart)this.fin_left);
        this.body_2.addChild((BasicModelPart)this.fin_pelvic_left);
        this.body_2.addChild((BasicModelPart)this.fin_dorsal);
        this.body_2.addChild((BasicModelPart)this.fin_pelvic_right);
        this.body_main.addChild((BasicModelPart)this.fin_right);
        this.head_main.addChild((BasicModelPart)this.head_rostrum);
        this.body_main.addChild((BasicModelPart)this.head_main);
        this.body_3.addChild((BasicModelPart)this.fin_dorsal_1);
        this.body_main.addChild((BasicModelPart)this.body_2);
        this.body_3.addChild((BasicModelPart)this.tail_fin);
        this.body_2.addChild((BasicModelPart)this.body_3);
        this.head_rostrum.addChild((BasicModelPart)this.head_teeth);
        bodyParts_passive = new AdvancedModelBox[]{this.head_main, this.body_main, this.body_2, this.body_main, this.tail_fin};
        this.animator = ModelAnimator.create();
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body_main);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body_main, (Object)this.head_main, (Object)this.fin_right, (Object)this.body_2, (Object)this.fin_left, (Object)this.head_rostrum, (Object)this.head_teeth, (Object)this.body_3, (Object)this.fin_pelvic_right, (Object)this.fin_pelvic_left, (Object)this.fin_dorsal, (Object)this.tail_fin, (Object[])new AdvancedModelBox[]{this.fin_dorsal_1});
    }

    private void animate(IAnimatedEntity entityIn) {
        this.animator.update(entityIn);
        this.animator.setAnimation(EntitySawfish.ATTACK_THRASH);
        this.animator.startKeyframe(5);
        this.rotate(this.animator, this.head_main, -5.22f, 15.65f, -20.87f);
        this.animator.endKeyframe();
        int head_offset = -1;
        for (int i = 0; i < 6; ++i) {
            this.animator.startKeyframe(4);
            this.rotate(this.animator, this.head_main, -5.22f, 30.0f * (float)head_offset, -20.87f);
            head_offset *= -1;
            this.animator.endKeyframe();
        }
        this.animator.resetKeyframe(4);
    }

    public void setupAnim(EntitySawfish shark, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(shark);
        float globalSpeed = 0.6f;
        float globalDegree = 1.0f;
        this.body_main.defaultPositionY = shark.isBurrowing() ? 24.0f : 21.5f;
        this.body_main.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.08f), (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.08f), 1.0f);
        if (shark.m_20069_()) {
            this.setRotateAngle(this.body_main, shark.m_146909_() * ((float)Math.PI / 180), 0.0f, 0.0f);
        }
        this.chainSwing(bodyParts_passive, globalSpeed * 0.8f, globalDegree, -5.0, limbSwing / 3.0f, Math.max(0.3f, limbSwingAmount));
        float partialTicks = ageInTicks - (float)shark.f_19797_;
        float renderYaw = (float)shark.getMovementOffsets(0, partialTicks)[0];
        this.body_2.rotateAngleY += this.smartClamp((float)shark.getMovementOffsets(15, partialTicks)[0] - renderYaw, -20, 20) * ((float)Math.PI / 180);
        this.body_2.rotateAngleY += this.smartClamp((float)shark.getMovementOffsets(17, partialTicks)[0] - renderYaw, -20, 20) * ((float)Math.PI / 180);
        this.body_main.rotateAngleZ += this.smartClamp((float)shark.getMovementOffsets(7, partialTicks)[0] - renderYaw, -10, 10) * ((float)Math.PI / 180);
    }

    public float smartClamp(float angle, int min, int max) {
        float val = Math.abs(angle);
        if (val > 180.0f) {
            angle = 360.0f - val;
        }
        return Mth.m_14036_((float)angle, (float)min, (float)max);
    }
}

