/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.client.model;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import net.minecraft.util.Mth;
import untamedwilds.entity.reptile.EntityMonitor;

public class ModelMonitor
extends AdvancedEntityModel<EntityMonitor> {
    private final AdvancedModelBox main_body;
    private final AdvancedModelBox head_neck;
    private final AdvancedModelBox arm_left;
    private final AdvancedModelBox leg_left;
    private final AdvancedModelBox tail_1;
    private final AdvancedModelBox arm_right;
    private final AdvancedModelBox leg_right;
    private final AdvancedModelBox head_face;
    private final AdvancedModelBox head_snout;
    private final AdvancedModelBox head_jaw;
    private final AdvancedModelBox head_tongue;
    private final AdvancedModelBox arm_left_2;
    private final AdvancedModelBox arm_left_hand;
    private final AdvancedModelBox leg_left_2;
    private final AdvancedModelBox leg_left_feet;
    private final AdvancedModelBox tail_2;
    private final AdvancedModelBox arm_right_2;
    private final AdvancedModelBox arm_right_hand;
    private final AdvancedModelBox leg_right_2;
    private final AdvancedModelBox leg_right_feet;
    private final ModelAnimator animator;

    public ModelMonitor() {
        this.texWidth = 64;
        this.texHeight = 32;
        this.main_body = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.main_body.setRotationPoint(0.0f, 20.2f, 0.0f);
        this.main_body.addBox(-3.0f, -3.0f, -6.0f, 6.0f, 5.0f, 12.0f, 0.0f);
        this.leg_right_2 = new AdvancedModelBox((AdvancedEntityModel)this, 24, 6);
        this.leg_right_2.setRotationPoint(0.1f, 3.0f, 0.0f);
        this.leg_right_2.addBox(-1.0f, 0.0f, -1.5f, 2.0f, 3.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.leg_right_2, 0.4098033f, 0.045553092f, -0.3642502f);
        this.tail_1 = new AdvancedModelBox((AdvancedEntityModel)this, 36, 0);
        this.tail_1.setRotationPoint(0.0f, -0.9f, 4.0f);
        this.tail_1.addBox(-1.5f, -2.0f, 0.0f, 3.0f, 4.0f, 10.0f, 0.0f);
        this.setRotateAngle(this.tail_1, -0.31869712f, 0.0f, 0.0f);
        this.head_face = new AdvancedModelBox((AdvancedEntityModel)this, 18, 17);
        this.head_face.setRotationPoint(0.0f, -0.9f, -3.4f);
        this.head_face.addBox(-2.0f, -2.0f, -3.0f, 4.0f, 4.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.head_face, 0.22759093f, 0.0f, 0.0f);
        this.head_snout = new AdvancedModelBox((AdvancedEntityModel)this, 14, 24);
        this.head_snout.setRotationPoint(0.0f, -1.0f, -3.0f);
        this.head_snout.addBox(-1.5f, -1.0f, -4.0f, 3.0f, 3.0f, 4.0f, 0.0f);
        this.leg_right = new AdvancedModelBox((AdvancedEntityModel)this, 24, 0);
        this.leg_right.setRotationPoint(-3.0f, -1.9f, 4.8f);
        this.leg_right.addBox(-1.0f, 0.0f, -1.5f, 2.0f, 4.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.leg_right, -0.4098033f, 0.045553092f, 0.3642502f);
        this.leg_right_feet = new AdvancedModelBox((AdvancedEntityModel)this, 33, 0);
        this.leg_right_feet.mirror = true;
        this.leg_right_feet.setRotationPoint(0.5f, 3.01f, -1.5f);
        this.leg_right_feet.addBox(-2.0f, 0.0f, -2.5f, 4.0f, 0.0f, 5.0f, 0.0f);
        this.head_neck = new AdvancedModelBox((AdvancedEntityModel)this, 0, 17);
        this.head_neck.setRotationPoint(0.0f, -0.3f, -5.5f);
        this.head_neck.addBox(-2.5f, -2.5f, -4.0f, 5.0f, 5.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.head_neck, -0.22759093f, 0.013037238f, 0.0f);
        this.arm_left_hand = new AdvancedModelBox((AdvancedEntityModel)this, 33, 0);
        this.arm_left_hand.setRotationPoint(-0.5f, 3.01f, -1.1f);
        this.arm_left_hand.addBox(-2.0f, 0.0f, -2.5f, 4.0f, 0.0f, 5.0f, 0.0f);
        this.leg_left_feet = new AdvancedModelBox((AdvancedEntityModel)this, 33, 0);
        this.leg_left_feet.setRotationPoint(-0.5f, 3.01f, -1.5f);
        this.leg_left_feet.addBox(-2.0f, 0.0f, -2.5f, 4.0f, 0.0f, 5.0f, 0.0f);
        this.arm_right_2 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 6);
        this.arm_right_2.setRotationPoint(0.0f, 2.0f, 0.0f);
        this.arm_right_2.addBox(-1.0f, 0.0f, -1.5f, 2.0f, 3.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.arm_right_2, 0.0f, -0.045553092f, -0.5462881f);
        this.leg_left_2 = new AdvancedModelBox((AdvancedEntityModel)this, 24, 6);
        this.leg_left_2.mirror = true;
        this.leg_left_2.setRotationPoint(-0.1f, 3.0f, 0.0f);
        this.leg_left_2.addBox(-1.0f, 0.0f, -1.5f, 2.0f, 3.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.leg_left_2, 0.4098033f, -0.045553092f, 0.3642502f);
        this.arm_right_hand = new AdvancedModelBox((AdvancedEntityModel)this, 33, 0);
        this.arm_right_hand.mirror = true;
        this.arm_right_hand.setRotationPoint(0.5f, 3.01f, -1.1f);
        this.arm_right_hand.addBox(-2.0f, 0.0f, -2.5f, 4.0f, 0.0f, 5.0f, 0.0f);
        this.leg_left = new AdvancedModelBox((AdvancedEntityModel)this, 24, 0);
        this.leg_left.mirror = true;
        this.leg_left.setRotationPoint(3.0f, -1.9f, 4.8f);
        this.leg_left.addBox(-1.0f, 0.0f, -1.5f, 2.0f, 4.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.leg_left, -0.4098033f, -0.045553092f, -0.3642502f);
        this.tail_2 = new AdvancedModelBox((AdvancedEntityModel)this, 40, 14);
        this.tail_2.setRotationPoint(0.0f, 0.5f, 9.0f);
        this.tail_2.addBox(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 10.0f, 0.0f);
        this.setRotateAngle(this.tail_2, 0.22759093f, 0.0f, 0.0f);
        this.arm_left_2 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 6);
        this.arm_left_2.mirror = true;
        this.arm_left_2.setRotationPoint(0.0f, 2.0f, 0.0f);
        this.arm_left_2.addBox(-1.0f, 0.0f, -1.5f, 2.0f, 3.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.arm_left_2, 0.0f, 0.045553092f, 0.5462881f);
        this.arm_left = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.arm_left.mirror = true;
        this.arm_left.setRotationPoint(2.8f, -1.0f, -5.2f);
        this.arm_left.addBox(-1.0f, 0.0f, -1.5f, 2.0f, 2.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.arm_left, 0.0f, 0.045553092f, -0.5462881f);
        this.head_jaw = new AdvancedModelBox((AdvancedEntityModel)this, 0, 26);
        this.head_jaw.setRotationPoint(0.0f, 1.0f, -3.0f);
        this.head_jaw.addBox(-1.5f, 0.0f, -4.0f, 3.0f, 1.0f, 4.0f, 0.0f);
        this.head_tongue = new AdvancedModelBox((AdvancedEntityModel)this, 22, 26);
        this.head_tongue.setRotationPoint(0.0f, -0.01f, 0.0f);
        this.head_tongue.addBox(-1.5f, 0.0f, -4.0f, 3.0f, 0.0f, 6.0f, 0.0f);
        this.arm_right = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.arm_right.setRotationPoint(-2.8f, -1.0f, -5.2f);
        this.arm_right.addBox(-1.0f, 0.0f, -1.5f, 2.0f, 2.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.arm_right, 0.0f, -0.045553092f, 0.5462881f);
        this.leg_right.addChild((BasicModelPart)this.leg_right_2);
        this.main_body.addChild((BasicModelPart)this.tail_1);
        this.head_neck.addChild((BasicModelPart)this.head_face);
        this.head_face.addChild((BasicModelPart)this.head_snout);
        this.main_body.addChild((BasicModelPart)this.leg_right);
        this.leg_right_2.addChild((BasicModelPart)this.leg_right_feet);
        this.main_body.addChild((BasicModelPart)this.head_neck);
        this.arm_left_2.addChild((BasicModelPart)this.arm_left_hand);
        this.leg_left_2.addChild((BasicModelPart)this.leg_left_feet);
        this.arm_right.addChild((BasicModelPart)this.arm_right_2);
        this.leg_left.addChild((BasicModelPart)this.leg_left_2);
        this.arm_right_2.addChild((BasicModelPart)this.arm_right_hand);
        this.main_body.addChild((BasicModelPart)this.leg_left);
        this.tail_1.addChild((BasicModelPart)this.tail_2);
        this.arm_left.addChild((BasicModelPart)this.arm_left_2);
        this.main_body.addChild((BasicModelPart)this.arm_left);
        this.head_face.addChild((BasicModelPart)this.head_jaw);
        this.head_jaw.addChild((BasicModelPart)this.head_tongue);
        this.main_body.addChild((BasicModelPart)this.arm_right);
        this.animator = ModelAnimator.create();
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.main_body);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.main_body, (Object)this.head_neck, (Object)this.arm_left, (Object)this.leg_left, (Object)this.tail_1, (Object)this.arm_right, (Object)this.leg_right, (Object)this.head_face, (Object)this.head_snout, (Object)this.head_jaw, (Object)this.head_tongue, (Object)this.arm_left_2, (Object[])new AdvancedModelBox[]{this.arm_left_hand, this.leg_left_2, this.leg_left_feet, this.tail_2, this.arm_right_2, this.arm_right_hand, this.leg_right_2, this.leg_right_feet});
    }

    private void animate(IAnimatedEntity entityIn) {
        EntityMonitor monitor = (EntityMonitor)entityIn;
        this.animator.update((IAnimatedEntity)monitor);
        this.animator.setAnimation(EntityMonitor.ATTACK_THRASH);
        int invert = 1;
        for (int i = 0; i < 4; ++i) {
            this.animator.startKeyframe(6);
            this.rotate(this.animator, this.head_neck, 0.0f, 22.73f * (float)invert, 0.0f);
            this.rotate(this.animator, this.head_face, -5.21f, 15.65f * (float)invert, 31.3f * (float)invert);
            this.rotate(this.animator, this.head_jaw, 20.87f, 0.0f, 0.0f);
            invert *= -1;
            this.animator.endKeyframe();
        }
        this.animator.resetKeyframe(6);
        this.animator.setAnimation(EntityMonitor.IDLE_TONGUE);
        this.animator.startKeyframe(4);
        this.rotate(this.animator, this.head_tongue, 26.08f, 36.52f, 0.0f);
        this.animator.move(this.head_tongue, 0.0f, 0.0f, -4.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.rotate(this.animator, this.head_tongue, -26.08f, -36.52f, 0.0f);
        this.animator.move(this.head_tongue, 0.0f, 0.0f, -5.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(10);
    }

    public void setupAnim(EntityMonitor monitor, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(monitor);
        float globalSpeed = 0.8f;
        float globalDegree = 1.0f;
        limbSwingAmount = Math.min(0.6f, limbSwingAmount);
        if (monitor.m_21525_()) {
            limbSwing = ageInTicks / 4.0f;
            limbSwingAmount = 0.5f;
        }
        this.main_body.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.06f), (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.06f), 1.0f);
        this.head_neck.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.06f), (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.06f), 1.0f);
        this.head_face.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.06f), (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.06f), 1.0f);
        this.tail_1.setScale(1.0f, (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.06f), 1.0f);
        if (!monitor.m_5803_()) {
            this.faceTarget(netHeadYaw, headPitch, 2.0f, new AdvancedModelBox[]{this.head_face});
        }
        if (monitor.m_20069_() && !monitor.m_20096_()) {
            this.setRotateAngle(this.main_body, monitor.m_146909_() * ((float)Math.PI / 180), 0.0f, 0.0f);
        }
        this.main_body.rotateAngleY = Mth.m_14189_((float)0.05f, (float)this.main_body.rotateAngleY, (float)monitor.offset);
        this.tail_1.rotateAngleY = Mth.m_14189_((float)0.05f, (float)this.tail_1.rotateAngleY, (float)(-1.0f * monitor.offset));
        this.tail_2.rotateAngleY = Mth.m_14189_((float)0.05f, (float)this.tail_2.rotateAngleY, (float)(-2.0f * monitor.offset));
        AdvancedModelBox[] bodyParts = new AdvancedModelBox[]{this.head_face, this.head_neck, this.main_body, this.tail_1, this.tail_2};
        this.chainSwing(bodyParts, globalSpeed * 1.4f, globalDegree * 1.2f, -4.0, limbSwing, limbSwingAmount * 0.3f);
        if (monitor.m_20069_()) {
            this.flap(this.arm_left, globalSpeed, globalDegree, false, 0.8f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.leg_left, globalSpeed, globalDegree * 0.8f, false, 1.6f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.arm_right, globalSpeed, globalDegree, false, 2.4f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.leg_right, globalSpeed, globalDegree * 0.8f, false, 3.2f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.main_body, globalSpeed / 2.0f, globalDegree * 1.2f, false, 0.0f, 0.1f, limbSwing / 2.0f, limbSwingAmount);
            this.swing(this.main_body, globalSpeed / 2.0f, globalDegree * 1.2f, false, 0.8f, 0.1f, limbSwing / 3.0f, limbSwingAmount);
            this.chainWave(new AdvancedModelBox[]{this.head_face, this.head_neck, this.main_body}, globalSpeed * 0.8f, globalDegree, -4.0, limbSwing, limbSwingAmount * 0.2f);
        } else {
            this.walk(this.arm_left, globalSpeed, globalDegree * 2.0f, false, -1.0f, 0.0f, limbSwing, limbSwingAmount);
            this.flap(this.arm_left, globalSpeed, globalDegree * 1.0f, false, 1.0f, -1.5f, limbSwing, limbSwingAmount);
            this.flap(this.arm_left_2, globalSpeed, globalDegree * 1.0f, true, -1.0f, 0.0f, limbSwing, limbSwingAmount);
            this.walk(this.arm_right, globalSpeed, globalDegree * 2.0f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
            this.flap(this.arm_right, globalSpeed, globalDegree * 1.0f, false, 2.0f, 1.5f, limbSwing, limbSwingAmount);
            this.flap(this.arm_right_2, globalSpeed, globalDegree * 1.0f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
            this.walk(this.leg_left, globalSpeed, globalDegree * 2.0f, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
            this.flap(this.leg_left, globalSpeed, globalDegree * 1.0f, false, 3.0f, 0.5f, limbSwing, limbSwingAmount);
            this.flap(this.leg_left_2, globalSpeed, globalDegree * 1.0f, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
            this.walk(this.leg_right, globalSpeed, globalDegree * 2.0f, true, 2.0f, 0.0f, limbSwing, limbSwingAmount);
            this.flap(this.leg_right, globalSpeed, globalDegree * 1.0f, false, 4.0f, 0.5f, limbSwing, limbSwingAmount);
            this.flap(this.leg_right_2, globalSpeed, globalDegree * 1.0f, true, 2.0f, 0.0f, limbSwing, limbSwingAmount);
        }
        if (monitor.m_5448_() == null && monitor.getAnimation() != EntityMonitor.ATTACK_THRASH) {
            this.setRotateAngle(this.head_neck, this.head_neck.rotateAngleX, ((Float)monitor.head_movement.getA()).floatValue(), 0.0f);
            this.setRotateAngle(this.head_face, this.head_face.rotateAngleX, ((Float)monitor.head_movement.getB()).floatValue(), 0.0f);
        }
        if (monitor.swimProgress > 0) {
            this.progressPosition(this.arm_left, monitor.swimProgress, 2.8f, 1.0f, -5.2f, 20.0f);
            this.progressRotation(this.arm_left, monitor.swimProgress, (float)Math.toRadians(93.91f), (float)Math.toRadians(18.26f), (float)Math.toRadians(-15.65f), 20.0f);
            this.progressPosition(this.arm_left_hand, monitor.swimProgress, 1.1f, 3.01f, -0.5f, 20.0f);
            this.progressRotation(this.arm_left_hand, monitor.swimProgress, 0.0f, (float)Math.toRadians(-88.7f), (float)Math.toRadians(86.09f), 20.0f);
            this.progressPosition(this.leg_left, monitor.swimProgress, 3.0f, 0.1f, 4.8f, 20.0f);
            this.progressRotation(this.leg_left, monitor.swimProgress, (float)Math.toRadians(83.48f), (float)Math.toRadians(-2.61f), (float)Math.toRadians(-20.87f), 20.0f);
            this.progressRotation(this.tail_1, monitor.swimProgress, 0.0f, 0.0f, 0.0f, 20.0f);
            this.progressRotation(this.tail_2, monitor.swimProgress, 0.0f, 0.0f, 0.0f, 20.0f);
            this.progressPosition(this.arm_right, monitor.swimProgress, -2.8f, 1.0f, -5.2f, 20.0f);
            this.progressRotation(this.arm_right, monitor.swimProgress, (float)Math.toRadians(93.91f), (float)Math.toRadians(-18.26f), (float)Math.toRadians(15.65f), 20.0f);
            this.progressPosition(this.arm_right_hand, monitor.swimProgress, -1.1f, 3.01f, -0.5f, 20.0f);
            this.progressRotation(this.arm_right_hand, monitor.swimProgress, 0.0f, (float)Math.toRadians(88.7f), (float)Math.toRadians(-86.09f), 20.0f);
            this.progressPosition(this.leg_right, monitor.swimProgress, -3.0f, 0.1f, 4.8f, 20.0f);
            this.progressRotation(this.leg_right, monitor.swimProgress, (float)Math.toRadians(83.48f), (float)Math.toRadians(2.61f), (float)Math.toRadians(20.87f), 20.0f);
        }
        if (monitor.sitProgress != 0) {
            this.progressPosition(this.head_neck, monitor.sitProgress, 0.0f, -1.3f, -5.5f, monitor.ticksToSit);
            this.progressRotation(this.head_neck, monitor.sitProgress, (float)Math.toRadians(-54.78f), (float)Math.toRadians(0.75), 0.0f, monitor.ticksToSit);
            this.progressRotation(this.head_face, monitor.sitProgress, (float)Math.toRadians(54.78f), 0.0f, 0.0f, monitor.ticksToSit);
            this.progressPosition(this.main_body, monitor.sitProgress, 0.0f, 22.4f, 0.0f, monitor.ticksToSit);
            this.progressRotation(this.arm_left, monitor.sitProgress, (float)Math.toRadians(-31.3f), (float)Math.toRadians(2.61f), (float)Math.toRadians(-54.78f), monitor.ticksToSit);
            this.progressRotation(this.arm_left_2, monitor.sitProgress, (float)Math.toRadians(-5.22f), (float)Math.toRadians(-5.22f), (float)Math.toRadians(7.83f), monitor.ticksToSit);
            this.progressPosition(this.arm_left_hand, monitor.sitProgress, -0.5f, 2.51f, -1.1f, monitor.ticksToSit);
            this.progressRotation(this.arm_left_hand, monitor.sitProgress, (float)Math.toRadians(20.87f), (float)Math.toRadians(-20.87f), (float)Math.toRadians(31.3f), monitor.ticksToSit);
            this.progressRotation(this.arm_right, monitor.sitProgress, (float)Math.toRadians(-31.3f), (float)Math.toRadians(-2.61f), (float)Math.toRadians(54.78f), monitor.ticksToSit);
            this.progressRotation(this.arm_right_2, monitor.sitProgress, (float)Math.toRadians(-5.22f), (float)Math.toRadians(5.22f), (float)Math.toRadians(-7.83f), monitor.ticksToSit);
            this.progressRotation(this.arm_right_hand, monitor.sitProgress, (float)Math.toRadians(20.87f), (float)Math.toRadians(20.87f), (float)Math.toRadians(-31.3f), monitor.ticksToSit);
            this.progressPosition(this.arm_right_hand, monitor.sitProgress, 0.5f, 2.51f, -1.1f, monitor.ticksToSit);
            this.progressPosition(this.leg_left, monitor.sitProgress, 3.0f, -0.9f, 4.8f, monitor.ticksToSit);
            this.progressRotation(this.leg_left, monitor.sitProgress, (float)Math.toRadians(49.57f), (float)Math.toRadians(-2.61f), (float)Math.toRadians(-75.65f), monitor.ticksToSit);
            this.progressPosition(this.leg_left_feet, monitor.sitProgress, 0.5f, 3.01f, -1.5f, monitor.ticksToSit);
            this.progressRotation(this.leg_left_feet, monitor.sitProgress, (float)Math.toRadians(-31.3f), (float)Math.toRadians(-36.52f), (float)Math.toRadians(88.7f), monitor.ticksToSit);
            this.progressPosition(this.leg_right, monitor.sitProgress, -3.0f, -0.9f, 4.8f, monitor.ticksToSit);
            this.progressRotation(this.leg_right, monitor.sitProgress, (float)Math.toRadians(49.57f), (float)Math.toRadians(2.61f), (float)Math.toRadians(75.65f), monitor.ticksToSit);
            this.progressPosition(this.leg_right_feet, monitor.sitProgress, -0.5f, 3.01f, -1.5f, monitor.ticksToSit);
            this.progressRotation(this.leg_right_feet, monitor.sitProgress, (float)Math.toRadians(-31.3f), (float)Math.toRadians(36.52f), (float)Math.toRadians(-88.7f), monitor.ticksToSit);
            this.progressRotation(this.tail_1, monitor.sitProgress, (float)Math.toRadians(-2.61f), this.tail_1.rotateAngleY, 0.0f, monitor.ticksToSit);
            this.progressRotation(this.tail_2, monitor.sitProgress, 0.0f, this.tail_2.rotateAngleY, 0.0f, monitor.ticksToSit);
        }
    }
}

