/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolActions;
import untamedwilds.block.IPostGenUpdate;
import untamedwilds.block.UndergrowthBlock;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModTags;

public class UndergrowthPoisonousBlock
extends UndergrowthBlock
implements BonemealableBlock,
IPostGenUpdate,
IForgeShearable {
    public static final IntegerProperty PROPERTY_AGE = BlockStateProperties.f_61406_;

    public UndergrowthPoisonousBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PROPERTY_AGE});
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && !entityIn.m_20161_() && entityIn.m_20206_() > 1.0f) {
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 1));
            entityIn.m_7601_(state, new Vec3((double)0.95f, 1.0, (double)0.95f));
            if (worldIn.m_213780_().m_188503_(20) == 0) {
                worldIn.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11992_, SoundSource.AMBIENT, 1.0f, 1.0f, true);
            }
        }
    }

    @Nullable
    public BlockState getStateForWorldgen(LevelAccessor world, BlockPos pos) {
        BlockState blockstate = world.m_8055_(pos.m_7495_());
        if (blockstate.m_60734_() == ModBlock.HEMLOCK.get()) {
            BlockState blockstate1;
            if (world.m_6425_(pos.m_7495_()).m_76178_() || world.m_8055_(pos.m_6625_(2)).m_60734_() == ModBlock.HEMLOCK.get()) {
                world.m_7731_(pos.m_7495_(), (BlockState)blockstate.m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1)), 1);
            }
            return (blockstate1 = world.m_8055_(pos.m_7494_())).m_60734_() != ModBlock.HEMLOCK.get() ? (BlockState)((Block)ModBlock.HEMLOCK.get()).m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0)) : (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1));
        }
        if (blockstate.m_204336_(ModTags.ModBlockTags.REEDS_PLANTABLE_ON)) {
            return (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0));
        }
        return null;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_().m_7495_());
        if (blockstate.m_60734_() == ModBlock.HEMLOCK.get()) {
            BlockState blockstate1;
            if (context.m_43725_().m_6425_(context.m_8083_().m_7495_()).m_76178_() || context.m_43725_().m_8055_(context.m_8083_().m_6625_(2)).m_60734_() == ModBlock.HEMLOCK.get()) {
                context.m_43725_().m_46597_(context.m_8083_().m_7495_(), (BlockState)blockstate.m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1)));
            }
            return (blockstate1 = context.m_43725_().m_8055_(context.m_8083_().m_7494_())).m_60734_() != ModBlock.HEMLOCK.get() ? (BlockState)((Block)ModBlock.HEMLOCK.get()).m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0)) : (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1));
        }
        if (blockstate.m_204336_(ModTags.ModBlockTags.REEDS_PLANTABLE_ON)) {
            return (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0));
        }
        return null;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_204336_(ModTags.ModBlockTags.REEDS_PLANTABLE_ON) || worldIn.m_8055_(pos.m_7495_()).m_60734_() == ModBlock.HEMLOCK.get();
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public void updatePostGen(LevelAccessor worldIn, BlockPos pos) {
        if (worldIn.m_213780_().m_188499_()) {
            worldIn.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1)), 3);
            worldIn.m_7731_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    @Override
    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        int j;
        int i = this.getNumReedBlocksAbove(worldIn, pos);
        return i + (j = this.getNumReedBlocksBelow(worldIn, pos)) + 1 < 3;
    }

    @Override
    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int i = this.getNumReedBlocksAbove((BlockGetter)worldIn, pos);
        int j = this.getNumReedBlocksBelow((BlockGetter)worldIn, pos);
        int k = i + j + 1;
        int l = 1 + rand.m_188503_(2);
        for (int i1 = 0; i1 < l; ++i1) {
            BlockPos blockpos = pos.m_6630_(i);
            BlockState blockstate = worldIn.m_8055_(blockpos);
            if (k >= 4 || !worldIn.m_46859_(blockpos.m_7494_())) {
                return;
            }
            if ((Integer)blockstate.m_61143_((Property)PROPERTY_AGE) != 2) {
                worldIn.m_7731_(blockpos, (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1)), 3);
            }
            worldIn.m_7731_(blockpos.m_7494_(), (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0)), 3);
            ++i;
            ++k;
        }
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        return player.m_21205_().canPerformAction(ToolActions.SWORD_DIG) ? 1.0f : super.m_5880_(state, player, worldIn, pos);
    }

    protected int getNumReedBlocksAbove(BlockGetter worldIn, BlockPos pos) {
        int i;
        for (i = 0; worldIn.m_8055_(pos.m_6630_(i + 1)).m_60734_() == ModBlock.TITAN_ARUM.get() || i > 20; ++i) {
        }
        return i;
    }

    protected int getNumReedBlocksBelow(BlockGetter worldIn, BlockPos pos) {
        int i;
        for (i = 0; worldIn.m_8055_(pos.m_6625_(i + 1)).m_60734_() == ModBlock.TITAN_ARUM.get() || i > 20; ++i) {
        }
        return i;
    }
}

